/*
 * Decompiled with CFR 0.152.
 */
package com.kittehmod.ceilands.forge.worldgen.features;

import com.kittehmod.ceilands.forge.util.MathHelper;
import com.mojang.serialization.Codec;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.BlockStateConfiguration;

public class NaturalBridgeFeature
extends Feature<BlockStateConfiguration> {
    public NaturalBridgeFeature(Codec<BlockStateConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<BlockStateConfiguration> context) {
        int diffZ;
        int diffY;
        Block refBlock;
        List<Direction> startingDirections = List.of(Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST);
        BlockState state = ((BlockStateConfiguration)context.m_159778_()).f_67547_;
        BlockPos blockpos = context.m_159777_();
        RandomSource randomsource = context.m_225041_();
        WorldGenLevel worldgenlevel = context.m_159774_();
        BlockPos pointA = null;
        BlockPos pointB = null;
        if (worldgenlevel.m_8055_(blockpos).m_60734_() != Blocks.f_50016_) {
            return false;
        }
        int dirChooser = randomsource.m_188503_(startingDirections.size());
        Direction dir = startingDirections.get(dirChooser);
        for (int fwd = 0; fwd < 12; ++fwd) {
            for (int hgt = 6; hgt > -6; --hgt) {
                for (int wdth = -5; wdth <= 5; ++wdth) {
                    refBlock = worldgenlevel.m_8055_(blockpos.m_5484_(dir, fwd).m_5484_(dir.m_122427_(), wdth).m_6630_(hgt)).m_60734_();
                    if (refBlock == Blocks.f_50016_ || refBlock != state.m_60734_()) continue;
                    pointA = blockpos.m_5484_(dir, fwd).m_5484_(dir.m_122427_(), wdth).m_6630_(hgt);
                    break;
                }
                if (pointA != null) break;
            }
            if (pointA != null) break;
        }
        block3: for (int attempt = 0; attempt < 3; ++attempt) {
            dir = dir.m_122427_();
            for (int fwd = 0; fwd < 12; ++fwd) {
                for (int hgt = 6; hgt > -6; --hgt) {
                    refBlock = worldgenlevel.m_8055_(blockpos.m_5484_(dir, fwd).m_6630_(hgt)).m_60734_();
                    if (refBlock == Blocks.f_50016_ || refBlock != state.m_60734_()) continue;
                    pointB = blockpos.m_5484_(dir, fwd).m_6630_(hgt);
                    break;
                }
                if (pointB != null) continue block3;
            }
        }
        if (pointA == null || pointB == null) {
            return false;
        }
        int diffX = Math.abs(pointA.m_123341_() - pointB.m_123341_());
        int dist = this.calculateBiggestOfThree(diffX, diffY = Math.abs(pointA.m_123342_() - pointB.m_123342_()), diffZ = Math.abs(pointA.m_123343_() - pointB.m_123343_()));
        int radiusSize = 1 + Math.max((int)Math.floor(Math.sqrt(dist)), 2);
        if (radiusSize > 3) {
            radiusSize = 3;
        }
        int archHeight = 2 + randomsource.m_188503_(Math.max(8 - diffY, 1));
        for (int i = 0; i < dist; ++i) {
            BlockPos posToSet = MathHelper.getInterpolatedBlockPos(pointA, pointB, (float)i / (float)dist);
            this.makeSphereAt(worldgenlevel, posToSet.m_6630_((int)Math.floor(Math.sin((double)((float)i / (float)dist) * Math.PI) * (double)archHeight)), state, radiusSize);
        }
        return true;
    }

    private void makeSphereAt(WorldGenLevel level, BlockPos pos, BlockState state, int radius) {
        for (int i = -radius; i < radius; ++i) {
            for (int j = -radius; j < radius; ++j) {
                for (int k = -radius; k < radius; ++k) {
                    if (!MathHelper.isPlotInSphere(i, j, k, radius)) continue;
                    this.m_5974_((LevelWriter)level, pos.m_6630_(i).m_122020_(j).m_122030_(k), state);
                }
            }
        }
    }

    private int calculateBiggestOfThree(int par1, int par2, int par3) {
        int a = Math.max(Math.abs(par1), Math.abs(par2));
        int b = Math.max(Math.abs(par2), Math.abs(par3));
        return Math.max(a, b);
    }
}

