/*
 * Decompiled with CFR 0.152.
 */
package com.kittehmod.ceilands.forge.worldgen.features;

import com.kittehmod.ceilands.forge.tags.CeilandsBlockTags;
import com.kittehmod.ceilands.forge.util.MathHelper;
import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.BlockStateConfiguration;

public class WaterOrbFeature
extends Feature<BlockStateConfiguration> {
    public WaterOrbFeature(Codec<BlockStateConfiguration> codec) {
        super(codec);
    }

    private boolean isBlockReplaceable(WorldGenLevel level, BlockPos pos) {
        return level.m_8055_(pos).m_204336_(CeilandsBlockTags.WATER_ORB_REPLACEABLES);
    }

    public boolean m_142674_(FeaturePlaceContext<BlockStateConfiguration> context) {
        int posZ;
        int posX;
        int posY;
        boolean isGlassOrb;
        BlockPos blockpos = context.m_159777_();
        RandomSource randomsource = context.m_225041_();
        WorldGenLevel worldgenlevel = context.m_159774_();
        int radius = 12 + randomsource.m_188503_(5);
        BlockState state = ((BlockStateConfiguration)context.m_159778_()).f_67547_;
        boolean bl = isGlassOrb = (double)randomsource.m_188501_() < 0.1;
        if (isGlassOrb) {
            for (posY = -radius; posY < radius; ++posY) {
                for (posX = -radius; posX < radius; ++posX) {
                    for (posZ = -radius; posZ < radius; ++posZ) {
                        if (posY == -radius && posX == 0 && posZ == 0 || !MathHelper.isPlotInSphere(posX, posY, posZ, radius) || !this.isBlockReplaceable(worldgenlevel, blockpos.m_6625_(posY).m_122030_(posX).m_122020_(posZ))) continue;
                        this.m_5974_((LevelWriter)worldgenlevel, blockpos.m_6625_(posY).m_122030_(posX).m_122020_(posZ), posY == 0 || posX == 0 || posZ == 0 ? state : Blocks.f_50058_.m_49966_());
                    }
                }
            }
        } else {
            for (posY = 0; posY < radius; ++posY) {
                for (posX = -radius; posX < radius; ++posX) {
                    for (posZ = -radius; posZ < radius; ++posZ) {
                        if (!MathHelper.isPlotInSphere(posX, posY, posZ, radius) || !this.isBlockReplaceable(worldgenlevel, blockpos.m_6625_(posY).m_122030_(posX).m_122020_(posZ))) continue;
                        this.m_5974_((LevelWriter)worldgenlevel, blockpos.m_6625_(posY).m_122030_(posX).m_122020_(posZ), state);
                    }
                }
            }
        }
        int n = posY = isGlassOrb ? -(--radius) : 0;
        while (posY < radius) {
            for (posX = -radius; posX < radius; ++posX) {
                for (posZ = -radius; posZ < radius; ++posZ) {
                    if (!MathHelper.isPlotInSphere(posX, posY, posZ, radius) || !this.isBlockReplaceable(worldgenlevel, blockpos.m_6625_(posY).m_122030_(posX).m_122020_(posZ))) continue;
                    this.m_5974_((LevelWriter)worldgenlevel, blockpos.m_6625_(posY).m_122030_(posX).m_122020_(posZ), Blocks.f_49990_.m_49966_());
                }
            }
            ++posY;
        }
        int biometype = randomsource.m_188503_(3);
        Block block = switch (biometype) {
            default -> Blocks.f_50493_;
            case 1 -> Blocks.f_49992_;
            case 2 -> Blocks.f_49994_;
        };
        for (int posY2 = radius - 3; posY2 < radius; ++posY2) {
            for (int posX2 = -radius; posX2 < radius; ++posX2) {
                for (int posZ2 = -radius; posZ2 < radius; ++posZ2) {
                    if (!MathHelper.isPlotInSphere(posX2, posY2, posZ2, radius) || !this.isBlockReplaceable(worldgenlevel, blockpos.m_6625_(posY2).m_122030_(posX2).m_122020_(posZ2))) continue;
                    this.m_5974_((LevelWriter)worldgenlevel, blockpos.m_6625_(posY2).m_122030_(posX2).m_122020_(posZ2), block.m_49966_());
                    if (posX2 != 0 || posZ2 != 0) continue;
                    this.m_5974_((LevelWriter)worldgenlevel, blockpos.m_6625_(posY2).m_122030_(posX2).m_122020_(posZ2), Blocks.f_50141_.m_49966_());
                }
            }
        }
        return true;
    }
}

