/*
 * Decompiled with CFR 0.152.
 */
package com.kittehmod.ceilands.forge.worldgen.features.trees;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.rootplacers.RootPlacer;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.shapes.BitSetDiscreteVoxelShape;
import net.minecraft.world.phys.shapes.DiscreteVoxelShape;

public class CeiltrunkTreeFeature
extends Feature<TreeConfiguration> {
    public CeiltrunkTreeFeature(Codec<TreeConfiguration> codecIn) {
        super(codecIn);
    }

    public static boolean isFree(LevelSimulatedReader p_236410_0_, BlockPos p_236410_1_) {
        return CeiltrunkTreeFeature.validTreePos(p_236410_0_, p_236410_1_) || p_236410_0_.m_7433_(p_236410_1_, p_236417_0_ -> p_236417_0_.m_204336_(BlockTags.f_13106_));
    }

    private static boolean isVine(LevelSimulatedReader p_236414_0_, BlockPos p_236414_1_) {
        return p_236414_0_.m_7433_(p_236414_1_, p_236415_0_ -> p_236415_0_.m_60713_(Blocks.f_50191_));
    }

    private static boolean isBlockWater(LevelSimulatedReader p_236416_0_, BlockPos p_236416_1_) {
        return p_236416_0_.m_7433_(p_236416_1_, p_236413_0_ -> p_236413_0_.m_60713_(Blocks.f_49990_));
    }

    public static boolean isAirOrLeaves(LevelSimulatedReader p_236412_0_, BlockPos p_236412_1_) {
        return p_236412_0_.m_7433_(p_236412_1_, p_236411_0_ -> p_236411_0_.m_60795_() || p_236411_0_.m_204336_(BlockTags.f_13035_));
    }

    private static boolean isReplaceablePlant(LevelSimulatedReader p_236419_0_, BlockPos p_236419_1_) {
        return p_236419_0_.m_7433_(p_236419_1_, p_236406_0_ -> {
            Material material = p_236406_0_.m_60767_();
            return material == Material.f_76302_;
        });
    }

    public static void setBlockKnownShape(LevelWriter p_236408_0_, BlockPos p_236408_1_, BlockState p_236408_2_) {
        p_236408_0_.m_7731_(p_236408_1_, p_236408_2_, 19);
    }

    public static boolean validTreePos(LevelSimulatedReader level, BlockPos pos) {
        return CeiltrunkTreeFeature.isAirOrLeaves(level, pos) || CeiltrunkTreeFeature.isReplaceablePlant(level, pos) || CeiltrunkTreeFeature.isBlockWater(level, pos);
    }

    private boolean doPlace(WorldGenLevel level, RandomSource source, BlockPos pos, BiConsumer<BlockPos, BlockState> p_225261_, BiConsumer<BlockPos, BlockState> p_225262_, BiConsumer<BlockPos, BlockState> p_225263_, TreeConfiguration config) {
        int trunkHeight = config.f_68190_.m_226153_(source);
        int foliageHeight = config.f_68189_.m_214116_(source, trunkHeight, config);
        int k = trunkHeight + foliageHeight;
        int l = config.f_68189_.m_214117_(source, k);
        BlockPos blockpos = config.f_225455_.map(rootplacer -> rootplacer.m_225891_(pos, source)).orElse(pos);
        int i1 = Math.min(pos.m_123342_(), blockpos.m_123342_());
        int j1 = Math.max(pos.m_123342_(), blockpos.m_123342_()) + trunkHeight + 1;
        if (!CeiltrunkTreeFeature.isFree((LevelSimulatedReader)level, pos.m_7495_())) {
            return false;
        }
        if (i1 >= level.m_141937_() + 1 && j1 <= level.m_151558_()) {
            OptionalInt optionalint = config.f_68191_.m_68295_();
            int k1 = this.getMaxFreeTreeHeight((LevelSimulatedReader)level, trunkHeight, blockpos, config);
            if (k1 >= -trunkHeight || !optionalint.isEmpty() && k1 >= optionalint.getAsInt()) {
                if (config.f_225455_.isPresent() && !((RootPlacer)config.f_225455_.get()).m_213684_((LevelSimulatedReader)level, p_225261_, source, pos, blockpos, config)) {
                    return false;
                }
                List list = config.f_68190_.m_213934_((LevelSimulatedReader)level, p_225262_, source, k1, blockpos, config);
                list.forEach(p_225279_ -> config.f_68189_.m_225604_((LevelSimulatedReader)level, p_225263_, source, config, k1, p_225279_, foliageHeight, l));
                return true;
            }
            return false;
        }
        return false;
    }

    private int getMaxFreeTreeHeight(LevelSimulatedReader reader, int height, BlockPos pos, TreeConfiguration config) {
        BlockPos.MutableBlockPos blockpos$mutable = new BlockPos.MutableBlockPos();
        for (int i = 0; i <= height + 1; ++i) {
            int j = config.f_68191_.m_6133_(height, -i);
            for (int k = -j; k <= j; ++k) {
                for (int l = -j; l <= j; ++l) {
                    blockpos$mutable.m_122154_((Vec3i)pos, k, -i, l);
                    if (CeiltrunkTreeFeature.isFree(reader, (BlockPos)blockpos$mutable) && (config.f_68193_ || !CeiltrunkTreeFeature.isVine(reader, (BlockPos)blockpos$mutable))) continue;
                    return i - 2;
                }
            }
        }
        return height;
    }

    public final boolean m_142674_(FeaturePlaceContext<TreeConfiguration> placeContxt) {
        WorldGenLevel worldgenlevel = placeContxt.m_159774_();
        RandomSource randomsource = placeContxt.m_225041_();
        BlockPos blockpos = placeContxt.m_159777_();
        TreeConfiguration treeconfiguration = (TreeConfiguration)placeContxt.m_159778_();
        HashSet set = Sets.newHashSet();
        HashSet set1 = Sets.newHashSet();
        HashSet set2 = Sets.newHashSet();
        HashSet set3 = Sets.newHashSet();
        BiConsumer<BlockPos, BlockState> biconsumer = (pos, state) -> {
            set.add(pos.m_7949_());
            worldgenlevel.m_7731_(pos, state, 19);
        };
        BiConsumer<BlockPos, BlockState> biconsumer1 = (pos, state) -> {
            set1.add(pos.m_7949_());
            worldgenlevel.m_7731_(pos, state, 19);
        };
        BiConsumer<BlockPos, BlockState> biconsumer2 = (pos, state) -> {
            set2.add(pos.m_7949_());
            worldgenlevel.m_7731_(pos, state, 19);
        };
        BiConsumer<BlockPos, BlockState> biconsumer3 = (pos, state) -> {
            set3.add(pos.m_7949_());
            worldgenlevel.m_7731_(pos, state, 19);
        };
        boolean flag = this.doPlace(worldgenlevel, randomsource, blockpos, biconsumer, biconsumer1, biconsumer2, treeconfiguration);
        if (!(!flag || set1.isEmpty() && set2.isEmpty())) {
            if (!treeconfiguration.f_68187_.isEmpty()) {
                TreeDecorator.Context treedecorator$context = new TreeDecorator.Context((LevelSimulatedReader)worldgenlevel, biconsumer3, randomsource, (Set)set1, (Set)set2, (Set)set);
                treeconfiguration.f_68187_.forEach(p_160528_ -> p_160528_.m_214187_(treedecorator$context));
            }
            return BoundingBox.m_162378_((Iterable)Iterables.concat((Iterable)set, (Iterable)set1, (Iterable)set2)).map(p_160521_ -> {
                DiscreteVoxelShape discretevoxelshape = CeiltrunkTreeFeature.updateLeaves((LevelAccessor)worldgenlevel, p_160521_, set, set2);
                StructureTemplate.m_74510_((LevelAccessor)worldgenlevel, (int)3, (DiscreteVoxelShape)discretevoxelshape, (int)p_160521_.m_162395_(), (int)p_160521_.m_162396_(), (int)p_160521_.m_162398_());
                return true;
            }).orElse(false);
        }
        return false;
    }

    private static DiscreteVoxelShape updateLeaves(LevelAccessor worldIn, BoundingBox bbIn, Set<BlockPos> p_236403_3_, Set<BlockPos> p_236403_4_) {
        ArrayList list = Lists.newArrayList();
        BitSetDiscreteVoxelShape discretevoxelshape = new BitSetDiscreteVoxelShape(bbIn.m_71056_(), bbIn.m_71057_(), bbIn.m_71058_());
        int amt = 6;
        for (int j = 0; j < amt; ++j) {
            list.add(Sets.newHashSet());
        }
        BlockPos.MutableBlockPos blockpos$mutable = new BlockPos.MutableBlockPos();
        for (BlockPos blockpos : Lists.newArrayList(p_236403_4_)) {
            if (!bbIn.m_71051_((Vec3i)blockpos)) continue;
            discretevoxelshape.m_142703_(blockpos.m_123341_() - bbIn.m_162395_(), blockpos.m_123342_() - bbIn.m_162396_(), blockpos.m_123343_() - bbIn.m_162398_());
        }
        for (BlockPos blockpos1 : Lists.newArrayList(p_236403_3_)) {
            if (bbIn.m_71051_((Vec3i)blockpos1)) {
                discretevoxelshape.m_142703_(blockpos1.m_123341_() - bbIn.m_162395_(), blockpos1.m_123342_() - bbIn.m_162396_(), blockpos1.m_123343_() - bbIn.m_162398_());
            }
            for (Direction direction : Direction.values()) {
                BlockState blockstate;
                blockpos$mutable.m_122159_((Vec3i)blockpos1, direction);
                if (p_236403_3_.contains(blockpos$mutable) || !(blockstate = worldIn.m_8055_((BlockPos)blockpos$mutable)).m_61138_((Property)BlockStateProperties.f_61414_)) continue;
                ((Set)list.get(0)).add(blockpos$mutable.m_7949_());
                CeiltrunkTreeFeature.setBlockKnownShape((LevelWriter)worldIn, (BlockPos)blockpos$mutable, (BlockState)blockstate.m_61124_((Property)BlockStateProperties.f_61414_, (Comparable)Integer.valueOf(1)));
                if (!bbIn.m_71051_((Vec3i)blockpos$mutable)) continue;
                discretevoxelshape.m_142703_(blockpos$mutable.m_123341_() - bbIn.m_162395_(), blockpos$mutable.m_123342_() - bbIn.m_162396_(), blockpos$mutable.m_123343_() - bbIn.m_162398_());
            }
        }
        for (int l = 1; l < amt; ++l) {
            Set set = (Set)list.get(l - 1);
            Set set1 = (Set)list.get(l);
            for (BlockPos blockpos2 : set) {
                if (bbIn.m_71051_((Vec3i)blockpos2)) {
                    discretevoxelshape.m_142703_(blockpos2.m_123341_() - bbIn.m_162395_(), blockpos2.m_123342_() - bbIn.m_162396_(), blockpos2.m_123343_() - bbIn.m_162398_());
                }
                for (Direction direction1 : Direction.values()) {
                    int k;
                    BlockState blockstate1;
                    blockpos$mutable.m_122159_((Vec3i)blockpos2, direction1);
                    if (set.contains(blockpos$mutable) || set1.contains(blockpos$mutable) || !(blockstate1 = worldIn.m_8055_((BlockPos)blockpos$mutable)).m_61138_((Property)BlockStateProperties.f_61414_) || (k = ((Integer)blockstate1.m_61143_((Property)BlockStateProperties.f_61414_)).intValue()) <= l + 1) continue;
                    BlockState blockstate2 = (BlockState)blockstate1.m_61124_((Property)BlockStateProperties.f_61414_, (Comparable)Integer.valueOf(l + 1));
                    CeiltrunkTreeFeature.setBlockKnownShape((LevelWriter)worldIn, (BlockPos)blockpos$mutable, blockstate2);
                    if (bbIn.m_71051_((Vec3i)blockpos$mutable)) {
                        discretevoxelshape.m_142703_(blockpos$mutable.m_123341_() - bbIn.m_162395_(), blockpos$mutable.m_123342_() - bbIn.m_162396_(), blockpos$mutable.m_123343_() - bbIn.m_162398_());
                    }
                    set1.add(blockpos$mutable.m_7949_());
                }
            }
        }
        return discretevoxelshape;
    }
}

