/*
 * Decompiled with CFR 0.152.
 */
package com.kittehmod.ceilands.forge.worldgen.features.trunkplacers;

import com.google.common.collect.ImmutableList;
import com.kittehmod.ceilands.forge.registry.CeilandsTrunkPlacerType;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;

public class LargeCeiltrunkTrunkPlacer
extends TrunkPlacer {
    public static final Codec<LargeCeiltrunkTrunkPlacer> CODEC = RecordCodecBuilder.create(p_70261_ -> LargeCeiltrunkTrunkPlacer.m_70305_((RecordCodecBuilder.Instance)p_70261_).apply((Applicative)p_70261_, LargeCeiltrunkTrunkPlacer::new));
    public static final Direction[] STARTING_BRANCH_DIRECTION = new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};

    public LargeCeiltrunkTrunkPlacer(int p_70268_, int p_70269_, int p_70270_) {
        super(p_70268_, p_70269_, p_70270_);
    }

    protected TrunkPlacerType<?> m_7362_() {
        return CeilandsTrunkPlacerType.LARGE_CEILTRUNK_TRUNK_PLACER;
    }

    public List<FoliagePlacer.FoliageAttachment> m_213934_(LevelSimulatedReader reader, BiConsumer<BlockPos, BlockState> consumer, RandomSource random, int height, BlockPos pos, TreeConfiguration config) {
        BlockPos blockpos = pos.m_7494_();
        if (reader.m_7433_(blockpos, blockstate -> blockstate.m_60734_() != Blocks.f_50440_)) {
            LargeCeiltrunkTrunkPlacer.m_226169_((LevelSimulatedReader)reader, consumer, (RandomSource)random, (BlockPos)blockpos, (TreeConfiguration)config);
            LargeCeiltrunkTrunkPlacer.m_226169_((LevelSimulatedReader)reader, consumer, (RandomSource)random, (BlockPos)blockpos.m_122029_(), (TreeConfiguration)config);
            LargeCeiltrunkTrunkPlacer.m_226169_((LevelSimulatedReader)reader, consumer, (RandomSource)random, (BlockPos)blockpos.m_122019_(), (TreeConfiguration)config);
            LargeCeiltrunkTrunkPlacer.m_226169_((LevelSimulatedReader)reader, consumer, (RandomSource)random, (BlockPos)blockpos.m_122019_().m_122029_(), (TreeConfiguration)config);
        }
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        boolean spiralRotation = (double)random.m_188501_() < 0.5;
        int branchLength = 3 + random.m_188503_(4);
        boolean branchOrientation = false;
        Direction dir = STARTING_BRANCH_DIRECTION[random.m_188503_(4)];
        for (int i = 0; i < height; ++i) {
            this.placeLogIfFreeWithOffset(reader, consumer, random, blockpos$mutableblockpos, config, pos, 0, -i, 0);
            if (i < height - 1) {
                this.placeLogIfFreeWithOffset(reader, consumer, random, blockpos$mutableblockpos, config, pos, 1, -i, 0);
                this.placeLogIfFreeWithOffset(reader, consumer, random, blockpos$mutableblockpos, config, pos, 1, -i, 1);
                this.placeLogIfFreeWithOffset(reader, consumer, random, blockpos$mutableblockpos, config, pos, 0, -i, 1);
            }
            if (i < height - 4) {
                branchOrientation = (double)random.m_188501_() < 0.5;
                this.generateBranches(reader, consumer, random, blockpos$mutableblockpos, config, pos.m_6625_(i), dir, branchLength - 1, branchOrientation ? 0 : 1, dir == Direction.SOUTH || dir == Direction.EAST ? 1 : 0);
                dir = spiralRotation ? dir.m_122427_() : dir.m_122428_();
            }
            if (i != height - 2) continue;
            branchOrientation = false;
            branchOrientation = (double)random.m_188501_() < 0.5;
            this.generateBranches(reader, consumer, random, blockpos$mutableblockpos, config, pos.m_6625_(i), Direction.NORTH, branchLength, branchOrientation ? 0 : 1, 0);
            branchOrientation = (double)random.m_188501_() < 0.5;
            this.generateBranches(reader, consumer, random, blockpos$mutableblockpos, config, pos.m_6625_(i), Direction.SOUTH, branchLength, branchOrientation ? 0 : 1, 1);
            branchOrientation = (double)random.m_188501_() < 0.5;
            this.generateBranches(reader, consumer, random, blockpos$mutableblockpos, config, pos.m_6625_(i), Direction.WEST, branchLength, branchOrientation ? 0 : 1, 0);
            branchOrientation = (double)random.m_188501_() < 0.5;
            this.generateBranches(reader, consumer, random, blockpos$mutableblockpos, config, pos.m_6625_(i), Direction.EAST, branchLength, branchOrientation ? 0 : 1, 1);
        }
        return ImmutableList.of((Object)new FoliagePlacer.FoliageAttachment(pos.m_6625_(height), -1, true));
    }

    private void placeLogIfFreeWithOffset(LevelSimulatedReader reader, BiConsumer<BlockPos, BlockState> consumer, RandomSource random, BlockPos.MutableBlockPos pos$mutable, TreeConfiguration config, BlockPos pos, int x, int y, int z) {
        pos$mutable.m_122154_((Vec3i)pos, x, y, z);
        this.m_226163_(reader, consumer, random, pos$mutable, config);
    }

    private void generateBranches(LevelSimulatedReader reader, BiConsumer<BlockPos, BlockState> consumer, RandomSource random, BlockPos.MutableBlockPos pos$mutable, TreeConfiguration config, BlockPos pos, Direction direction, int branchLength, int offset1, int offset2) {
        for (int bl = 1; bl <= branchLength; ++bl) {
            pos$mutable.m_122190_((Vec3i)pos);
            BlockPos finalizedPos = pos$mutable.m_5484_(direction, bl + offset2).m_5484_(Direction.UP, bl >= Math.abs(branchLength) ? 1 : 0).m_5484_(direction == Direction.NORTH || direction == Direction.SOUTH ? Direction.EAST : Direction.SOUTH, offset1).m_7949_();
            if (!this.m_226184_(reader, finalizedPos)) continue;
            this.m_226175_(reader, consumer, random, finalizedPos, config, blockstate -> (BlockState)blockstate.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)this.getLogAxis((BlockPos)pos$mutable, finalizedPos)));
        }
    }

    private Direction.Axis getLogAxis(BlockPos p_70130_, BlockPos p_70131_) {
        int j;
        Direction.Axis direction$axis = Direction.Axis.Y;
        int i = Math.abs(p_70131_.m_123341_() - p_70130_.m_123341_());
        int k = Math.max(i, j = Math.abs(p_70131_.m_123343_() - p_70130_.m_123343_()));
        if (k > 0) {
            direction$axis = i == k ? Direction.Axis.X : Direction.Axis.Z;
        }
        return direction$axis;
    }
}

