/*
 * Decompiled with CFR 0.152.
 */
package net.petemc.undeadnights.entity.ai.goal;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.petemc.undeadnights.UndeadNights;
import net.petemc.undeadnights.casts.BlockBreakingZombie;
import net.petemc.undeadnights.command.HordeMobsCommand;
import net.petemc.undeadnights.config.MainConfig;
import net.petemc.undeadnights.entity.EliteZombieEntity;
import net.petemc.undeadnights.entity.HordeZombieEntity;

public class BreakBlockGoal
extends Goal {
    private final Zombie mob;
    private final float breakProgressPerTick = 0.05f;
    private BlockPos targetBlock;
    private float scaledTargetDestroyTime;
    private float breakProgress;
    private float ratio;

    public BreakBlockGoal(Zombie mob) {
        this.mob = mob;
    }

    public static float blockPosDistance(Entity entity, BlockPos pos) {
        return BreakBlockGoal.blockPosDistance(entity.m_20183_(), pos);
    }

    public static float blockPosDistance(BlockPos pos1, BlockPos pos2) {
        float x = pos1.m_123341_() - pos2.m_123341_();
        float y = pos1.m_123342_() - pos2.m_123342_();
        float z = pos1.m_123343_() - pos2.m_123343_();
        return Mth.m_14116_((float)(x * x + y * y + z * z));
    }

    public boolean m_183429_() {
        return true;
    }

    public boolean m_8045_() {
        return BreakBlockGoal.blockPosDistance((Entity)this.mob, this.targetBlock) <= 3.0f && this.breakProgress <= this.scaledTargetDestroyTime;
    }

    public void m_8056_() {
        Zombie zombie = this.mob;
        if (zombie instanceof HordeZombieEntity) {
            HordeZombieEntity hordeZombie = (HordeZombieEntity)zombie;
            hordeZombie.setBreakingBlock(true);
        }
        if ((zombie = this.mob) instanceof EliteZombieEntity) {
            EliteZombieEntity eliteZombie = (EliteZombieEntity)zombie;
            eliteZombie.setBreakingBlock(true);
        }
        if ((zombie = this.mob) instanceof BlockBreakingZombie) {
            BlockBreakingZombie zombie2 = (BlockBreakingZombie)zombie;
            zombie2.setBreakingBlock(true);
        }
    }

    public boolean m_6767_() {
        return false;
    }

    public void m_8037_() {
        this.breakProgress += 0.05f;
        this.mob.m_6674_(InteractionHand.MAIN_HAND);
        if (this.breakProgress >= this.scaledTargetDestroyTime) {
            this.mob.m_9236_().m_46961_(this.targetBlock, true);
            return;
        }
        this.mob.m_9236_().m_6801_(this.mob.m_19879_(), this.targetBlock, (int)(this.breakProgress * this.ratio));
    }

    public void m_8041_() {
        this.mob.m_9236_().m_6801_(this.mob.m_19879_(), this.targetBlock, 0);
        this.breakProgress = 0.0f;
        this.targetBlock = null;
        this.scaledTargetDestroyTime = 0.0f;
        Zombie zombie = this.mob;
        if (zombie instanceof HordeZombieEntity) {
            HordeZombieEntity hordeZombie = (HordeZombieEntity)zombie;
            hordeZombie.setBreakingBlock(false);
        }
        this.mob.m_21573_().m_26569_();
    }

    public boolean m_8036_() {
        if (!HordeMobsCommand.hordeZombiesCanBreakBlocks) {
            return false;
        }
        LivingEntity targetEntity = this.mob.m_5448_();
        if (targetEntity == null) {
            return false;
        }
        if (this.mob.m_217043_().m_188501_() < 0.4f) {
            return false;
        }
        Level world = this.mob.m_9236_();
        Direction direction = this.mob.m_6350_();
        BlockPos blockPos = this.mob.m_20183_();
        blockPos = blockPos.m_121955_(direction.m_122436_()).m_7918_(0, 1, 0);
        if (!this.mob.m_21573_().m_26571_()) {
            return false;
        }
        int yDistance = Math.abs(targetEntity.m_146904_() - this.mob.m_146904_());
        int yCheckModifier = yDistance > 2 ? ((double)targetEntity.m_146904_() > this.mob.m_20186_() ? 1 : -2) : -1;
        BlockState state = world.m_8055_(blockPos);
        Block block = state.m_60734_();
        if ((block instanceof AirBlock || block.m_48673_(state)) && ((block = (state = world.m_8055_(blockPos = blockPos.m_7918_(0, yCheckModifier, 0))).m_60734_()) instanceof AirBlock || block.m_48673_(state))) {
            return false;
        }
        this.targetBlock = blockPos;
        float destroyTime = world.m_8055_(this.targetBlock).m_60734_().m_155943_();
        this.scaledTargetDestroyTime = destroyTime * 1.5f;
        if (MainConfig.getPrintDebugMessages()) {
            UndeadNights.LOGGER.info("Block: {} destroyTime: {} Stage: {}", new Object[]{world.m_8055_(this.targetBlock).m_60734_(), Float.valueOf(world.m_8055_(this.targetBlock).m_60734_().m_155943_()), UndeadNights.difficultyConfig.getCurrentDifficultyLevel().getDifficultySettingsHordeMobs().getBlockBreakingTier()});
        }
        if (block instanceof DoorBlock && destroyTime == 3.0f) {
            this.ratio = 10.0f / this.scaledTargetDestroyTime;
            return true;
        }
        String blockName = world.m_8055_(this.targetBlock).m_60734_().toString();
        if (blockName.contains("securitycraft") && blockName.contains("reinforced") && MainConfig.getSecurityCraftCompatibility()) {
            return false;
        }
        if (this.scaledTargetDestroyTime < 0.0f) {
            return false;
        }
        if (destroyTime > 0.6f && HordeMobsCommand.hordeZombiesBlockBreakingTier <= 1) {
            return false;
        }
        if (destroyTime > 3.0f && HordeMobsCommand.hordeZombiesBlockBreakingTier == 2) {
            return false;
        }
        if (destroyTime > 20.0f && HordeMobsCommand.hordeZombiesBlockBreakingTier == 3) {
            return false;
        }
        if (destroyTime > 75.0f) {
            return false;
        }
        if (destroyTime >= 50.0f) {
            this.scaledTargetDestroyTime = 25.0f;
        }
        this.ratio = 10.0f / this.scaledTargetDestroyTime;
        return true;
    }
}

