/*
 * Decompiled with CFR 0.152.
 */
package com.github.smallinger.coppergolemlegacy.client.model;

import com.github.smallinger.coppergolemlegacy.client.animation.CopperGolemAnimation;
import com.github.smallinger.coppergolemlegacy.entity.CopperGolemEntity;
import com.github.smallinger.coppergolemlegacy.entity.CopperGolemState;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.animation.AnimationDefinition;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.HumanoidArm;

public class CopperGolemModel
extends HierarchicalModel<CopperGolemEntity>
implements ArmedModel {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"coppergolemlegacy", (String)"copper_golem"), "main");
    public static final ModelLayerLocation STATUE_STANDING = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"coppergolemlegacy", (String)"copper_golem_statue_standing"), "main");
    public static final ModelLayerLocation STATUE_RUNNING = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"coppergolemlegacy", (String)"copper_golem_statue_running"), "main");
    public static final ModelLayerLocation STATUE_SITTING = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"coppergolemlegacy", (String)"copper_golem_statue_sitting"), "main");
    public static final ModelLayerLocation STATUE_STAR = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"coppergolemlegacy", (String)"copper_golem_statue_star"), "main");
    private final ModelPart root;
    private final ModelPart head;
    private final ModelPart body;
    private final ModelPart rightArm;
    private final ModelPart leftArm;
    private final ModelPart rightLeg;
    private final ModelPart leftLeg;
    private final AnimationDefinition walkAnimation;
    private final AnimationDefinition walkWithItemAnimation;
    private final AnimationDefinition idleAnimation;
    private final AnimationDefinition interactionGetItem;
    private final AnimationDefinition interactionGetNoItem;
    private final AnimationDefinition interactionDropItem;
    private final AnimationDefinition interactionDropNoItem;
    private final AnimationDefinition pressButton;

    public CopperGolemModel(ModelPart root) {
        this.root = root;
        this.body = root.getChild("body");
        this.head = this.body.getChild("head");
        this.rightArm = this.body.getChild("right_arm");
        this.leftArm = this.body.getChild("left_arm");
        this.rightLeg = root.getChild("right_leg");
        this.leftLeg = root.getChild("left_leg");
        this.walkAnimation = CopperGolemAnimation.COPPER_GOLEM_WALK;
        this.walkWithItemAnimation = CopperGolemAnimation.COPPER_GOLEM_WALK_ITEM;
        this.idleAnimation = CopperGolemAnimation.COPPER_GOLEM_IDLE;
        this.interactionGetItem = CopperGolemAnimation.COPPER_GOLEM_CHEST_INTERACTION_NOITEM_GET;
        this.interactionGetNoItem = CopperGolemAnimation.COPPER_GOLEM_CHEST_INTERACTION_NOITEM_NOGET;
        this.interactionDropItem = CopperGolemAnimation.COPPER_GOLEM_CHEST_INTERACTION_ITEM_DROP;
        this.interactionDropNoItem = CopperGolemAnimation.COPPER_GOLEM_CHEST_INTERACTION_ITEM_NODROP;
        this.pressButton = CopperGolemAnimation.COPPER_GOLEM_PRESS_BUTTON;
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 15).addBox(-4.0f, -6.0f, -3.0f, 8.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-5.0f, (float)0.0f));
        body.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -5.0f, -5.0f, 8.0f, 5.0f, 10.0f, new CubeDeformation(0.015f)).texOffs(56, 0).addBox(-1.0f, -2.0f, -6.0f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(37, 8).addBox(-1.0f, -9.0f, -1.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(-0.015f)).texOffs(37, 0).addBox(-2.0f, -13.0f, -2.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(-0.015f)), PartPose.offset((float)0.0f, (float)-6.0f, (float)0.0f));
        body.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(36, 16).addBox(-3.0f, -1.0f, -2.0f, 3.0f, 10.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-4.0f, (float)-6.0f, (float)0.0f));
        body.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(50, 16).addBox(0.0f, -1.0f, -2.0f, 3.0f, 10.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)4.0f, (float)-6.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(0, 27).addBox(-4.0f, 0.0f, -2.0f, 4.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-5.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(16, 27).addBox(0.0f, 0.0f, -2.0f, 4.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-5.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public static LayerDefinition createStandingStatueBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 15).addBox(-4.0f, -6.0f, -3.0f, 8.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-5.0f, (float)0.0f));
        body.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -5.0f, -5.0f, 8.0f, 5.0f, 10.0f, new CubeDeformation(0.015f)).texOffs(56, 0).addBox(-1.0f, -2.0f, -6.0f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(37, 8).addBox(-1.0f, -9.0f, -1.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(-0.015f)).texOffs(37, 0).addBox(-2.0f, -13.0f, -2.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(-0.015f)), PartPose.offset((float)0.0f, (float)-6.0f, (float)0.0f));
        body.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(36, 16).addBox(-3.0f, -1.0f, -2.0f, 3.0f, 10.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-4.0f, (float)-6.0f, (float)0.0f));
        body.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(50, 16).addBox(0.0f, -1.0f, -2.0f, 3.0f, 10.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)4.0f, (float)-6.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(0, 27).addBox(-4.0f, 0.0f, -2.0f, 4.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-5.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(16, 27).addBox(0.0f, 0.0f, -2.0f, 4.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-5.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public static LayerDefinition createRunningPoseBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create(), PartPose.offset((float)-1.064f, (float)-5.0f, (float)0.0f));
        body.addOrReplaceChild("body_r1", CubeListBuilder.create().texOffs(0, 15).addBox(-4.02f, -6.116f, -3.5f, 8.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.1f, (float)0.1f, (float)0.7f, (float)0.1204f, (float)-0.0064f, (float)-0.0779f));
        body.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -5.1f, -5.0f, 8.0f, 5.0f, 10.0f, new CubeDeformation(0.0f)).texOffs(56, 0).addBox(-1.02f, -2.1f, -6.0f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(37, 8).addBox(-1.02f, -9.1f, -1.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(-0.015f)).texOffs(37, 0).addBox(-2.0f, -13.1f, -2.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(-0.015f)), PartPose.offset((float)0.7f, (float)-5.6f, (float)-1.8f));
        PartDefinition rightArm = body.addOrReplaceChild("right_arm", CubeListBuilder.create(), PartPose.offset((float)-4.0f, (float)-6.0f, (float)0.0f));
        rightArm.addOrReplaceChild("right_arm_r1", CubeListBuilder.create().texOffs(36, 16).addBox(-3.052f, -1.11f, -2.036f, 3.0f, 10.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.7f, (float)-0.248f, (float)-1.62f, (float)1.0036f, (float)0.0f, (float)0.0f));
        PartDefinition leftArm = body.addOrReplaceChild("left_arm", CubeListBuilder.create(), PartPose.offset((float)4.0f, (float)-6.0f, (float)0.0f));
        leftArm.addOrReplaceChild("left_arm_r1", CubeListBuilder.create().texOffs(50, 16).addBox(0.032f, -1.1f, -2.0f, 3.0f, 10.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.732f, (float)0.0f, (float)0.0f, (float)-0.8715f, (float)-0.0535f, (float)-0.0449f));
        PartDefinition rightLeg = partdefinition.addOrReplaceChild("right_leg", CubeListBuilder.create(), PartPose.offset((float)-3.064f, (float)-5.0f, (float)0.0f));
        rightLeg.addOrReplaceChild("right_leg_r1", CubeListBuilder.create().texOffs(0, 27).addBox(-1.856f, -0.1f, -1.09f, 4.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.048f, (float)0.0f, (float)-0.9f, (float)-0.8727f, (float)0.0f, (float)0.0f));
        PartDefinition leftLeg = partdefinition.addOrReplaceChild("left_leg", CubeListBuilder.create(), PartPose.offset((float)0.936f, (float)-5.0f, (float)0.0f));
        leftLeg.addOrReplaceChild("left_leg_r1", CubeListBuilder.create().texOffs(16, 27).addBox(-2.088f, -0.1f, -2.0f, 4.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.0f, (float)0.0f, (float)0.0f, (float)0.7854f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public static LayerDefinition createSittingPoseBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(3, 19).addBox(-3.0f, -4.0f, -4.525f, 6.0f, 1.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(0, 15).addBox(-4.0f, -3.0f, -3.525f, 8.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-3.0f, (float)2.325f));
        body.addOrReplaceChild("body_r1", CubeListBuilder.create().texOffs(3, 18).addBox(-4.0f, -3.0f, -2.2f, 8.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-1.0f, (float)-4.325f, (float)0.0f, (float)0.0f, (float)-3.1416f));
        body.addOrReplaceChild("head", CubeListBuilder.create().texOffs(37, 8).addBox(-1.0f, -7.0f, -3.3f, 2.0f, 4.0f, 2.0f, new CubeDeformation(-0.015f)).texOffs(37, 0).addBox(-2.0f, -11.0f, -4.3f, 4.0f, 4.0f, 4.0f, new CubeDeformation(-0.015f)).texOffs(0, 0).addBox(-4.0f, -3.0f, -7.325f, 8.0f, 5.0f, 10.0f, new CubeDeformation(0.0f)).texOffs(56, 0).addBox(-1.0f, 0.0f, -8.325f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-6.0f, (float)-0.2f));
        PartDefinition rightArm = body.addOrReplaceChild("right_arm", CubeListBuilder.create(), PartPose.offsetAndRotation((float)-4.0f, (float)-5.6f, (float)-1.8f, (float)0.4363f, (float)0.0f, (float)0.0f));
        rightArm.addOrReplaceChild("right_arm_r1", CubeListBuilder.create().texOffs(36, 16).addBox(-3.075f, -0.9733f, -1.9966f, 3.0f, 10.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0893f, (float)0.1198f, (float)-1.0472f, (float)0.0f, (float)0.0f));
        PartDefinition leftArm = body.addOrReplaceChild("left_arm", CubeListBuilder.create(), PartPose.offsetAndRotation((float)4.0f, (float)-5.6f, (float)-1.7f, (float)0.4363f, (float)0.0f, (float)0.0f));
        leftArm.addOrReplaceChild("left_arm_r1", CubeListBuilder.create().texOffs(50, 16).addBox(0.075f, -1.0443f, -1.8997f, 3.0f, 10.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-0.0015f, (float)-0.0808f, (float)-1.0472f, (float)0.0f, (float)0.0f));
        PartDefinition rightLeg = partdefinition.addOrReplaceChild("right_leg", CubeListBuilder.create(), PartPose.offset((float)-2.1f, (float)-2.1f, (float)-2.075f));
        rightLeg.addOrReplaceChild("right_leg_r1", CubeListBuilder.create().texOffs(0, 27).addBox(-2.0f, 0.975f, 0.0f, 4.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.05f, (float)-1.9f, (float)1.075f, (float)-1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition leftLeg = partdefinition.addOrReplaceChild("left_leg", CubeListBuilder.create(), PartPose.offset((float)2.0f, (float)-2.0f, (float)-2.075f));
        leftLeg.addOrReplaceChild("left_leg_r1", CubeListBuilder.create().texOffs(16, 27).addBox(-2.0f, 0.975f, 0.0f, 4.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.05f, (float)-2.0f, (float)1.075f, (float)-1.5708f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public static LayerDefinition createStarPoseBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 15).addBox(-4.0f, -6.0f, -3.0f, 8.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-5.0f, (float)0.0f));
        body.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -5.0f, -5.0f, 8.0f, 5.0f, 10.0f, new CubeDeformation(0.0f)).texOffs(56, 0).addBox(-1.0f, -2.0f, -6.0f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(37, 8).addBox(-1.0f, -9.0f, -1.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(-0.015f)).texOffs(37, 0).addBox(-2.0f, -13.0f, -2.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(-0.015f)), PartPose.offset((float)0.0f, (float)-6.0f, (float)0.0f));
        PartDefinition rightArm = body.addOrReplaceChild("right_arm", CubeListBuilder.create(), PartPose.offset((float)-4.0f, (float)-6.0f, (float)0.0f));
        rightArm.addOrReplaceChild("right_arm_r1", CubeListBuilder.create().texOffs(36, 16).addBox(-1.5f, -5.0f, -2.0f, 3.0f, 10.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.9199f));
        PartDefinition leftArm = body.addOrReplaceChild("left_arm", CubeListBuilder.create(), PartPose.offset((float)4.0f, (float)-6.0f, (float)0.0f));
        leftArm.addOrReplaceChild("left_arm_r1", CubeListBuilder.create().texOffs(50, 16).addBox(-1.5f, -5.0f, -2.0f, 3.0f, 10.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-1.9199f));
        PartDefinition rightLeg = partdefinition.addOrReplaceChild("right_leg", CubeListBuilder.create(), PartPose.offset((float)-3.0f, (float)-5.0f, (float)0.0f));
        rightLeg.addOrReplaceChild("right_leg_r1", CubeListBuilder.create().texOffs(0, 27).addBox(-2.0f, -2.5f, -2.0f, 4.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.35f, (float)2.0f, (float)0.01f, (float)0.0f, (float)0.0f, (float)0.2618f));
        PartDefinition leftLeg = partdefinition.addOrReplaceChild("left_leg", CubeListBuilder.create(), PartPose.offset((float)1.0f, (float)-5.0f, (float)0.0f));
        leftLeg.addOrReplaceChild("left_leg_r1", CubeListBuilder.create().texOffs(16, 27).addBox(-2.0f, -2.5f, -2.0f, 4.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.65f, (float)2.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.2618f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(CopperGolemEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        boolean hasItems;
        this.root().getAllParts().forEach(ModelPart::resetPose);
        this.head.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.head.xRot = headPitch * ((float)Math.PI / 180);
        CopperGolemState state = entity.getState();
        boolean bl = hasItems = !entity.getMainHandItem().isEmpty();
        if (limbSwingAmount > 0.0f && state != CopperGolemState.PRESSING_BUTTON) {
            if (hasItems) {
                this.animateWalk(this.walkWithItemAnimation, limbSwing, limbSwingAmount, 2.0f, 2.5f);
                this.poseHeldItemArmsIfStill();
            } else {
                this.animateWalk(this.walkAnimation, limbSwing, limbSwingAmount, 2.0f, 2.5f);
            }
        }
        if (state == CopperGolemState.IDLE) {
            this.animate(entity.idleAnimationState, this.idleAnimation, ageInTicks);
        }
        switch (state) {
            case GETTING_ITEM: {
                this.animate(entity.interactionGetItemAnimationState, this.interactionGetItem, ageInTicks);
                break;
            }
            case GETTING_NO_ITEM: {
                this.animate(entity.interactionGetNoItemAnimationState, this.interactionGetNoItem, ageInTicks);
                break;
            }
            case DROPPING_ITEM: {
                this.animate(entity.interactionDropItemAnimationState, this.interactionDropItem, ageInTicks);
                break;
            }
            case DROPPING_NO_ITEM: {
                this.animate(entity.interactionDropNoItemAnimationState, this.interactionDropNoItem, ageInTicks);
                break;
            }
            case PRESSING_BUTTON: {
                this.animate(entity.pressingButtonAnimationState, this.pressButton, ageInTicks);
                break;
            }
        }
    }

    public ModelPart root() {
        return this.root;
    }

    public void translateToHand(HumanoidArm arm, PoseStack poseStack) {
        this.root.translateAndRotate(poseStack);
        this.body.translateAndRotate(poseStack);
        ModelPart armPart = arm == HumanoidArm.RIGHT ? this.rightArm : this.leftArm;
        armPart.translateAndRotate(poseStack);
        CopperGolemState state = CopperGolemState.IDLE;
        if (state == CopperGolemState.IDLE) {
            poseStack.mulPose(Axis.YP.rotationDegrees(arm == HumanoidArm.RIGHT ? -90.0f : 90.0f));
            poseStack.translate(0.0f, 0.0f, 0.125f);
        } else {
            poseStack.scale(0.55f, 0.55f, 0.55f);
            poseStack.translate(-0.125f, 0.3125f, -0.1875f);
        }
    }

    private void poseHeldItemArmsIfStill() {
        this.rightArm.xRot = Math.min(this.rightArm.xRot, -0.87266463f);
        this.leftArm.xRot = Math.min(this.leftArm.xRot, -0.87266463f);
        this.rightArm.yRot = Math.min(this.rightArm.yRot, -0.1134464f);
        this.leftArm.yRot = Math.max(this.leftArm.yRot, 0.1134464f);
        this.rightArm.zRot = Math.min(this.rightArm.zRot, -0.064577185f);
        this.leftArm.zRot = Math.max(this.leftArm.zRot, 0.064577185f);
    }
}

