/*
 * Decompiled with CFR 0.152.
 */
package com.github.smallinger.coppergolemlegacy.events;

import com.github.smallinger.coppergolemlegacy.CopperGolemLegacy;
import com.github.smallinger.coppergolemlegacy.ModMemoryTypes;
import com.github.smallinger.coppergolemlegacy.ModTags;
import com.github.smallinger.coppergolemlegacy.block.CopperChestBlock;
import com.github.smallinger.coppergolemlegacy.entity.CopperGolemEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.level.BlockEvent;

@EventBusSubscriber(modid="coppergolemlegacy")
public class CopperGolemSpawnHandler {
    @SubscribeEvent
    public static void onBlockPlace(BlockEvent.EntityPlaceEvent event) {
        Level level = (Level)event.getLevel();
        BlockPos pos = event.getPos();
        BlockState placedState = event.getPlacedBlock();
        if (placedState.is(Blocks.CARVED_PUMPKIN) && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Direction playerDirection = Direction.NORTH;
            if (event.getEntity() != null) {
                playerDirection = Direction.fromYRot((double)event.getEntity().getYRot());
            }
            CopperGolemSpawnHandler.trySpawnCopperGolem(serverLevel, pos, playerDirection);
        }
    }

    private static void trySpawnCopperGolem(ServerLevel level, BlockPos pumpkinPos, Direction playerDirection) {
        BlockPos copperPos = pumpkinPos.below();
        BlockState copperState = level.getBlockState(copperPos);
        if (copperState.is(ModTags.Blocks.COPPER)) {
            Direction direction = playerDirection.getOpposite();
            level.setBlock(pumpkinPos, Blocks.AIR.defaultBlockState(), 2);
            Block copperBlock = copperState.getBlock();
            BlockState chestState = CopperChestBlock.getFromCopperBlock(copperBlock, direction, (Level)level, copperPos);
            level.setBlock(copperPos, chestState, 2);
            level.levelEvent(2001, pumpkinPos, Block.getId((BlockState)Blocks.CARVED_PUMPKIN.defaultBlockState()));
            CopperGolemEntity copperGolem = (CopperGolemEntity)((EntityType)CopperGolemLegacy.COPPER_GOLEM.get()).create((Level)level);
            if (copperGolem != null) {
                float yaw = direction.toYRot();
                copperGolem.moveTo((double)copperPos.getX() + 0.5, (double)copperPos.getY() + 1.0, (double)copperPos.getZ() + 0.5, yaw, 0.0f);
                copperGolem.setYRot(yaw);
                copperGolem.yRotO = yaw;
                copperGolem.setYBodyRot(yaw);
                copperGolem.yBodyRotO = yaw;
                copperGolem.setYHeadRot(yaw);
                copperGolem.yHeadRotO = yaw;
                WeatheringCopper.WeatherState weatherState = CopperGolemSpawnHandler.getWeatherStateFromBlock(copperState.getBlock());
                copperGolem.setWeatherState(weatherState);
                copperGolem.getBrain().setMemory((MemoryModuleType)ModMemoryTypes.TRANSPORT_ITEMS_COOLDOWN_TICKS.get(), (Object)140);
                level.addFreshEntity((Entity)copperGolem);
                for (ServerPlayer serverPlayer : level.getEntitiesOfClass(ServerPlayer.class, copperGolem.getBoundingBox().inflate(5.0))) {
                }
                level.updateNeighborsAt(copperPos, chestState.getBlock());
                level.updateNeighborsAt(pumpkinPos, Blocks.AIR);
            }
        }
    }

    private static WeatheringCopper.WeatherState getWeatherStateFromBlock(Block block) {
        if (block instanceof WeatheringCopper) {
            WeatheringCopper weatheringCopper = (WeatheringCopper)block;
            return (WeatheringCopper.WeatherState)weatheringCopper.getAge();
        }
        if (block == Blocks.WAXED_COPPER_BLOCK) {
            return WeatheringCopper.WeatherState.UNAFFECTED;
        }
        if (block == Blocks.WAXED_EXPOSED_COPPER) {
            return WeatheringCopper.WeatherState.EXPOSED;
        }
        if (block == Blocks.WAXED_WEATHERED_COPPER) {
            return WeatheringCopper.WeatherState.WEATHERED;
        }
        if (block == Blocks.WAXED_OXIDIZED_COPPER) {
            return WeatheringCopper.WeatherState.OXIDIZED;
        }
        return WeatheringCopper.WeatherState.UNAFFECTED;
    }
}

