/*
 * Decompiled with CFR 0.152.
 */
package com.github.smallinger.coppergolemlegacy.entity;

import com.github.smallinger.coppergolemlegacy.CopperGolemLegacy;
import com.github.smallinger.coppergolemlegacy.ModSounds;
import com.github.smallinger.coppergolemlegacy.block.CopperGolemStatueBlock;
import com.github.smallinger.coppergolemlegacy.block.entity.CopperGolemStatueBlockEntity;
import com.github.smallinger.coppergolemlegacy.entity.ContainerUser;
import com.github.smallinger.coppergolemlegacy.entity.CopperGolemOxidationLevels;
import com.github.smallinger.coppergolemlegacy.entity.CopperGolemState;
import com.github.smallinger.coppergolemlegacy.entity.ai.CopperGolemAi;
import com.github.smallinger.coppergolemlegacy.entity.ai.navigation.CopperGolemNavigation;
import com.mojang.serialization.Dynamic;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Shearable;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;

public class CopperGolemEntity
extends AbstractGolem
implements Shearable,
ContainerUser {
    private static final long IGNORE_WEATHERING_TICK = -2L;
    private static final long UNSET_WEATHERING_TICK = -1L;
    private static final int WEATHERING_TICK_FROM = 504000;
    private static final int WEATHERING_TICK_TO = 552000;
    private static final int SPIN_ANIMATION_MIN_COOLDOWN = 200;
    private static final int SPIN_ANIMATION_MAX_COOLDOWN = 240;
    private static final float TURN_TO_STATUE_CHANCE = 0.0058f;
    private static final double CONTAINER_INTERACTION_RANGE = 4.0;
    private static final EntityDataAccessor<Integer> DATA_WEATHER_STATE = SynchedEntityData.m_135353_(CopperGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> COPPER_GOLEM_STATE = SynchedEntityData.m_135353_(CopperGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private long nextWeatheringTick = -1L;
    @Nullable
    private BlockPos openedChestPos;
    private int idleAnimationStartTick = 0;
    public final AnimationState idleAnimationState = new AnimationState();
    public final AnimationState interactionGetItemAnimationState = new AnimationState();
    public final AnimationState interactionGetNoItemAnimationState = new AnimationState();
    public final AnimationState interactionDropItemAnimationState = new AnimationState();
    public final AnimationState interactionDropNoItemAnimationState = new AnimationState();
    public final AnimationState pressingButtonAnimationState = new AnimationState();

    private static WeatheringCopper.WeatherState getNextWeatherState(WeatheringCopper.WeatherState current) {
        return switch (current) {
            default -> throw new IncompatibleClassChangeError();
            case WeatheringCopper.WeatherState.UNAFFECTED -> WeatheringCopper.WeatherState.EXPOSED;
            case WeatheringCopper.WeatherState.EXPOSED -> WeatheringCopper.WeatherState.WEATHERED;
            case WeatheringCopper.WeatherState.WEATHERED -> WeatheringCopper.WeatherState.OXIDIZED;
            case WeatheringCopper.WeatherState.OXIDIZED -> WeatheringCopper.WeatherState.OXIDIZED;
        };
    }

    private static WeatheringCopper.WeatherState getPreviousWeatherState(WeatheringCopper.WeatherState current) {
        return switch (current) {
            default -> throw new IncompatibleClassChangeError();
            case WeatheringCopper.WeatherState.UNAFFECTED -> WeatheringCopper.WeatherState.UNAFFECTED;
            case WeatheringCopper.WeatherState.EXPOSED -> WeatheringCopper.WeatherState.UNAFFECTED;
            case WeatheringCopper.WeatherState.WEATHERED -> WeatheringCopper.WeatherState.EXPOSED;
            case WeatheringCopper.WeatherState.OXIDIZED -> WeatheringCopper.WeatherState.WEATHERED;
        };
    }

    public CopperGolemEntity(EntityType<? extends AbstractGolem> entityType, Level level) {
        super(entityType, level);
        this.m_21573_().m_26529_(3.0f);
        this.m_21530_();
        this.m_21553_(true);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, 16.0f);
        this.m_21441_(BlockPathTypes.DANGER_OTHER, 16.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_FIRE, -1.0f);
        this.m_21441_(BlockPathTypes.DOOR_WOOD_CLOSED, 0.0f);
        this.m_21441_(BlockPathTypes.DOOR_OPEN, 0.0f);
        this.m_21441_(BlockPathTypes.DOOR_IRON_CLOSED, -1.0f);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 12.0).m_22268_(Attributes.f_22279_, (double)0.2f);
    }

    protected Brain.Provider<CopperGolemEntity> m_5490_() {
        return CopperGolemAi.brainProvider();
    }

    protected Brain<?> m_8075_(Dynamic<?> dynamic) {
        return CopperGolemAi.makeBrain((Brain<CopperGolemEntity>)this.m_5490_().m_22073_(dynamic));
    }

    public Brain<CopperGolemEntity> m_6274_() {
        return super.m_6274_();
    }

    protected PathNavigation m_6037_(Level level) {
        CopperGolemNavigation navigation = new CopperGolemNavigation((Mob)this, level);
        navigation.m_26477_(true);
        navigation.m_148214_(true);
        navigation.setRequiredPathLength(48.0f);
        return navigation;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_WEATHER_STATE, (Object)WeatheringCopper.WeatherState.UNAFFECTED.ordinal());
        this.f_19804_.m_135372_(COPPER_GOLEM_STATE, (Object)CopperGolemState.IDLE.ordinal());
    }

    public CopperGolemState getState() {
        int stateId = (Integer)this.f_19804_.m_135370_(COPPER_GOLEM_STATE);
        CopperGolemState[] states = CopperGolemState.values();
        return stateId >= 0 && stateId < states.length ? states[stateId] : CopperGolemState.IDLE;
    }

    public void setState(CopperGolemState state) {
        this.f_19804_.m_135381_(COPPER_GOLEM_STATE, (Object)state.ordinal());
    }

    public WeatheringCopper.WeatherState getWeatherState() {
        int weatherId = (Integer)this.f_19804_.m_135370_(DATA_WEATHER_STATE);
        WeatheringCopper.WeatherState[] states = WeatheringCopper.WeatherState.values();
        return weatherId >= 0 && weatherId < states.length ? states[weatherId] : WeatheringCopper.WeatherState.UNAFFECTED;
    }

    public void setWeatherState(WeatheringCopper.WeatherState weatherState) {
        this.f_19804_.m_135381_(DATA_WEATHER_STATE, (Object)weatherState.ordinal());
    }

    public void setOpenedChestPos(BlockPos openedChestPos) {
        this.openedChestPos = openedChestPos;
    }

    public void clearOpenedChestPos() {
        this.openedChestPos = null;
    }

    @Override
    public boolean hasContainerOpen(ContainerOpenersCounter openCounter, BlockPos pos) {
        return this.openedChestPos != null && this.openedChestPos.equals((Object)pos);
    }

    @Override
    public double getContainerInteractionRange() {
        return 4.0;
    }

    protected void m_8024_() {
        this.m_9236_().m_46473_().m_6180_("copperGolemBrain");
        this.m_6274_().m_21865_((ServerLevel)this.m_9236_(), (LivingEntity)this);
        this.m_9236_().m_46473_().m_7238_();
        this.m_9236_().m_46473_().m_6180_("copperGolemActivityUpdate");
        CopperGolemAi.updateActivity(this);
        this.m_9236_().m_46473_().m_7238_();
        super.m_8024_();
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128356_("next_weather_age", this.nextWeatheringTick);
        compound.m_128405_("weather_state", this.getWeatherState().ordinal());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.nextWeatheringTick = compound.m_128454_("next_weather_age");
        if (compound.m_128441_("weather_state")) {
            int weatherId = compound.m_128451_("weather_state");
            WeatheringCopper.WeatherState[] states = WeatheringCopper.WeatherState.values();
            if (weatherId >= 0 && weatherId < states.length) {
                this.setWeatherState(states[weatherId]);
            }
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().m_5776_()) {
            if (!this.m_21525_()) {
                this.setupAnimationStates();
            }
        } else {
            this.updateWeathering((ServerLevel)this.m_9236_(), this.m_9236_().m_213780_(), this.m_9236_().m_46467_());
        }
    }

    private void updateWeathering(ServerLevel level, RandomSource random, long dayTime) {
        if (this.nextWeatheringTick != -2L) {
            if (this.nextWeatheringTick == -1L) {
                this.nextWeatheringTick = dayTime + (long)random.m_216332_(504000, 552000);
            } else {
                boolean isOxidized;
                WeatheringCopper.WeatherState weatherState = this.getWeatherState();
                boolean bl = isOxidized = weatherState == WeatheringCopper.WeatherState.OXIDIZED;
                if (dayTime >= this.nextWeatheringTick && !isOxidized) {
                    WeatheringCopper.WeatherState nextState = CopperGolemEntity.getNextWeatherState(weatherState);
                    boolean willBeOxidized = nextState == WeatheringCopper.WeatherState.OXIDIZED;
                    this.setWeatherState(nextState);
                    long l = this.nextWeatheringTick = willBeOxidized ? 0L : this.nextWeatheringTick + (long)random.m_216332_(504000, 552000);
                }
                if (isOxidized && this.canTurnToStatue((Level)level)) {
                    this.turnToStatue(level);
                }
            }
        }
    }

    private boolean canTurnToStatue(Level level) {
        return level.m_8055_(this.m_20183_()).m_60713_(Blocks.f_50016_) && level.f_46441_.m_188501_() <= 0.0058f;
    }

    private void turnToStatue(ServerLevel level) {
        BlockPos blockPos = this.m_20183_();
        CopperGolemStatueBlock.Pose randomPose = CopperGolemStatueBlock.Pose.values()[this.f_19796_.m_216339_(0, CopperGolemStatueBlock.Pose.values().length)];
        level.m_7731_(blockPos, (BlockState)((BlockState)((CopperGolemStatueBlock)((Object)CopperGolemLegacy.OXIDIZED_COPPER_GOLEM_STATUE.get())).m_49966_().m_61124_(CopperGolemStatueBlock.POSE, (Comparable)((Object)randomPose))).m_61124_((Property)CopperGolemStatueBlock.FACING, (Comparable)Direction.m_122364_((double)this.m_146908_())), 3);
        BlockEntity blockEntity = level.m_7702_(blockPos);
        if (blockEntity instanceof CopperGolemStatueBlockEntity) {
            CopperGolemStatueBlockEntity statueEntity = (CopperGolemStatueBlockEntity)blockEntity;
            statueEntity.createStatue(this);
            this.m_216990_((SoundEvent)ModSounds.COPPER_GOLEM_BECOME_STATUE.get());
            level.m_5594_(null, blockPos, (SoundEvent)ModSounds.COPPER_STATUE_BECOME.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            if (this.m_21523_()) {
                this.m_21455_(true, level.m_46469_().m_46207_(GameRules.f_46137_));
            }
            this.m_146870_();
        }
    }

    private void setupAnimationStates() {
        switch (this.getState()) {
            case IDLE: {
                this.interactionGetNoItemAnimationState.m_216973_();
                this.interactionGetItemAnimationState.m_216973_();
                this.interactionDropItemAnimationState.m_216973_();
                this.interactionDropNoItemAnimationState.m_216973_();
                this.pressingButtonAnimationState.m_216973_();
                if (this.idleAnimationStartTick == this.f_19797_) {
                    this.idleAnimationState.m_216977_(this.f_19797_);
                } else if (this.idleAnimationStartTick == 0) {
                    this.idleAnimationStartTick = this.f_19797_ + this.f_19796_.m_216339_(200, 240);
                }
                if (this.f_19797_ != this.idleAnimationStartTick + 10) break;
                this.playHeadSpinSound();
                this.idleAnimationStartTick = 0;
                break;
            }
            case GETTING_ITEM: {
                this.idleAnimationState.m_216973_();
                this.idleAnimationStartTick = 0;
                this.interactionGetNoItemAnimationState.m_216973_();
                this.interactionDropItemAnimationState.m_216973_();
                this.interactionDropNoItemAnimationState.m_216973_();
                this.pressingButtonAnimationState.m_216973_();
                this.interactionGetItemAnimationState.m_216982_(this.f_19797_);
                break;
            }
            case GETTING_NO_ITEM: {
                this.idleAnimationState.m_216973_();
                this.idleAnimationStartTick = 0;
                this.interactionGetItemAnimationState.m_216973_();
                this.interactionDropNoItemAnimationState.m_216973_();
                this.interactionDropItemAnimationState.m_216973_();
                this.pressingButtonAnimationState.m_216973_();
                this.interactionGetNoItemAnimationState.m_216982_(this.f_19797_);
                break;
            }
            case DROPPING_ITEM: {
                this.idleAnimationState.m_216973_();
                this.idleAnimationStartTick = 0;
                this.interactionGetItemAnimationState.m_216973_();
                this.interactionGetNoItemAnimationState.m_216973_();
                this.interactionDropNoItemAnimationState.m_216973_();
                this.pressingButtonAnimationState.m_216973_();
                this.interactionDropItemAnimationState.m_216982_(this.f_19797_);
                break;
            }
            case DROPPING_NO_ITEM: {
                this.idleAnimationState.m_216973_();
                this.idleAnimationStartTick = 0;
                this.interactionGetItemAnimationState.m_216973_();
                this.interactionGetNoItemAnimationState.m_216973_();
                this.interactionDropItemAnimationState.m_216973_();
                this.pressingButtonAnimationState.m_216973_();
                this.interactionDropNoItemAnimationState.m_216982_(this.f_19797_);
                break;
            }
            case PRESSING_BUTTON: {
                this.idleAnimationState.m_216973_();
                this.idleAnimationStartTick = 0;
                this.interactionGetItemAnimationState.m_216973_();
                this.interactionGetNoItemAnimationState.m_216973_();
                this.interactionDropItemAnimationState.m_216973_();
                this.interactionDropNoItemAnimationState.m_216973_();
                this.pressingButtonAnimationState.m_216982_(this.f_19797_);
            }
        }
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        Level level = this.m_9236_();
        if (itemstack.m_150930_(Items.f_42574_) && this.m_6220_()) {
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                this.m_5851_(SoundSource.PLAYERS);
                itemstack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
            }
            return InteractionResult.m_19078_((boolean)level.m_5776_());
        }
        if (itemstack.m_150930_(Items.f_42784_) && this.nextWeatheringTick != -2L) {
            if (!level.m_5776_()) {
                level.m_5898_(null, 3003, this.m_20183_(), 0);
                this.nextWeatheringTick = -2L;
                itemstack.m_41774_(1);
            }
            return InteractionResult.m_19078_((boolean)level.m_5776_());
        }
        if (itemstack.m_204117_(ItemTags.f_271207_)) {
            if (!level.m_5776_()) {
                WeatheringCopper.WeatherState weatherState = this.getWeatherState();
                if (this.nextWeatheringTick == -2L) {
                    level.m_6269_(null, (Entity)this, SoundEvents.f_144059_, this.m_5720_(), 1.0f, 1.0f);
                    level.m_5898_(null, 3004, this.m_20183_(), 0);
                    this.nextWeatheringTick = -1L;
                    itemstack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
                    return InteractionResult.SUCCESS;
                }
                if (weatherState != WeatheringCopper.WeatherState.UNAFFECTED) {
                    level.m_6269_(null, (Entity)this, SoundEvents.f_144059_, this.m_5720_(), 1.0f, 1.0f);
                    level.m_5898_(null, 3005, this.m_20183_(), 0);
                    this.nextWeatheringTick = -1L;
                    this.setWeatherState(CopperGolemEntity.getPreviousWeatherState(weatherState));
                    itemstack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
                    return InteractionResult.SUCCESS;
                }
            }
            return InteractionResult.m_19078_((boolean)level.m_5776_());
        }
        return super.m_6071_(player, hand);
    }

    private void playHeadSpinSound() {
        if (!this.m_20067_()) {
            this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.getSpinHeadSound(), this.m_5720_(), 1.0f, 1.0f, false);
        }
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return CopperGolemOxidationLevels.getOxidationLevel(this.getWeatherState()).hurtSound();
    }

    protected SoundEvent m_5592_() {
        return CopperGolemOxidationLevels.getOxidationLevel(this.getWeatherState()).deathSound();
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        this.m_5496_(CopperGolemOxidationLevels.getOxidationLevel(this.getWeatherState()).stepSound(), 1.0f, 1.0f);
    }

    protected float m_6121_() {
        return 1.0f;
    }

    protected float m_6059_() {
        return this.f_19788_ + 0.6f;
    }

    private SoundEvent getSpinHeadSound() {
        return CopperGolemOxidationLevels.getOxidationLevel(this.getWeatherState()).spinHeadSound();
    }

    public Vec3 m_7939_() {
        return new Vec3(0.0, 0.75 * (double)this.m_20192_(), 0.0);
    }

    public void m_5851_(SoundSource source) {
        this.m_9236_().m_6269_(null, (Entity)this, SoundEvents.f_12344_, source, 1.0f, 1.0f);
        ItemStack antennaItem = this.m_6844_(EquipmentSlot.HEAD);
        if (!antennaItem.m_41619_()) {
            this.m_8061_(EquipmentSlot.HEAD, ItemStack.f_41583_);
            this.m_5552_(antennaItem, 1.5f);
        }
    }

    public boolean m_6220_() {
        return this.m_6084_() && !this.m_6844_(EquipmentSlot.HEAD).m_41619_();
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag dataTag) {
        this.m_216990_(SoundEvents.f_12009_);
        return super.m_6518_(level, difficulty, spawnType, spawnData, dataTag);
    }

    public void m_8038_(ServerLevel level, LightningBolt lightning) {
        super.m_8038_(level, lightning);
        WeatheringCopper.WeatherState weatherState = this.getWeatherState();
        if (weatherState != WeatheringCopper.WeatherState.UNAFFECTED) {
            this.nextWeatheringTick = -1L;
            this.setWeatherState(CopperGolemEntity.getPreviousWeatherState(weatherState));
        }
    }

    public boolean m_6469_(DamageSource source, float amount) {
        boolean result = super.m_6469_(source, amount);
        if (result) {
            this.setState(CopperGolemState.IDLE);
        }
        return result;
    }

    protected void m_7472_(DamageSource damageSource, int looting, boolean hitByPlayer) {
        super.m_7472_(damageSource, looting, hitByPlayer);
        ItemStack copperIngots = new ItemStack((ItemLike)Items.f_151052_, 3);
        this.m_19983_(copperIngots);
    }
}

