/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.mixinextras.sugar.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.spongepowered.asm.mixin.injection.struct.InjectionInfo;
import org.spongepowered.asm.mixin.injection.struct.InjectionNodes;
import org.spongepowered.asm.mixin.injection.struct.Target;
import org.spongepowered.asm.util.Annotations;
import virtuoel.mixinextras.injector.StackExtension;
import virtuoel.mixinextras.sugar.impl.SugarApplicationException;
import virtuoel.mixinextras.sugar.impl.SugarApplicator;
import virtuoel.mixinextras.sugar.impl.SugarParameter;
import virtuoel.mixinextras.sugar.impl.ref.LocalRefUtils;
import virtuoel.mixinextras.utils.ASMUtils;
import virtuoel.mixinextras.utils.TargetDecorations;

class ShareSugarApplicator
extends SugarApplicator {
    private final String id;
    private Type innerType;

    ShareSugarApplicator(InjectionInfo info, SugarParameter parameter) {
        super(info, parameter);
        this.id = this.mixin.getClassRef() + ':' + Annotations.getValue((AnnotationNode)this.sugar);
    }

    @Override
    void validate(Target target, InjectionNodes.InjectionNode node) {
        this.innerType = LocalRefUtils.getTargetType(this.paramType, Type.getType(Object.class));
        if (this.innerType == this.paramType) {
            throw new SugarApplicationException("@Share parameter must be some variation of LocalRef.");
        }
    }

    @Override
    void prepare(Target target, InjectionNodes.InjectionNode node) {
    }

    @Override
    void inject(Target target, InjectionNodes.InjectionNode node, StackExtension stack) {
        int localRefIndex;
        Map refIndices = TargetDecorations.getOrPut(target, "ShareSugar_LocalRefIndices", HashMap::new);
        if (!refIndices.containsKey(this.id)) {
            localRefIndex = target.allocateLocal();
            refIndices.put(this.id, localRefIndex);
            LabelNode start = new LabelNode();
            LabelNode end = new LabelNode();
            target.addLocalVariable(localRefIndex, "sharedRef" + localRefIndex, this.paramType.getDescriptor());
            List lvt = target.method.localVariables;
            LocalVariableNode newVar = (LocalVariableNode)lvt.get(lvt.size() - 1);
            newVar.start = start;
            newVar.end = end;
            target.insns.insert((AbstractInsnNode)start);
            target.insns.add((AbstractInsnNode)end);
            InsnList init = new InsnList();
            LocalRefUtils.generateNew(init, this.innerType);
            init.add((AbstractInsnNode)new VarInsnNode(58, localRefIndex));
            init.add((AbstractInsnNode)new VarInsnNode(25, localRefIndex));
            init.add((AbstractInsnNode)new InsnNode(ASMUtils.getDummyOpcodeForType(this.innerType)));
            LocalRefUtils.generateInitialization(init, this.innerType);
            target.insns.insert((AbstractInsnNode)start, init);
            stack.ensureAtLeast(this.innerType.getSize() + 1);
        } else {
            localRefIndex = (Integer)refIndices.get(this.id);
        }
        stack.extra(1);
        target.insns.insertBefore(node.getCurrentTarget(), (AbstractInsnNode)new VarInsnNode(25, localRefIndex));
    }
}

