/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.pehkui.server.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import net.minecraft.block.Blocks;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.network.NetworkDirection;
import org.spongepowered.asm.mixin.MixinEnvironment;
import virtuoel.pehkui.api.PehkuiConfig;
import virtuoel.pehkui.network.DebugPayload;
import virtuoel.pehkui.network.PehkuiPacketHandler;
import virtuoel.pehkui.util.CommandUtils;
import virtuoel.pehkui.util.I18nUtils;
import virtuoel.pehkui.util.NbtCompoundExtensions;
import virtuoel.pehkui.util.ReflectionUtils;

public class DebugCommand {
    private static final Collection<UUID> MARKED_UUIDS = new HashSet<UUID>();
    private static final Collection<String> MARKED_USERNAMES = new HashSet<String>();
    private static final List<EntityType<? extends Entity>> TYPES = Arrays.asList(EntityType.field_200725_aD, EntityType.field_200797_k, EntityType.field_200801_o, EntityType.field_200792_f);

    public static void register(CommandDispatcher<CommandSource> commandDispatcher) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)Commands.func_197057_a((String)"scale").requires(source -> source.func_197034_c(2));
        if (!FMLLoader.isProduction() || ((Boolean)PehkuiConfig.COMMON.enableCommands.get()).booleanValue()) {
            builder.then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"debug").then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"delete_scale_data").then(Commands.func_197057_a((String)"uuid").then(Commands.func_197056_a((String)"uuid", (ArgumentType)StringArgumentType.string()).executes(context -> {
                String uuidString = StringArgumentType.getString((CommandContext)context, (String)"uuid");
                try {
                    MARKED_UUIDS.add(UUID.fromString(uuidString));
                }
                catch (IllegalArgumentException e) {
                    ((CommandSource)context.getSource()).func_197021_a(I18nUtils.translate("commands.pehkui.debug.delete.uuid.invalid", "Invalid UUID \"%s\".", uuidString));
                    return 0;
                }
                return 1;
            })))).then(Commands.func_197057_a((String)"username").then(Commands.func_197056_a((String)"username", (ArgumentType)StringArgumentType.string()).executes(context -> {
                MARKED_USERNAMES.add(StringArgumentType.getString((CommandContext)context, (String)"username").toLowerCase(Locale.ROOT));
                return 1;
            }))))).then(Commands.func_197057_a((String)"garbage_collect").executes(context -> {
                IPacket packet = PehkuiPacketHandler.INSTANCE.toVanillaPacket((Object)new DebugPayload(PacketType.GARBAGE_COLLECT), NetworkDirection.PLAY_TO_CLIENT);
                ReflectionUtils.sendPacket(((CommandSource)context.getSource()).func_197035_h().field_71135_a, packet);
                System.gc();
                return 1;
            })));
        }
        if (!FMLLoader.isProduction() || ((Boolean)PehkuiConfig.COMMON.enableDebugCommands.get()).booleanValue()) {
            builder.then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"debug").then(Commands.func_197057_a((String)"run_mixin_tests").executes(DebugCommand::runMixinTests))).then(Commands.func_197057_a((String)"run_tests").executes(DebugCommand::runTests)));
        }
        commandDispatcher.register(builder);
    }

    public static boolean unmarkEntityForScaleReset(Entity entity, CompoundNBT nbt) {
        if (entity instanceof PlayerEntity && MARKED_USERNAMES.remove(((PlayerEntity)entity).func_146103_bH().getName().toLowerCase(Locale.ROOT))) {
            return true;
        }
        NbtCompoundExtensions compound = (NbtCompoundExtensions)nbt;
        return compound.pehkui_containsUuid("UUID") && MARKED_UUIDS.remove(compound.pehkui_getUuid("UUID"));
    }

    private static int runTests(CommandContext<CommandSource> context) throws CommandSyntaxException {
        Entity entity = ((CommandSource)context.getSource()).func_197027_g();
        Direction dir = entity.func_174811_aO();
        Direction opposite = dir.func_176734_d();
        Direction left = dir.func_176735_f();
        Direction right = dir.func_176746_e();
        int distance = 4;
        int spacing = 2;
        int width = (TYPES.size() - 1) * (spacing + 1) + 1;
        Vector3d pos = entity.func_213303_ch();
        BlockPos.Mutable mut = new BlockPos.Mutable(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c).func_189534_c(dir, distance).func_189534_c(left, width / 2);
        World w = entity.func_130014_f_();
        for (EntityType<? extends Entity> t : TYPES) {
            w.func_175656_a((BlockPos)mut, Blocks.field_196657_h.func_176223_P());
            Entity e = t.func_200721_a(w);
            e.func_70080_a((double)mut.func_177958_n() + 0.5, (double)(mut.func_177956_o() + 1), (double)mut.func_177952_p() + 0.5, opposite.func_185119_l(), 0.0f);
            e.func_70012_b((double)mut.func_177958_n() + 0.5, (double)(mut.func_177956_o() + 1), (double)mut.func_177952_p() + 0.5, opposite.func_185119_l(), 0.0f);
            e.func_70034_d(opposite.func_185119_l());
            e.func_184211_a("pehkui");
            w.func_217376_c(e);
            mut.func_189534_c(right, spacing + 1);
        }
        int successes = -1;
        int total = -1;
        CommandUtils.sendFeedback((CommandSource)context.getSource(), () -> I18nUtils.translate("commands.pehkui.debug.test.success", "Tests succeeded: %d/%d", successes, total), false);
        return 1;
    }

    private static int runMixinTests(CommandContext<CommandSource> context) throws CommandSyntaxException {
        Entity executor = ((CommandSource)context.getSource()).func_197022_f();
        if (executor instanceof ServerPlayerEntity) {
            IPacket packet = PehkuiPacketHandler.INSTANCE.toVanillaPacket((Object)new DebugPayload(PacketType.MIXIN_AUDIT), NetworkDirection.PLAY_TO_CLIENT);
            ReflectionUtils.sendPacket(((ServerPlayerEntity)executor).field_71135_a, packet);
        }
        CommandUtils.sendFeedback((CommandSource)context.getSource(), () -> I18nUtils.translate("commands.pehkui.debug.audit.start", "Starting Mixin environment audit..."), false);
        MixinEnvironment.getCurrentEnvironment().audit();
        CommandUtils.sendFeedback((CommandSource)context.getSource(), () -> I18nUtils.translate("commands.pehkui.debug.audit.end", "Mixin environment audit complete!"), false);
        return 1;
    }

    public static enum PacketType {
        MIXIN_AUDIT,
        GARBAGE_COLLECT;

    }
}

