/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse.client.renderers.entities;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.wenxin2.marioverse.client.models.entities.GoombaModel;
import com.wenxin2.marioverse.entities.GoombaEntity;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.AbstractSkullBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SkullBlock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.cache.texture.AutoGlowingTexture;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.renderer.layer.AutoGlowingGeoLayer;
import software.bernie.geckolib.renderer.layer.BlockAndItemGeoLayer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;
import software.bernie.geckolib.renderer.layer.ItemArmorGeoLayer;
import software.bernie.geckolib.util.ClientUtil;

public class GoombaRenderer
extends GeoEntityRenderer<GoombaEntity> {
    private static final String HELMET = "armorBipedHead";

    public GoombaRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, (GeoModel)new GoombaModel());
        this.shadowRadius = 0.5f;
        this.addRenderLayer((GeoRenderLayer)new AutoGlowingGeoLayer<GoombaEntity>(this, (GeoRenderer)this){

            @Nullable
            protected RenderType getRenderType(GoombaEntity animatable, @Nullable MultiBufferSource bufferSource) {
                if (animatable.getCustomName() != null && animatable.getCustomName().getString().toLowerCase(Locale.ROOT).equals("goombella")) {
                    if (animatable instanceof Entity) {
                        GoombaEntity entity = animatable;
                        boolean invisible = entity.isInvisible();
                        ResourceLocation texture = AutoGlowingTexture.getEmissiveResource((ResourceLocation)this.getTextureResource((GeoAnimatable)animatable));
                        if (invisible && !entity.isInvisibleTo(ClientUtil.getClientPlayer())) {
                            return RenderType.itemEntityTranslucentCull((ResourceLocation)texture);
                        }
                        if (Minecraft.getInstance().shouldEntityAppearGlowing((Entity)entity)) {
                            return invisible ? RenderType.outline((ResourceLocation)texture) : AutoGlowingTexture.getOutlineRenderType((ResourceLocation)this.getTextureResource((GeoAnimatable)animatable));
                        }
                        return invisible ? null : AutoGlowingTexture.getRenderType((ResourceLocation)this.getTextureResource((GeoAnimatable)animatable));
                    }
                    return AutoGlowingTexture.getRenderType((ResourceLocation)this.getTextureResource((GeoAnimatable)animatable));
                }
                return null;
            }
        });
        this.addRenderLayer((GeoRenderLayer)new ItemArmorGeoLayer<GoombaEntity>(this, (GeoRenderer)this){

            @Nullable
            protected ItemStack getArmorItemForBone(GeoBone bone, GoombaEntity animatable) {
                return switch (bone.getName()) {
                    case GoombaRenderer.HELMET -> animatable.getItemBySlot(EquipmentSlot.HEAD);
                    default -> null;
                };
            }

            @NotNull
            protected EquipmentSlot getEquipmentSlotForBone(GeoBone bone, ItemStack stack, GoombaEntity animatable) {
                return switch (bone.getName()) {
                    case GoombaRenderer.HELMET -> EquipmentSlot.HEAD;
                    default -> super.getEquipmentSlotForBone(bone, stack, (LivingEntity)animatable);
                };
            }

            @NotNull
            protected ModelPart getModelPartForBone(GeoBone bone, EquipmentSlot slot, ItemStack stack, GoombaEntity animatable, HumanoidModel<?> baseModel) {
                return switch (bone.getName()) {
                    case GoombaRenderer.HELMET -> baseModel.head;
                    default -> super.getModelPartForBone(bone, slot, stack, (LivingEntity)animatable, baseModel);
                };
            }

            protected void renderSkullAsArmor(PoseStack poseStack, GeoBone bone, ItemStack stack, AbstractSkullBlock skullBlock, MultiBufferSource bufferSource, int packedLight) {
                poseStack.scale(1.0f, 1.0f, 0.94f);
                poseStack.translate(0.0f, 0.0f, 0.0f);
                super.renderSkullAsArmor(poseStack, bone, stack, skullBlock, bufferSource, packedLight);
            }

            private void renderGoombellaSkullAsArmor(PoseStack poseStack, GeoBone bone, ItemStack stack, AbstractSkullBlock skullBlock, MultiBufferSource bufferSource, int packedLight) {
                poseStack.scale(1.28f, 1.28f, 1.22f);
                poseStack.translate(0.0f, -0.125f, 0.0f);
                super.renderSkullAsArmor(poseStack, bone, stack, skullBlock, bufferSource, packedLight);
            }

            public void renderForBone(PoseStack poseStack, GoombaEntity animatable, GeoBone bone, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, float partialTick, int packedLight, int packedOverlay) {
                ItemStack armorStack = this.getArmorItemForBone(bone, animatable);
                if (animatable.getCustomName() != null && animatable.getCustomName().getString().toLowerCase(Locale.ROOT).equals("goombella")) {
                    BlockItem blockItem;
                    Block var17;
                    Item var13;
                    if (armorStack != null && (var13 = armorStack.getItem()) instanceof BlockItem && (var17 = (blockItem = (BlockItem)var13).getBlock()) instanceof AbstractSkullBlock) {
                        AbstractSkullBlock skullBlock = (AbstractSkullBlock)var17;
                        this.renderGoombellaSkullAsArmor(poseStack, bone, armorStack, skullBlock, bufferSource, packedLight);
                        return;
                    }
                } else {
                    super.renderForBone(poseStack, (LivingEntity)animatable, bone, renderType, bufferSource, buffer, partialTick, packedLight, packedOverlay);
                }
            }
        });
        this.addRenderLayer((GeoRenderLayer)new BlockAndItemGeoLayer<GoombaEntity>(this, (GeoRenderer)this){

            @Nullable
            protected ItemStack getStackForBone(GeoBone bone, GoombaEntity animatable) {
                BlockItem blockItem;
                Object object;
                if (!(animatable.getItemBySlot(EquipmentSlot.HEAD).getItem() instanceof ArmorItem || (object = animatable.getItemBySlot(EquipmentSlot.HEAD).getItem()) instanceof BlockItem && (blockItem = (BlockItem)object).getBlock() instanceof SkullBlock)) {
                    return switch (bone.getName()) {
                        case GoombaRenderer.HELMET -> animatable.getItemBySlot(EquipmentSlot.HEAD);
                        default -> null;
                    };
                }
                return null;
            }

            protected ItemDisplayContext getTransformTypeForStack(GeoBone bone, ItemStack stack, GoombaEntity animatable) {
                return switch (bone.getName()) {
                    case GoombaRenderer.HELMET -> ItemDisplayContext.HEAD;
                    default -> ItemDisplayContext.NONE;
                };
            }

            protected void renderStackForBone(PoseStack poseStack, GeoBone bone, ItemStack stack, GoombaEntity animatable, MultiBufferSource bufferSource, float partialTick, int packedLight, int packedOverlay) {
                if (animatable.getCustomName() != null && animatable.getCustomName().getString().toLowerCase(Locale.ROOT).equals("goombella")) {
                    poseStack.scale(0.975f, 0.975f, 0.925f);
                    poseStack.translate(0.0f, 0.5f, 0.0f);
                } else if (stack.getItem() instanceof BlockItem) {
                    poseStack.scale(0.775f, 0.775f, 0.725f);
                    poseStack.translate(0.0f, 0.5f, 0.0f);
                } else {
                    poseStack.translate(0.0f, 0.5f, 0.0f);
                }
                super.renderStackForBone(poseStack, bone, stack, (GeoAnimatable)animatable, bufferSource, partialTick, packedLight, packedOverlay);
            }
        });
    }

    protected float getDeathMaxRotation(GoombaEntity animatable) {
        return 0.0f;
    }
}

