/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse.client.renderers.entities;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.wenxin2.marioverse.client.models.entities.KoopaTroopaModel;
import com.wenxin2.marioverse.entities.GoldKoopaTroopaEntity;
import com.wenxin2.marioverse.entities.KoopaTroopaEntity;
import com.wenxin2.marioverse.registries.ParticleRegistry;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.level.block.AbstractSkullBlock;
import net.minecraft.world.level.block.SkullBlock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.renderer.layer.BlockAndItemGeoLayer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;
import software.bernie.geckolib.renderer.layer.ItemArmorGeoLayer;

public class KoopaTroopaRenderer
extends GeoEntityRenderer<KoopaTroopaEntity> {
    private static final String HELMET = "armorHead";
    private static final String CHEST = "armorBody";
    private static final String LEFT_ARM = "armorLeftArm";
    private static final String RIGHT_ARM = "armorRightArm";
    private static final String LEFT_LEG = "armorLeftLeg";
    private static final String RIGHT_LEG = "armorRightLeg";
    private static final String LEFT_BOOT = "armorLeftBoot";
    private static final String RIGHT_BOOT = "armorRightBoot";
    protected ItemStack mainHandItem;
    protected ItemStack offhandItem;

    public KoopaTroopaRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, (GeoModel)new KoopaTroopaModel());
        this.shadowRadius = 0.5f;
        this.addRenderLayer((GeoRenderLayer)new ItemArmorGeoLayer<KoopaTroopaEntity>(this, (GeoRenderer)this){

            @Nullable
            protected ItemStack getArmorItemForBone(GeoBone bone, KoopaTroopaEntity animatable) {
                return switch (bone.getName()) {
                    case KoopaTroopaRenderer.HELMET -> this.helmetStack;
                    case KoopaTroopaRenderer.CHEST, KoopaTroopaRenderer.LEFT_ARM, KoopaTroopaRenderer.RIGHT_ARM -> this.chestplateStack;
                    case KoopaTroopaRenderer.LEFT_LEG, KoopaTroopaRenderer.RIGHT_LEG -> this.leggingsStack;
                    case KoopaTroopaRenderer.LEFT_BOOT, KoopaTroopaRenderer.RIGHT_BOOT -> this.bootsStack;
                    default -> super.getArmorItemForBone(bone, (LivingEntity)animatable);
                };
            }

            @NotNull
            protected EquipmentSlot getEquipmentSlotForBone(GeoBone bone, ItemStack stack, KoopaTroopaEntity animatable) {
                return switch (bone.getName()) {
                    case KoopaTroopaRenderer.HELMET -> EquipmentSlot.HEAD;
                    case KoopaTroopaRenderer.CHEST -> EquipmentSlot.CHEST;
                    case KoopaTroopaRenderer.RIGHT_ARM -> {
                        if (!animatable.isLeftHanded()) {
                            yield EquipmentSlot.MAINHAND;
                        }
                        yield EquipmentSlot.OFFHAND;
                    }
                    case KoopaTroopaRenderer.LEFT_ARM -> {
                        if (animatable.isLeftHanded()) {
                            yield EquipmentSlot.OFFHAND;
                        }
                        yield EquipmentSlot.MAINHAND;
                    }
                    case KoopaTroopaRenderer.LEFT_LEG, KoopaTroopaRenderer.RIGHT_LEG -> EquipmentSlot.LEGS;
                    case KoopaTroopaRenderer.LEFT_BOOT, KoopaTroopaRenderer.RIGHT_BOOT -> EquipmentSlot.FEET;
                    default -> super.getEquipmentSlotForBone(bone, stack, (LivingEntity)animatable);
                };
            }

            @NotNull
            protected ModelPart getModelPartForBone(GeoBone bone, EquipmentSlot slot, ItemStack stack, KoopaTroopaEntity animatable, HumanoidModel<?> baseModel) {
                return switch (bone.getName()) {
                    case KoopaTroopaRenderer.HELMET -> baseModel.head;
                    case KoopaTroopaRenderer.CHEST -> baseModel.body;
                    case KoopaTroopaRenderer.LEFT_ARM -> baseModel.leftArm;
                    case KoopaTroopaRenderer.RIGHT_ARM -> baseModel.rightArm;
                    case KoopaTroopaRenderer.LEFT_LEG, KoopaTroopaRenderer.LEFT_BOOT -> baseModel.leftLeg;
                    case KoopaTroopaRenderer.RIGHT_LEG, KoopaTroopaRenderer.RIGHT_BOOT -> baseModel.rightLeg;
                    default -> super.getModelPartForBone(bone, slot, stack, (LivingEntity)animatable, baseModel);
                };
            }

            protected void renderSkullAsArmor(PoseStack poseStack, GeoBone bone, ItemStack stack, AbstractSkullBlock skullBlock, MultiBufferSource bufferSource, int packedLight) {
                poseStack.scale(1.0f, 1.0f, 1.0f);
                poseStack.mulPose(Axis.XP.rotationDegrees(-30.0f));
                poseStack.translate(0.0f, 0.05f, 0.75f);
                super.renderSkullAsArmor(poseStack, bone, stack, skullBlock, bufferSource, packedLight);
            }
        });
        this.addRenderLayer((GeoRenderLayer)new BlockAndItemGeoLayer<KoopaTroopaEntity>((GeoRenderer)this){

            @Nullable
            protected ItemStack getStackForBone(GeoBone bone, KoopaTroopaEntity animatable) {
                return switch (bone.getName()) {
                    case KoopaTroopaRenderer.HELMET -> {
                        BlockItem blockItem;
                        Item var6_5;
                        if (!(animatable.getItemBySlot(EquipmentSlot.HEAD).getItem() instanceof ArmorItem || (var6_5 = animatable.getItemBySlot(EquipmentSlot.HEAD).getItem()) instanceof BlockItem && (blockItem = (BlockItem)var6_5).getBlock() instanceof SkullBlock)) {
                            yield animatable.getItemBySlot(EquipmentSlot.HEAD);
                        }
                        yield ItemStack.EMPTY;
                    }
                    case KoopaTroopaRenderer.LEFT_ARM -> {
                        if (animatable.isLeftHanded()) {
                            yield KoopaTroopaRenderer.this.mainHandItem;
                        }
                        yield KoopaTroopaRenderer.this.offhandItem;
                    }
                    case KoopaTroopaRenderer.RIGHT_ARM -> {
                        if (animatable.isLeftHanded()) {
                            yield KoopaTroopaRenderer.this.offhandItem;
                        }
                        yield KoopaTroopaRenderer.this.mainHandItem;
                    }
                    default -> null;
                };
            }

            protected ItemDisplayContext getTransformTypeForStack(GeoBone bone, ItemStack stack, KoopaTroopaEntity animatable) {
                return switch (bone.getName()) {
                    case KoopaTroopaRenderer.HELMET -> ItemDisplayContext.HEAD;
                    case KoopaTroopaRenderer.LEFT_ARM, KoopaTroopaRenderer.RIGHT_ARM -> ItemDisplayContext.THIRD_PERSON_RIGHT_HAND;
                    default -> ItemDisplayContext.NONE;
                };
            }

            protected void renderStackForBone(PoseStack poseStack, GeoBone bone, ItemStack stack, KoopaTroopaEntity animatable, MultiBufferSource bufferSource, float partialTick, int packedLight, int packedOverlay) {
                if (stack == KoopaTroopaRenderer.this.mainHandItem) {
                    poseStack.mulPose(Axis.XP.rotationDegrees(-90.0f));
                    poseStack.translate(0.0, 0.125, -0.5);
                    if (stack.getItem() instanceof ShieldItem) {
                        poseStack.translate(-0.05, 0.0, 0.4);
                    }
                } else if (stack == KoopaTroopaRenderer.this.offhandItem) {
                    poseStack.mulPose(Axis.XP.rotationDegrees(-90.0f));
                    poseStack.translate(0.0, 0.125, -0.5);
                    if (stack.getItem() instanceof ShieldItem) {
                        poseStack.translate(-0.05, 0.0, 0.4);
                        poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
                    }
                } else if (stack.getItem() instanceof BlockItem) {
                    poseStack.scale(0.85f, 0.85f, 0.85f);
                    poseStack.mulPose(Axis.XP.rotationDegrees(-30.0f));
                    poseStack.translate(0.0f, 0.5f, 0.1f);
                } else {
                    poseStack.scale(0.6f, 0.6f, 0.6f);
                    poseStack.translate(0.0f, 0.5f, 0.0f);
                }
                super.renderStackForBone(poseStack, bone, stack, (GeoAnimatable)animatable, bufferSource, partialTick, packedLight, packedOverlay);
            }
        });
    }

    public void preRender(PoseStack poseStack, KoopaTroopaEntity animatable, BakedGeoModel model, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int colour) {
        super.preRender(poseStack, (Entity)animatable, model, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, colour);
        this.mainHandItem = animatable.getMainHandItem();
        this.offhandItem = animatable.getOffhandItem();
    }

    public void renderFinal(PoseStack poseStack, KoopaTroopaEntity animatable, BakedGeoModel model, MultiBufferSource bufferSource, @Nullable VertexConsumer buffer, float partialTick, int packedLight, int packedOverlay, int color) {
        if (animatable instanceof GoldKoopaTroopaEntity) {
            this.model.getBone("shell_particles").ifPresent(bone -> {
                Vector3d bonePos = bone.getWorldPosition();
                if (animatable.tickCount % 80 == 0) {
                    double randomX = (Math.random() - 0.5) * (double)bone.getScaleX();
                    double randomY = (Math.random() - 0.5) * (double)bone.getScaleY();
                    double randomZ = (Math.random() - 0.5) * (double)bone.getScaleZ();
                    animatable.getCommandSenderWorld().addParticle((ParticleOptions)ParticleRegistry.COIN_GLINT.get(), bonePos.x() + randomX, bonePos.y() + randomY, bonePos.z() + randomZ, 0.0, 0.0, 0.0);
                }
            });
        }
        super.renderFinal(poseStack, (Entity)animatable, model, bufferSource, buffer, partialTick, packedLight, packedOverlay, color);
    }
}

