/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse.utils;

import com.wenxin2.marioverse.blocks.WarpPipeBlock;
import com.wenxin2.marioverse.blocks.entities.BaseWarpBlockEntity;
import com.wenxin2.marioverse.blocks.entities.WarpDoorBlockEntity;
import com.wenxin2.marioverse.blocks.entities.WarpPipeBlockEntity;
import com.wenxin2.marioverse.blocks.entities.WarpTrapDoorBlockEntity;
import com.wenxin2.marioverse.registries.ConfigRegistry;
import com.wenxin2.marioverse.registries.SoundRegistry;
import com.wenxin2.marioverse.registries.TagRegistry;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public interface BlockWarpEntityHandler {
    public boolean mv$getBlockWarpTeleportConfig();

    private static boolean getShiftKeyForEntity(Entity entity) {
        return !entity.isShiftKeyDown() && !(entity instanceof Player) || entity.isShiftKeyDown() && entity instanceof Player;
    }

    public boolean mv$doPreventWarp();

    public void mv$setPreventWarp(boolean var1);

    public int mv$getPreventWarpCooldown();

    public void mv$setPreventWarpCooldown(int var1);

    public int mv$getWarpCooldown();

    public void mv$setWarpCooldown(int var1);

    default public void enterWarp(Entity entity, Level world, BlockPos pos) {
        int entityId;
        BlockPos warpPos;
        BaseWarpBlockEntity warpBE;
        BlockState state = world.getBlockState(pos);
        BlockState stateAboveEntity = world.getBlockState(pos.above(Math.round(entity.getBbHeight())));
        BlockEntity blockEntity = world.getBlockEntity(pos);
        BlockEntity blockEntityAbove = world.getBlockEntity(pos.above(Math.round(entity.getBbHeight())));
        if (blockEntity instanceof BaseWarpBlockEntity && (warpBE = (BaseWarpBlockEntity)blockEntity).getLevel() != null) {
            warpPos = warpBE.destinationPos;
            entityId = entity.getId();
            if (BaseWarpBlockEntity.WARPED_ENTITIES.getOrDefault(entityId, true).booleanValue()) {
                BaseWarpBlockEntity.WARPED_ENTITIES.put(entityId, false);
            }
            if (state.getBlock() instanceof DoorBlock || state.getBlock() instanceof TrapDoorBlock) {
                this.enterWarpDoor(entity, world, pos, warpPos, warpBE);
            }
            if (state.getBlock() instanceof WarpPipeBlock) {
                this.enterWarpPipe(entity, world, pos, warpPos, warpBE);
            }
        }
        if (blockEntityAbove instanceof BaseWarpBlockEntity && (warpBE = (BaseWarpBlockEntity)blockEntityAbove).getLevel() != null) {
            warpPos = warpBE.destinationPos;
            entityId = entity.getId();
            if (BaseWarpBlockEntity.WARPED_ENTITIES.getOrDefault(entityId, true).booleanValue()) {
                BaseWarpBlockEntity.WARPED_ENTITIES.put(entityId, false);
            }
            if (stateAboveEntity.getBlock() instanceof WarpPipeBlock) {
                this.enterWarpPipeAbove(entity, world, pos, warpPos, warpBE);
            }
        }
    }

    default public void enterWarpDoor(Entity entity, Level world, BlockPos pos, BlockPos warpPos, BaseWarpBlockEntity warpBE) {
        BlockState state = world.getBlockState(pos);
        if (!this.mv$doPreventWarp() && this.mv$getBlockWarpTeleportConfig() && !entity.getType().is(TagRegistry.CANNOT_WARP)) {
            if (!warpBE.preventWarp && this.mv$getWarpCooldown() == 0 && !entity.isShiftKeyDown()) {
                this.warp(entity, world, pos, state, warpPos, warpBE);
            } else if (warpBE.preventWarp && entity instanceof Player) {
                Player player = (Player)entity;
                this.displayWarpDisruptedMessage(player, state);
            }
        }
    }

    default public void enterWarpPipe(Entity entity, Level world, BlockPos pos, BlockPos warpPos, BaseWarpBlockEntity warpBE) {
        block47: {
            Player player;
            int blockZ;
            int blockY;
            int blockX;
            double entityZ;
            double entityY;
            double entityX;
            BlockState state;
            block54: {
                Player player2;
                LivingEntity livingEntity;
                block52: {
                    block53: {
                        block50: {
                            block51: {
                                block48: {
                                    block49: {
                                        state = world.getBlockState(pos);
                                        entityX = entity.getX();
                                        entityY = entity.getY();
                                        entityZ = entity.getZ();
                                        blockX = pos.getX();
                                        blockY = pos.getY();
                                        blockZ = pos.getZ();
                                        if (this.mv$doPreventWarp() || !this.mv$getBlockWarpTeleportConfig() || entity.getType().is(TagRegistry.CANNOT_WARP)) break block47;
                                        if (state.getValue((Property)WarpPipeBlock.FACING) == Direction.UP && BlockWarpEntityHandler.getShiftKeyForEntity(entity) && entityY + (double)entity.getBbHeight() >= (double)(blockY - 1) && entityX < (double)(blockX + 1) && entityX > (double)blockX && entityZ < (double)(blockZ + 1) && entityZ > (double)blockZ) {
                                            if (!warpBE.preventWarp && this.mv$getWarpCooldown() == 0) {
                                                this.warp(entity, world, pos, state, warpPos, warpBE);
                                            } else if (entity instanceof Player) {
                                                Player player3 = (Player)entity;
                                                if (warpBE.preventWarp) {
                                                    this.displayWarpDisruptedMessage(player3, state);
                                                } else if (warpBE.hasDestinationPos()) {
                                                    this.displayCooldownMessage(player3, state);
                                                }
                                            }
                                        }
                                        if (state.getValue((Property)WarpPipeBlock.FACING) != Direction.NORTH || entity.isShiftKeyDown()) break block48;
                                        if (entity.onGround() || entity.isInWaterOrBubble() || entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity).isFallFlying()) break block49;
                                        if (!(entity instanceof Player)) break block48;
                                        player2 = (Player)entity;
                                        if (!player2.getAbilities().flying) break block48;
                                    }
                                    if (entityX < (double)(blockX + 1) && entityX > (double)blockX && entityY >= (double)blockY && entityY < (double)blockY + 0.75 && entityZ < (double)blockZ) {
                                        if (!warpBE.preventWarp && this.mv$getWarpCooldown() == 0) {
                                            this.warp(entity, world, pos, state, warpPos, warpBE);
                                        } else if (entity instanceof Player) {
                                            player = (Player)entity;
                                            if (warpBE.preventWarp) {
                                                this.displayWarpDisruptedMessage(player, state);
                                            } else if (warpBE.hasDestinationPos()) {
                                                this.displayCooldownMessage(player, state);
                                            }
                                        }
                                    }
                                }
                                if (state.getValue((Property)WarpPipeBlock.FACING) != Direction.SOUTH || entity.isShiftKeyDown()) break block50;
                                if (entity.onGround() || entity.isInWaterOrBubble() || entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity).isFallFlying()) break block51;
                                if (!(entity instanceof Player)) break block50;
                                player2 = (Player)entity;
                                if (!player2.getAbilities().flying) break block50;
                            }
                            if (entityX < (double)(blockX + 1) && entityX > (double)blockX && entityY >= (double)blockY && entityY < (double)blockY + 0.75 && entityZ > (double)blockZ + 0.25) {
                                if (!warpBE.preventWarp && this.mv$getWarpCooldown() == 0) {
                                    this.warp(entity, world, pos, state, warpPos, warpBE);
                                } else if (entity instanceof Player) {
                                    player = (Player)entity;
                                    if (warpBE.preventWarp) {
                                        this.displayWarpDisruptedMessage(player, state);
                                    } else if (warpBE.hasDestinationPos()) {
                                        this.displayCooldownMessage(player, state);
                                    }
                                }
                            }
                        }
                        if (state.getValue((Property)WarpPipeBlock.FACING) != Direction.EAST || entity.isShiftKeyDown()) break block52;
                        if (entity.onGround() || entity.isInWaterOrBubble() || entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity).isFallFlying()) break block53;
                        if (!(entity instanceof Player)) break block52;
                        player2 = (Player)entity;
                        if (!player2.getAbilities().flying) break block52;
                    }
                    if (entityX > (double)blockX && entityY >= (double)blockY && entityY < (double)blockY + 0.75 && entityZ < (double)(blockZ + 1) && entityZ > (double)blockZ) {
                        if (!warpBE.preventWarp && this.mv$getWarpCooldown() == 0) {
                            this.warp(entity, world, pos, state, warpPos, warpBE);
                        } else if (entity instanceof Player) {
                            player = (Player)entity;
                            if (warpBE.preventWarp) {
                                this.displayWarpDisruptedMessage(player, state);
                            } else if (warpBE.hasDestinationPos()) {
                                this.displayCooldownMessage(player, state);
                            }
                        }
                    }
                }
                if (state.getValue((Property)WarpPipeBlock.FACING) != Direction.WEST || entity.isShiftKeyDown()) break block47;
                if (entity.onGround() || entity.isInWaterOrBubble() || entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity).isFallFlying()) break block54;
                if (!(entity instanceof Player)) break block47;
                player2 = (Player)entity;
                if (!player2.getAbilities().flying) break block47;
            }
            if (entityX < (double)blockX && entityY >= (double)blockY && entityY < (double)blockY + 0.75 && entityZ < (double)(blockZ + 1) && entityZ > (double)blockZ) {
                if (!warpBE.preventWarp && this.mv$getWarpCooldown() == 0) {
                    this.warp(entity, world, pos, state, warpPos, warpBE);
                } else if (entity instanceof Player) {
                    player = (Player)entity;
                    if (warpBE.preventWarp) {
                        this.displayWarpDisruptedMessage(player, state);
                    } else if (warpBE.hasDestinationPos()) {
                        this.displayCooldownMessage(player, state);
                    }
                }
            }
        }
    }

    default public void enterWarpPipeAbove(Entity entity, Level world, BlockPos pos, BlockPos warpPos, BaseWarpBlockEntity warpBE) {
        BlockState stateAboveEntity = world.getBlockState(pos.above(Math.round(entity.getBbHeight())));
        double entityX = entity.getX();
        double entityZ = entity.getZ();
        int blockX = pos.getX();
        int blockZ = pos.getZ();
        if (!this.mv$doPreventWarp() && this.mv$getBlockWarpTeleportConfig() && !entity.getType().is(TagRegistry.CANNOT_WARP) && stateAboveEntity.getValue((Property)WarpPipeBlock.FACING) == Direction.DOWN && entityX < (double)(blockX + 1) && entityX > (double)blockX && entityZ < (double)(blockZ + 1) && entityZ > (double)blockZ) {
            if (!warpBE.preventWarp && this.mv$getWarpCooldown() == 0) {
                this.warp(entity, world, pos, stateAboveEntity, warpPos, warpBE);
            } else if (entity instanceof Player) {
                Player player = (Player)entity;
                if (warpBE.preventWarp) {
                    this.displayWarpDisruptedMessage(player, stateAboveEntity);
                } else if (warpBE.hasDestinationPos()) {
                    this.displayCooldownMessage(player, stateAboveEntity);
                }
            }
        }
    }

    default public void warp(Entity entity, Level world, BlockPos pos, BlockState state, BlockPos warpPos, BaseWarpBlockEntity warpBE) {
        if (warpPos != null && !(world.getBlockEntity(warpPos) instanceof BaseWarpBlockEntity) && entity instanceof Player) {
            Player player = (Player)entity;
            this.displayDestinationMissingMessage(player);
        }
        if (warpPos != null && world.getBlockEntity(warpPos) instanceof BaseWarpBlockEntity) {
            warpState = world.getBlockState(warpPos);
            Block block = warpState.getBlock();
            if (block instanceof DoorBlock) {
                DoorBlock doorblock = (DoorBlock)block;
                WarpDoorBlockEntity.warp(entity, warpPos, world, warpState, doorblock, warpBE);
            }
            if ((block = warpState.getBlock()) instanceof TrapDoorBlock) {
                TrapDoorBlock trapdoorBlock = (TrapDoorBlock)block;
                WarpTrapDoorBlockEntity.warp(entity, warpPos, world, warpState, trapdoorBlock, warpBE);
            }
            if (warpState.getBlock() instanceof WarpPipeBlock) {
                WarpPipeBlockEntity.warp(entity, warpPos, world, warpState);
            }
            if (state.getBlock() instanceof WarpPipeBlock) {
                world.playSound(null, pos, (SoundEvent)SoundRegistry.PIPE_WARPS.get(), SoundSource.BLOCKS);
            }
            this.updateDoorState(world, pos, state, warpPos, warpState);
        } else if (warpBE.getUUID() != null && warpBE.getWarpUuid() != null && BaseWarpBlockEntity.findMatchingUUID(warpBE.getUUID()) != null) {
            warpPos = BaseWarpBlockEntity.findMatchingUUID(warpBE.getUUID());
            warpState = world.getBlockState(warpPos);
            Block block = warpState.getBlock();
            if (block instanceof DoorBlock) {
                DoorBlock doorblock = (DoorBlock)block;
                WarpDoorBlockEntity.warp(entity, warpPos, world, warpState, doorblock, warpBE);
            }
            if ((block = warpState.getBlock()) instanceof TrapDoorBlock) {
                TrapDoorBlock trapdoorBlock = (TrapDoorBlock)block;
                WarpTrapDoorBlockEntity.warp(entity, warpPos, world, warpState, trapdoorBlock, warpBE);
            }
            if (warpState.getBlock() instanceof WarpPipeBlock) {
                WarpPipeBlockEntity.warp(entity, warpPos, world, warpState);
            }
            if (state.getBlock() instanceof WarpPipeBlock) {
                world.playSound(null, pos, (SoundEvent)SoundRegistry.PIPE_WARPS.get(), SoundSource.BLOCKS);
            }
            this.updateDoorState(world, pos, state, warpPos, warpState);
            warpBE.setDestinationPos(warpPos);
            block = world.getBlockEntity(warpPos);
            if (block instanceof BaseWarpBlockEntity) {
                BaseWarpBlockEntity destBE = (BaseWarpBlockEntity)block;
                destBE.setDestinationPos(pos);
            }
        }
    }

    private void updateDoorState(Level world, BlockPos pos, BlockState state, BlockPos warpPos, BlockState warpState) {
        BaseWarpBlockEntity warpDoorBE;
        BlockEntity blockEntity = world.getBlockEntity(pos);
        BlockEntity warpBE = world.getBlockEntity(warpPos);
        if (!world.isClientSide) {
            if (warpBE instanceof WarpDoorBlockEntity) {
                warpDoorBE = (WarpDoorBlockEntity)warpBE;
                if (((WarpDoorBlockEntity)warpDoorBE).breakDoor) {
                    WarpDoorBlockEntity.breakDoor(warpPos, world);
                }
            }
            if (warpBE instanceof WarpTrapDoorBlockEntity) {
                WarpTrapDoorBlockEntity warpTrapdoorBE = (WarpTrapDoorBlockEntity)warpBE;
                if (warpTrapdoorBE.breakTrapdoor) {
                    WarpTrapDoorBlockEntity.breakTrapdoor(warpPos, world);
                }
            }
            if (state.getBlock() instanceof DoorBlock) {
                world.setBlock(pos, (BlockState)((BlockState)state.setValue((Property)DoorBlock.OPEN, (Comparable)Boolean.FALSE)).setValue((Property)DoorBlock.FACING, (Comparable)((Direction)state.getValue((Property)DoorBlock.FACING))), 10);
            }
            if (state.getBlock() instanceof TrapDoorBlock) {
                world.setBlock(pos, (BlockState)((BlockState)state.setValue((Property)TrapDoorBlock.OPEN, (Comparable)Boolean.FALSE)).setValue((Property)TrapDoorBlock.FACING, (Comparable)((Direction)state.getValue((Property)TrapDoorBlock.FACING))), 10);
            }
            if (warpBE instanceof WarpDoorBlockEntity) {
                warpDoorBE = (WarpDoorBlockEntity)warpBE;
                if (!((WarpDoorBlockEntity)warpDoorBE).breakDoor) {
                    world.setBlock(warpPos, (BlockState)((BlockState)warpState.setValue((Property)DoorBlock.OPEN, (Comparable)Boolean.TRUE)).setValue((Property)DoorBlock.FACING, (Comparable)((Direction)warpState.getValue((Property)DoorBlock.FACING))), 10);
                }
            }
            if (warpBE instanceof WarpTrapDoorBlockEntity) {
                warpDoorBE = (WarpTrapDoorBlockEntity)warpBE;
                if (!((WarpTrapDoorBlockEntity)warpDoorBE).breakTrapdoor) {
                    world.setBlock(warpPos, (BlockState)((BlockState)warpState.setValue((Property)TrapDoorBlock.OPEN, (Comparable)Boolean.TRUE)).setValue((Property)TrapDoorBlock.FACING, (Comparable)((Direction)warpState.getValue((Property)TrapDoorBlock.FACING))), 10);
                }
            }
        }
        if (blockEntity instanceof BaseWarpBlockEntity) {
            TrapDoorBlock trapdoorBlock;
            DoorBlock doorBlock;
            warpDoorBE = (BaseWarpBlockEntity)blockEntity;
            Block block = state.getBlock();
            if (block instanceof DoorBlock) {
                doorBlock = (DoorBlock)block;
                warpDoorBE.playDoorSounds(null, world, pos, (Boolean)state.getValue((Property)DoorBlock.OPEN), doorBlock.type());
            }
            if ((block = warpState.getBlock()) instanceof DoorBlock) {
                doorBlock = (DoorBlock)block;
                warpDoorBE.playDoorSounds(null, world, warpPos, (Boolean)warpState.getValue((Property)DoorBlock.OPEN), doorBlock.type());
            }
            if ((block = state.getBlock()) instanceof TrapDoorBlock) {
                trapdoorBlock = (TrapDoorBlock)block;
                warpDoorBE.playDoorSounds(null, world, pos, (Boolean)state.getValue((Property)TrapDoorBlock.OPEN), trapdoorBlock.getType());
            }
            if ((block = warpState.getBlock()) instanceof TrapDoorBlock) {
                trapdoorBlock = (TrapDoorBlock)block;
                warpDoorBE.playDoorSounds(null, world, warpPos, (Boolean)warpState.getValue((Property)TrapDoorBlock.OPEN), trapdoorBlock.getType());
            }
        }
    }

    default public void displayCooldownMessage(Player player, BlockState state) {
        if (this.mv$getWarpCooldown() >= 10) {
            if (state.getBlock() instanceof WarpPipeBlock) {
                if (((Boolean)ConfigRegistry.WARP_COOLDOWN_MESSAGE.get()).booleanValue()) {
                    if (((Boolean)ConfigRegistry.WARP_COOLDOWN_MESSAGE_TICKS.get()).booleanValue()) {
                        player.displayClientMessage((Component)Component.translatable((String)"display.marioverse.warp_pipe_cooldown.ticks", (Object[])new Object[]{this.mv$getWarpCooldown()}), true);
                    } else {
                        player.displayClientMessage((Component)Component.translatable((String)"display.marioverse.warp_pipe_cooldown"), true);
                    }
                }
            } else if (state.getBlock() instanceof DoorBlock) {
                if (((Boolean)ConfigRegistry.WARP_COOLDOWN_MESSAGE.get()).booleanValue()) {
                    if (((Boolean)ConfigRegistry.WARP_COOLDOWN_MESSAGE_TICKS.get()).booleanValue()) {
                        player.displayClientMessage((Component)Component.translatable((String)"display.marioverse.warp_door_cooldown.ticks", (Object[])new Object[]{this.mv$getWarpCooldown()}), true);
                    } else {
                        player.displayClientMessage((Component)Component.translatable((String)"display.marioverse.warp_door_cooldown"), true);
                    }
                }
            } else if (state.getBlock() instanceof TrapDoorBlock && ((Boolean)ConfigRegistry.WARP_COOLDOWN_MESSAGE.get()).booleanValue()) {
                if (((Boolean)ConfigRegistry.WARP_COOLDOWN_MESSAGE_TICKS.get()).booleanValue()) {
                    player.displayClientMessage((Component)Component.translatable((String)"display.marioverse.warp_trapdoor_cooldown.ticks", (Object[])new Object[]{this.mv$getWarpCooldown()}), true);
                } else {
                    player.displayClientMessage((Component)Component.translatable((String)"display.marioverse.warp_trapdoor_cooldown"), true);
                }
            }
        }
    }

    default public void displayWarpDisruptedMessage(Player player, BlockState state) {
        player.displayClientMessage((Component)Component.translatable((String)"display.marioverse.warp_disrupted", (Object[])new Object[]{state.getBlock().getName()}).withStyle(ChatFormatting.RED), true);
    }

    default public void displayDestinationMissingMessage(Player player) {
        player.displayClientMessage((Component)Component.translatable((String)"display.marioverse.warp_destination_missing"), true);
    }
}

