/*
 * Decompiled with CFR 0.152.
 */
package cyb0124.curvy_pipes.common;

import cyb0124.curvy_pipes.Mod;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;

public class NetHandler {
    private static final CustomPacketPayload.Type<Msg> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"curvy_pipes", (String)"0"));

    private static native String handleC2S(ServerPlayer var0, byte[] var1);

    private static native String handleS2C(byte[] var0);

    public static void onRegister(RegisterPayloadHandlersEvent evt) {
        evt.registrar("0").playBidirectional(TYPE, (StreamCodec)new StreamCodec<FriendlyByteBuf, Msg>(){

            public Msg decode(FriendlyByteBuf buf) {
                return new Msg(buf.readByteArray());
            }

            public void encode(FriendlyByteBuf buf, Msg msg) {
                buf.writeByteArray(msg.data);
            }
        }, (msg, ctx) -> {
            if (ctx.flow().isClientbound()) {
                String error = NetHandler.handleS2C(msg.data);
                if (error != null) {
                    Mod.LOGGER.warn("Failed to handle packet from server: {}", (Object)error);
                }
            } else {
                ServerPlayer player = (ServerPlayer)ctx.player();
                String error = NetHandler.handleC2S(player, msg.data);
                if (error != null) {
                    Mod.LOGGER.warn("Failed to handle packet from {}: {}", (Object)player.getGameProfile().getName(), (Object)error);
                }
            }
        });
    }

    private static void sendToServer(byte[] msg) {
        PacketDistributor.sendToServer((CustomPacketPayload)new Msg(msg), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private static void sendToPlayer(ServerPlayer player, byte[] msg) {
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new Msg(msg), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private record Msg(byte[] data) implements CustomPacketPayload
    {
        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }
    }
}

