/*
 * Decompiled with CFR 0.152.
 */
package cyb0124.curvy_pipes.inv;

import cyb0124.curvy_pipes.common.CommonHandler;
import cyb0124.curvy_pipes.inv.Typical;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.wrappers.CauldronWrapper;

class FluidInv
extends Typical<IFluidHandler> {
    private FluidStack[] fluids;
    private long[] hashes;

    private FluidInv(IFluidHandler inner) {
        super(inner, !(inner instanceof CauldronWrapper));
    }

    private static FluidInv resolve(ServerLevel level, int cx, int cz, int x, int y, int z, byte dir) {
        if (level.getChunkSource().getChunkNow(cx, cz) == null) {
            return null;
        }
        IFluidHandler cap = (IFluidHandler)level.getCapability(Capabilities.FluidHandler.BLOCK, new BlockPos(x, y, z), (Object)Direction.from3DDataValue((int)dir));
        return cap == null ? null : new FluidInv(cap);
    }

    private void read() {
        int nTanks = ((IFluidHandler)this.inner).getTanks();
        this.fluids = new FluidStack[nTanks];
        this.hashes = new long[nTanks * 2];
        for (int i = 0; i != nTanks; ++i) {
            FluidStack stack = ((IFluidHandler)this.inner).getFluidInTank(i);
            if (stack.getAmount() <= 0) continue;
            this.fluids[i] = stack.copy();
            this.hashes[i * 2] = CommonHandler.fluidAndPatchPreHash(stack);
            this.hashes[i * 2 + 1] = stack.getAmount();
        }
    }

    private int fill(FluidStack fluid, int qty, boolean sim) {
        return ((IFluidHandler)this.inner).fill(CommonHandler.copyFluidWithQty(fluid, qty), sim ? IFluidHandler.FluidAction.SIMULATE : IFluidHandler.FluidAction.EXECUTE);
    }

    private int drain(FluidStack fluid, int qty, boolean sim) {
        return ((IFluidHandler)this.inner).drain(CommonHandler.copyFluidWithQty(fluid, qty), sim ? IFluidHandler.FluidAction.SIMULATE : IFluidHandler.FluidAction.EXECUTE).getAmount();
    }

    private FluidStack drain() {
        FluidStack out = ((IFluidHandler)this.inner).drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE);
        return out.getAmount() > 0 ? out.copy() : null;
    }
}

