/*
 * Decompiled with CFR 0.152.
 */
package cyb0124.curvy_pipes.inv;

import cyb0124.curvy_pipes.common.CommonHandler;
import cyb0124.curvy_pipes.inv.Typical;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CauldronBlock;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

abstract class FluidInv<T>
extends Typical<T> {
    protected FluidStack[] fluids;
    protected long[] hashes;

    protected FluidInv(T inner, boolean split) {
        super(inner, split);
    }

    private static FluidInv<?> resolve(ServerWorld level, int cx, int cz, int x, int y, int z, byte dir) {
        Chunk chunk = level.func_72863_F().func_225313_a(cx, cz);
        if (chunk == null) {
            return null;
        }
        BlockPos pos = new BlockPos(x, y, z);
        TileEntity tile = chunk.func_175625_s(pos);
        if (tile != null) {
            return tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, Direction.func_82600_a((int)dir)).map(x$0 -> new Cap((IFluidHandler)x$0)).orElse(null);
        }
        if (chunk.func_180495_p(pos).func_203425_a(Blocks.field_150383_bp)) {
            return new Cauldron(chunk, pos);
        }
        return null;
    }

    protected abstract void read();

    protected abstract int fill(FluidStack var1, int var2, boolean var3);

    protected abstract int drain(FluidStack var1, int var2, boolean var3);

    protected abstract FluidStack drain();

    private static class Cauldron
    extends FluidInv<Void> {
        private final Chunk chunk;
        private final BlockPos pos;

        private Cauldron(Chunk chunk, BlockPos pos) {
            super(null, false);
            this.chunk = chunk;
            this.pos = pos;
        }

        private Fluid readPriv() {
            BlockState state = this.chunk.func_180495_p(this.pos);
            if (!state.func_203425_a(Blocks.field_150383_bp)) {
                return null;
            }
            if ((Integer)state.func_177229_b((Property)CauldronBlock.field_176591_a) < 3) {
                return null;
            }
            return Fluids.field_204546_a;
        }

        @Override
        protected void read() {
            Fluid fluid = this.readPriv();
            if (fluid == null) {
                return;
            }
            this.fluids = new FluidStack[]{new FluidStack(fluid, 1)};
            this.hashes = new long[]{fluid.hashCode(), 1000L};
        }

        @Override
        protected int fill(FluidStack fluid, int qty, boolean sim) {
            if (qty < 1000 || fluid.getFluid() != Fluids.field_204546_a) {
                return 0;
            }
            BlockState state = this.chunk.func_180495_p(this.pos);
            if (!state.func_203425_a(Blocks.field_150383_bp) || (Integer)state.func_177229_b((Property)CauldronBlock.field_176591_a) > 0) {
                return 0;
            }
            if (!sim) {
                this.chunk.func_177412_p().func_180501_a(this.pos, (BlockState)state.func_206870_a((Property)CauldronBlock.field_176591_a, (Comparable)Integer.valueOf(3)), 3);
            }
            return 1000;
        }

        @Override
        protected int drain(FluidStack fluid, int qty, boolean sim) {
            if (qty < 1000 || fluid.getFluid() != Fluids.field_204546_a) {
                return 0;
            }
            BlockState state = this.chunk.func_180495_p(this.pos);
            if (!state.func_203425_a(Blocks.field_150383_bp) || (Integer)state.func_177229_b((Property)CauldronBlock.field_176591_a) < 3) {
                return 0;
            }
            if (!sim) {
                this.chunk.func_177412_p().func_180501_a(this.pos, (BlockState)state.func_206870_a((Property)CauldronBlock.field_176591_a, (Comparable)Integer.valueOf(0)), 3);
            }
            return 1000;
        }

        @Override
        protected FluidStack drain() {
            Fluid fluid = this.readPriv();
            return fluid == null ? null : new FluidStack(fluid, 1000);
        }
    }

    private static class Cap
    extends FluidInv<IFluidHandler> {
        private Cap(IFluidHandler inner) {
            super(inner, true);
        }

        @Override
        protected void read() {
            int nTanks = ((IFluidHandler)this.inner).getTanks();
            this.fluids = new FluidStack[nTanks];
            this.hashes = new long[nTanks * 2];
            for (int i = 0; i != nTanks; ++i) {
                FluidStack stack = ((IFluidHandler)this.inner).getFluidInTank(i);
                if (stack.getAmount() <= 0) continue;
                this.fluids[i] = stack.copy();
                this.hashes[i * 2] = CommonHandler.fluidAndTagPreHash(stack);
                this.hashes[i * 2 + 1] = stack.getAmount();
            }
        }

        @Override
        protected int fill(FluidStack fluid, int qty, boolean sim) {
            return ((IFluidHandler)this.inner).fill(CommonHandler.copyFluidWithQty(fluid, qty), sim ? IFluidHandler.FluidAction.SIMULATE : IFluidHandler.FluidAction.EXECUTE);
        }

        @Override
        protected int drain(FluidStack fluid, int qty, boolean sim) {
            return ((IFluidHandler)this.inner).drain(CommonHandler.copyFluidWithQty(fluid, qty), sim ? IFluidHandler.FluidAction.SIMULATE : IFluidHandler.FluidAction.EXECUTE).getAmount();
        }

        @Override
        protected FluidStack drain() {
            FluidStack out = ((IFluidHandler)this.inner).drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE);
            return out.getAmount() > 0 ? out.copy() : null;
        }
    }
}

