/*
 * Decompiled with CFR 0.152.
 */
package cyb0124.curvy_pipes.inv;

import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGroup;
import cyb0124.curvy_pipes.common.CommonHandler;
import cyb0124.curvy_pipes.inv.Typical;
import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ISidedInventoryProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

abstract class ItemInv<T>
extends Typical<T> {
    private static boolean TRY_STORAGE_DRAWERS = true;
    protected ItemStack[] items;
    protected int[] slots;
    protected int[] hashes;

    protected ItemInv(T inner, boolean split) {
        super(inner, split);
    }

    private static ItemInv<?> resolve(ServerWorld level, int cx, int cz, int x, int y, int z, byte dir) {
        Chunk chunk = level.func_72863_F().func_225313_a(cx, cz);
        if (chunk == null) {
            return null;
        }
        BlockPos pos = new BlockPos(x, y, z);
        TileEntity tile = chunk.func_175625_s(pos);
        if (tile == null) {
            BlockState state = chunk.func_180495_p(pos);
            Block block = state.func_177230_c();
            if (block instanceof ISidedInventoryProvider) {
                return new Container(((ISidedInventoryProvider)block).func_219966_a(state, (IWorld)level, pos), Direction.func_82600_a((int)dir));
            }
            return null;
        }
        if (TRY_STORAGE_DRAWERS) {
            try {
                if (tile instanceof IDrawerGroup) {
                    return new StorageDrawers((IDrawerGroup)tile);
                }
            }
            catch (NoClassDefFoundError ignored) {
                TRY_STORAGE_DRAWERS = false;
            }
        }
        return tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.func_82600_a((int)dir)).map(x$0 -> new Cap((IItemHandler)x$0)).orElse(null);
    }

    protected void read() {
        int nSlots = this.nSlots();
        this.slots = new int[nSlots * 2];
        Object2IntLinkedOpenHashMap itemMap = new Object2IntLinkedOpenHashMap();
        for (int i = 0; i != nSlots; ++i) {
            ItemStack stack = this.get(i);
            if (stack == null) continue;
            HashedStack hashed = new HashedStack(stack, CommonHandler.itemId(stack), CommonHandler.itemTagHash(stack));
            int oldSize = itemMap.size();
            this.slots[i * 2] = (Integer)itemMap.computeIfAbsent((Object)hashed, ignored -> oldSize);
            this.slots[i * 2 + 1] = stack.func_190916_E();
        }
        int size = itemMap.size();
        this.items = new ItemStack[size];
        this.hashes = new int[size * 2];
        int i = 0;
        for (HashedStack hashed : itemMap.keySet()) {
            this.items[i] = CommonHandler.copyItemWithQty(hashed.stack, 1);
            this.hashes[i * 2] = hashed.id;
            this.hashes[i * 2 + 1] = hashed.tagHash;
            ++i;
        }
    }

    protected abstract int nSlots();

    protected abstract ItemStack get(int var1);

    protected abstract int simExtract(int var1, ItemStack var2, int var3);

    protected abstract void execExtract(int var1, int var2);

    protected abstract int insert(int var1, ItemStack var2, int var3, boolean var4);

    private static class Container
    extends ItemInv<Void> {
        private final ISidedInventory inner;
        private final Direction dir;
        private final int[] slotMap;

        private Container(ISidedInventory inner, Direction dir) {
            super(null, true);
            this.inner = inner;
            this.dir = dir;
            this.slotMap = inner.func_180463_a(dir);
        }

        @Override
        protected int nSlots() {
            return this.slotMap.length;
        }

        @Override
        protected ItemStack get(int slot) {
            ItemStack out = this.inner.func_70301_a(this.slotMap[slot]);
            return out.func_190926_b() ? null : out;
        }

        @Override
        protected int simExtract(int slot, ItemStack item, int qty) {
            ItemStack out = this.inner.func_70301_a(slot = this.slotMap[slot]);
            return CommonHandler.isSameItemAndTag(out, item) && this.inner.func_180461_b(slot, item, this.dir) ? out.func_190916_E() : 0;
        }

        @Override
        protected void execExtract(int slot, int qty) {
            this.inner.func_70298_a(this.slotMap[slot], qty);
        }

        @Override
        protected int insert(int slot, ItemStack item, int qty, boolean sim) {
            if (!this.inner.func_180462_a(slot = this.slotMap[slot], item, this.dir)) {
                return qty;
            }
            ItemStack dst = this.inner.func_70301_a(slot);
            if (!dst.func_190926_b() && !CommonHandler.isSameItemAndTag(item, dst)) {
                return qty;
            }
            int base = dst.func_190916_E();
            int used = Math.min(qty, Math.min(item.func_77976_d(), this.inner.func_70297_j_()) - base);
            if (used <= 0) {
                return qty;
            }
            if (!sim) {
                this.inner.func_70299_a(slot, CommonHandler.copyItemWithQty(item, base + used));
            }
            return qty - used;
        }
    }

    private static class StorageDrawers
    extends ItemInv<IDrawerGroup> {
        private int[] slotMap;

        protected StorageDrawers(IDrawerGroup inner) {
            super(inner, false);
        }

        @Override
        protected void read() {
            this.slotMap = ((IDrawerGroup)this.inner).getAccessibleDrawerSlots();
            super.read();
        }

        @Override
        protected int nSlots() {
            return this.slotMap.length;
        }

        @Override
        protected ItemStack get(int slot) {
            IDrawer drawer = ((IDrawerGroup)this.inner).getDrawer(this.slotMap[slot]);
            int qty = drawer.getStoredItemCount();
            return qty > 0 ? CommonHandler.copyItemWithQty(drawer.getStoredItemPrototype(), qty) : null;
        }

        @Override
        protected int simExtract(int slot, ItemStack item, int qty) {
            IDrawer drawer = ((IDrawerGroup)this.inner).getDrawer(this.slotMap[slot]);
            return drawer.canItemBeExtracted(item) ? drawer.getStoredItemCount() : 0;
        }

        @Override
        protected void execExtract(int slot, int qty) {
            ((IDrawerGroup)this.inner).getDrawer(this.slotMap[slot]).adjustStoredItemCount(-qty);
        }

        @Override
        protected int insert(int slot, ItemStack item, int qty, boolean sim) {
            IDrawer drawer = ((IDrawerGroup)this.inner).getDrawer(this.slotMap[slot]);
            if (!drawer.canItemBeStored(item)) {
                return qty;
            }
            boolean empty = drawer.isEmpty();
            if (sim) {
                return qty - (empty ? drawer.getAcceptingMaxCapacity(item) : drawer.getAcceptingRemainingCapacity());
            }
            if (empty) {
                drawer = drawer.setStoredItem(item);
            }
            return drawer.adjustStoredItemCount(qty);
        }
    }

    private static class Cap
    extends ItemInv<IItemHandler> {
        private Cap(IItemHandler inner) {
            super(inner, true);
        }

        @Override
        protected int nSlots() {
            return ((IItemHandler)this.inner).getSlots();
        }

        @Override
        protected ItemStack get(int slot) {
            ItemStack out = ((IItemHandler)this.inner).getStackInSlot(slot);
            return out.func_190926_b() ? null : out;
        }

        @Override
        protected int simExtract(int slot, ItemStack item, int qty) {
            ItemStack out = ((IItemHandler)this.inner).extractItem(slot, qty, true);
            return CommonHandler.isSameItemAndTag(item, out) ? out.func_190916_E() : 0;
        }

        @Override
        protected void execExtract(int slot, int qty) {
            ((IItemHandler)this.inner).extractItem(slot, qty, false);
        }

        @Override
        protected int insert(int slot, ItemStack item, int qty, boolean sim) {
            return ((IItemHandler)this.inner).insertItem(slot, CommonHandler.copyItemWithQty(item, qty), sim).func_190916_E();
        }
    }

    private static class HashedStack {
        private final ItemStack stack;
        private final int id;
        private final int tagHash;

        private HashedStack(ItemStack stack, int id, int tagHash) {
            this.stack = stack;
            this.id = id;
            this.tagHash = tagHash;
        }

        public int hashCode() {
            return 31 * (31 + this.id) + this.tagHash;
        }

        public boolean equals(Object o) {
            return CommonHandler.isSameItemAndTag(this.stack, ((HashedStack)o).stack);
        }
    }
}

