/*
 * Decompiled with CFR 0.152.
 */
package cyb0124.curvy_pipes.inv;

import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGroup;
import cyb0124.curvy_pipes.common.CommonHandler;
import cyb0124.curvy_pipes.inv.Typical;
import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

abstract class ItemInv<T>
extends Typical<T> {
    private static boolean TRY_STORAGE_DRAWERS = true;
    protected ItemStack[] items;
    protected int[] slots;
    protected int[] hashes;

    protected ItemInv(T inner, boolean split) {
        super(inner, split);
    }

    private static ItemInv<?> resolve(WorldServer level, int cx, int cz, int x, int y, int z, byte dir) {
        IItemHandler cap;
        Chunk chunk = level.func_72863_F().func_186026_b(cx, cz);
        if (chunk == null) {
            return null;
        }
        TileEntity tile = chunk.func_177424_a(new BlockPos(x, y, z), Chunk.EnumCreateEntityType.CHECK);
        if (tile == null) {
            return null;
        }
        if (TRY_STORAGE_DRAWERS) {
            try {
                if (tile instanceof IDrawerGroup) {
                    return new StorageDrawers((IDrawerGroup)tile);
                }
            }
            catch (NoClassDefFoundError ignored) {
                TRY_STORAGE_DRAWERS = false;
            }
        }
        return (cap = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.func_82600_a((int)dir))) == null ? null : new Cap(cap);
    }

    protected void read() {
        int nSlots = this.nSlots();
        this.slots = new int[nSlots * 2];
        Object2IntLinkedOpenHashMap itemMap = new Object2IntLinkedOpenHashMap();
        for (int i = 0; i != nSlots; ++i) {
            ItemStack stack = this.get(i);
            if (stack == null) continue;
            HashedStack hashed = new HashedStack(stack, CommonHandler.itemId(stack), CommonHandler.itemMeta(stack), CommonHandler.itemTagHash(stack));
            int oldSize = itemMap.size();
            this.slots[i * 2] = (Integer)itemMap.computeIfAbsent((Object)hashed, ignored -> oldSize);
            this.slots[i * 2 + 1] = stack.func_190916_E();
        }
        int size = itemMap.size();
        this.items = new ItemStack[size];
        this.hashes = new int[size * 3];
        int i = 0;
        for (HashedStack hashed : itemMap.keySet()) {
            this.items[i] = CommonHandler.copyItemWithQty(hashed.stack, 1);
            this.hashes[i * 3] = hashed.id;
            this.hashes[i * 3 + 1] = hashed.meta;
            this.hashes[i * 3 + 2] = hashed.tagHash;
            ++i;
        }
    }

    protected abstract int nSlots();

    protected abstract ItemStack get(int var1);

    protected abstract int simExtract(int var1, ItemStack var2, int var3);

    protected abstract void execExtract(int var1, int var2);

    protected abstract int insert(int var1, ItemStack var2, int var3, boolean var4);

    private static class StorageDrawers
    extends ItemInv<IDrawerGroup> {
        private int[] slotMap;

        protected StorageDrawers(IDrawerGroup inner) {
            super(inner, false);
        }

        @Override
        protected void read() {
            this.slotMap = ((IDrawerGroup)this.inner).getAccessibleDrawerSlots();
            super.read();
        }

        @Override
        protected int nSlots() {
            return this.slotMap.length;
        }

        @Override
        protected ItemStack get(int slot) {
            IDrawer drawer = ((IDrawerGroup)this.inner).getDrawer(this.slotMap[slot]);
            int qty = drawer.getStoredItemCount();
            return qty > 0 ? CommonHandler.copyItemWithQty(drawer.getStoredItemPrototype(), qty) : null;
        }

        @Override
        protected int simExtract(int slot, ItemStack item, int qty) {
            IDrawer drawer = ((IDrawerGroup)this.inner).getDrawer(this.slotMap[slot]);
            return drawer.canItemBeExtracted(item) ? drawer.getStoredItemCount() : 0;
        }

        @Override
        protected void execExtract(int slot, int qty) {
            ((IDrawerGroup)this.inner).getDrawer(this.slotMap[slot]).adjustStoredItemCount(-qty);
        }

        @Override
        protected int insert(int slot, ItemStack item, int qty, boolean sim) {
            IDrawer drawer = ((IDrawerGroup)this.inner).getDrawer(this.slotMap[slot]);
            if (!drawer.canItemBeStored(item)) {
                return qty;
            }
            boolean empty = drawer.isEmpty();
            if (sim) {
                return qty - (empty ? drawer.getAcceptingMaxCapacity(item) : drawer.getAcceptingRemainingCapacity());
            }
            if (empty) {
                drawer = drawer.setStoredItem(item);
            }
            return drawer.adjustStoredItemCount(qty);
        }
    }

    private static class Cap
    extends ItemInv<IItemHandler> {
        private Cap(IItemHandler inner) {
            super(inner, true);
        }

        @Override
        protected int nSlots() {
            return ((IItemHandler)this.inner).getSlots();
        }

        @Override
        protected ItemStack get(int slot) {
            ItemStack out = ((IItemHandler)this.inner).getStackInSlot(slot);
            return out.func_190926_b() ? null : out;
        }

        @Override
        protected int simExtract(int slot, ItemStack item, int qty) {
            ItemStack out = ((IItemHandler)this.inner).extractItem(slot, qty, true);
            return CommonHandler.isSameItemAndTag(item, out) ? out.func_190916_E() : 0;
        }

        @Override
        protected void execExtract(int slot, int qty) {
            ((IItemHandler)this.inner).extractItem(slot, qty, false);
        }

        @Override
        protected int insert(int slot, ItemStack item, int qty, boolean sim) {
            return ((IItemHandler)this.inner).insertItem(slot, CommonHandler.copyItemWithQty(item, qty), sim).func_190916_E();
        }
    }

    private static class HashedStack {
        private final ItemStack stack;
        private final int id;
        private final int meta;
        private final int tagHash;

        private HashedStack(ItemStack stack, int id, int meta, int tagHash) {
            this.stack = stack;
            this.id = id;
            this.meta = meta;
            this.tagHash = tagHash;
        }

        public int hashCode() {
            return 31 * (31 * (31 + this.id) + this.meta) + this.tagHash;
        }

        public boolean equals(Object o) {
            return CommonHandler.isSameItemAndTag(this.stack, ((HashedStack)o).stack);
        }
    }
}

