/*
 * Decompiled with CFR 0.152.
 */
package cyb0124.curvy_pipes.inv;

import cyb0124.curvy_pipes.common.CommonHandler;
import net.minecraft.init.Blocks;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public abstract class FluidInv {
    protected FluidStack[] fluids;
    protected long[] hashes;

    protected abstract void read(byte var1);

    protected abstract int fill(byte var1, FluidStack var2, int var3, boolean var4);

    protected abstract int drain(byte var1, FluidStack var2, int var3, boolean var4);

    protected abstract FluidStack drain(byte var1);

    public static class Cauldron
    extends FluidInv {
        private final Chunk chunk;
        private final int x;
        private final int y;
        private final int z;

        public Cauldron(Chunk chunk, int x, int y, int z) {
            this.chunk = chunk;
            this.x = x;
            this.y = y;
            this.z = z;
        }

        private Fluid readPriv() {
            if (this.chunk.func_150810_a(this.x & 0xF, this.y, this.z & 0xF) != Blocks.field_150383_bp) {
                return null;
            }
            if (this.chunk.func_76628_c(this.x & 0xF, this.y, this.z & 0xF) < 3) {
                return null;
            }
            return FluidRegistry.WATER;
        }

        @Override
        protected void read(byte dir) {
            Fluid fluid = this.readPriv();
            if (fluid == null) {
                return;
            }
            this.fluids = new FluidStack[]{new FluidStack(fluid, 1)};
            this.hashes = new long[]{fluid.hashCode(), 1000L};
        }

        @Override
        protected int fill(byte dir, FluidStack fluid, int qty, boolean exec) {
            if (qty < 1000 || fluid.getFluid() != FluidRegistry.WATER) {
                return 0;
            }
            if (this.chunk.func_150810_a(this.x & 0xF, this.y, this.z & 0xF) != Blocks.field_150383_bp) {
                return 0;
            }
            if (this.chunk.func_76628_c(this.x & 0xF, this.y, this.z & 0xF) > 0) {
                return 0;
            }
            if (exec) {
                Blocks.field_150383_bp.func_150024_a(this.chunk.field_76637_e, this.x, this.y, this.z, 3);
            }
            return 1000;
        }

        @Override
        protected int drain(byte dir, FluidStack fluid, int qty, boolean exec) {
            if (qty < 1000 || fluid.getFluid() != FluidRegistry.WATER) {
                return 0;
            }
            if (this.chunk.func_150810_a(this.x & 0xF, this.y, this.z & 0xF) != Blocks.field_150383_bp) {
                return 0;
            }
            if (this.chunk.func_76628_c(this.x & 0xF, this.y, this.z & 0xF) < 3) {
                return 0;
            }
            if (exec) {
                Blocks.field_150383_bp.func_150024_a(this.chunk.field_76637_e, this.x, this.y, this.z, 0);
            }
            return 1000;
        }

        @Override
        protected FluidStack drain(byte dir) {
            Fluid fluid = this.readPriv();
            return fluid == null ? null : new FluidStack(fluid, 1000);
        }
    }

    private static class Tank
    extends FluidInv {
        private final IFluidHandler inner;

        private Tank(IFluidHandler inner) {
            this.inner = inner;
        }

        @Override
        protected void read(byte dir) {
            FluidTankInfo[] tanks = this.inner.getTankInfo(ForgeDirection.VALID_DIRECTIONS[dir]);
            int nTanks = tanks.length;
            this.fluids = new FluidStack[nTanks];
            this.hashes = new long[nTanks * 2];
            for (int i = 0; i != nTanks; ++i) {
                FluidStack stack = tanks[i].fluid;
                if (stack == null || stack.amount <= 0) continue;
                this.fluids[i] = stack.copy();
                this.hashes[i * 2] = CommonHandler.fluidAndTagPreHash(stack);
                this.hashes[i * 2 + 1] = stack.amount;
            }
        }

        @Override
        protected int fill(byte dir, FluidStack fluid, int qty, boolean exec) {
            return this.inner.fill(ForgeDirection.VALID_DIRECTIONS[dir], CommonHandler.copyFluidWithQty(fluid, qty), exec);
        }

        @Override
        protected int drain(byte dir, FluidStack fluid, int qty, boolean exec) {
            FluidStack out = this.inner.drain(ForgeDirection.VALID_DIRECTIONS[dir], CommonHandler.copyFluidWithQty(fluid, qty), exec);
            return out == null ? 0 : out.amount;
        }

        @Override
        protected FluidStack drain(byte dir) {
            FluidStack out = this.inner.drain(ForgeDirection.VALID_DIRECTIONS[dir], Integer.MAX_VALUE, false);
            return out != null && out.amount > 0 ? out.copy() : null;
        }
    }
}

