/*
 * Decompiled with CFR 0.152.
 */
package cyb0124.curvy_pipes.inv;

import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGroup;
import cyb0124.curvy_pipes.common.CommonHandler;
import java.util.LinkedHashMap;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.InventoryLargeChest;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityChest;

abstract class ItemInv {
    protected ItemStack[] items;
    protected int[] slots;
    protected int[] hashes;

    ItemInv() {
    }

    private static Unsided tryCombineChests(TileEntityChest x, TileEntityChest y) {
        return x.func_145980_j() == y.func_145980_j() ? new Unsided((IInventory)new InventoryLargeChest("", (IInventory)x, (IInventory)y)) : null;
    }

    protected void read() {
        int nSlots = this.nSlots();
        this.slots = new int[nSlots * 2];
        LinkedHashMap<HashedStack, Integer> itemMap = new LinkedHashMap<HashedStack, Integer>();
        for (int i = 0; i != nSlots; ++i) {
            ItemStack stack = this.get(i);
            if (stack == null) continue;
            HashedStack hashed = new HashedStack(stack, CommonHandler.itemId(stack), CommonHandler.itemMeta(stack), CommonHandler.itemTagHash(stack));
            int oldSize = itemMap.size();
            this.slots[i * 2] = itemMap.computeIfAbsent(hashed, ignored -> oldSize);
            this.slots[i * 2 + 1] = stack.field_77994_a;
        }
        int size = itemMap.size();
        this.items = new ItemStack[size];
        this.hashes = new int[size * 3];
        int i = 0;
        for (HashedStack hashed : itemMap.keySet()) {
            this.items[i] = CommonHandler.copyItemWithQty(hashed.stack, 1);
            this.hashes[i * 3] = hashed.id;
            this.hashes[i * 3 + 1] = hashed.meta;
            this.hashes[i * 3 + 2] = hashed.tagHash;
            ++i;
        }
    }

    protected abstract int nSlots();

    protected abstract ItemStack get(int var1);

    protected abstract int simExtract(int var1, ItemStack var2, int var3);

    protected abstract void execExtract(int var1, int var2);

    protected abstract int insert(int var1, ItemStack var2, int var3, boolean var4);

    private static class StorageDrawers
    extends ItemInv {
        private final IDrawerGroup inner;

        protected StorageDrawers(IDrawerGroup inner) {
            this.inner = inner;
            this.read();
        }

        @Override
        protected int nSlots() {
            return this.inner.getDrawerCount();
        }

        @Override
        protected ItemStack get(int slot) {
            IDrawer drawer = this.inner.getDrawer(slot);
            int qty = drawer.getStoredItemCount();
            return qty > 0 ? CommonHandler.copyItemWithQty(drawer.getStoredItemPrototype(), qty) : null;
        }

        @Override
        protected int simExtract(int slot, ItemStack item, int qty) {
            IDrawer drawer = this.inner.getDrawer(slot);
            return drawer.canItemBeExtracted(item) ? drawer.getStoredItemCount() : 0;
        }

        @Override
        protected void execExtract(int slot, int qty) {
            IDrawer drawer = this.inner.getDrawer(slot);
            drawer.setStoredItemCount(drawer.getStoredItemCount() - qty);
        }

        @Override
        protected int insert(int slot, ItemStack item, int qty, boolean sim) {
            IDrawer drawer = this.inner.getDrawer(slot);
            if (!drawer.canItemBeStored(item)) {
                return qty;
            }
            boolean empty = drawer.isEmpty();
            int used = Math.min(qty, empty ? drawer.getMaxCapacity(item) : drawer.getRemainingCapacity());
            if (used <= 0) {
                return qty;
            }
            if (!sim) {
                if (empty) {
                    drawer.setStoredItemRedir(item, used);
                } else {
                    drawer.setStoredItemCount(drawer.getStoredItemCount() + used);
                }
            }
            return qty - used;
        }
    }

    private static class Sided
    extends ItemInv {
        private final ISidedInventory inner;
        private final byte dir;
        private final int[] slotMap;

        private Sided(ISidedInventory inner, byte dir) {
            this.inner = inner;
            this.dir = dir;
            this.slotMap = inner.func_94128_d((int)dir);
            this.read();
        }

        @Override
        protected int nSlots() {
            return this.slotMap.length;
        }

        @Override
        protected ItemStack get(int slot) {
            ItemStack out = this.inner.func_70301_a(this.slotMap[slot]);
            return out == null || out.field_77994_a <= 0 ? null : out;
        }

        @Override
        protected int simExtract(int slot, ItemStack item, int qty) {
            if (!this.inner.func_102008_b(slot = this.slotMap[slot], item, (int)this.dir)) {
                return 0;
            }
            ItemStack out = this.inner.func_70301_a(slot);
            return out != null && CommonHandler.isSameItemAndTag(out, item) ? out.field_77994_a : 0;
        }

        @Override
        protected void execExtract(int slot, int qty) {
            this.inner.func_70298_a(this.slotMap[slot], qty);
        }

        @Override
        protected int insert(int slot, ItemStack item, int qty, boolean sim) {
            int used;
            if (!this.inner.func_102007_a(slot = this.slotMap[slot], item, (int)this.dir)) {
                return qty;
            }
            ItemStack dst = this.inner.func_70301_a(slot);
            int base = 0;
            if (dst != null) {
                if (!CommonHandler.isSameItemAndTag(item, dst)) {
                    return qty;
                }
                base = dst.field_77994_a;
            }
            if ((used = Math.min(qty, Math.min(item.func_77976_d(), this.inner.func_70297_j_()) - base)) <= 0) {
                return qty;
            }
            if (!sim) {
                this.inner.func_70299_a(slot, CommonHandler.copyItemWithQty(item, base + used));
            }
            return qty - used;
        }
    }

    private static class Unsided
    extends ItemInv {
        private final IInventory inner;

        private Unsided(IInventory inner) {
            this.inner = inner;
            this.read();
        }

        @Override
        protected int nSlots() {
            return this.inner.func_70302_i_();
        }

        @Override
        protected ItemStack get(int slot) {
            ItemStack out = this.inner.func_70301_a(slot);
            return out == null || out.field_77994_a <= 0 ? null : out;
        }

        @Override
        protected int simExtract(int slot, ItemStack item, int qty) {
            ItemStack out = this.inner.func_70301_a(slot);
            return out != null && CommonHandler.isSameItemAndTag(out, item) ? out.field_77994_a : 0;
        }

        @Override
        protected void execExtract(int slot, int qty) {
            this.inner.func_70298_a(slot, qty);
        }

        @Override
        protected int insert(int slot, ItemStack item, int qty, boolean sim) {
            int used;
            if (!this.inner.func_94041_b(slot, item)) {
                return qty;
            }
            ItemStack dst = this.inner.func_70301_a(slot);
            int base = 0;
            if (dst != null) {
                if (!CommonHandler.isSameItemAndTag(item, dst)) {
                    return qty;
                }
                base = dst.field_77994_a;
            }
            if ((used = Math.min(qty, Math.min(item.func_77976_d(), this.inner.func_70297_j_()) - base)) <= 0) {
                return qty;
            }
            if (!sim) {
                this.inner.func_70299_a(slot, CommonHandler.copyItemWithQty(item, base + used));
            }
            return qty - used;
        }
    }

    private static class HashedStack {
        private final ItemStack stack;
        private final int id;
        private final int meta;
        private final int tagHash;

        private HashedStack(ItemStack stack, int id, int meta, int tagHash) {
            this.stack = stack;
            this.id = id;
            this.meta = meta;
            this.tagHash = tagHash;
        }

        public int hashCode() {
            return 31 * (31 * (31 + this.id) + this.meta) + this.tagHash;
        }

        public boolean equals(Object o) {
            return CommonHandler.isSameItemAndTag(this.stack, ((HashedStack)o).stack);
        }
    }
}

