/*
 * Decompiled with CFR 0.152.
 */
package com.example.meteors;

import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class CustomMeteorEntity
extends FallingBlockEntity {
    private BlockState meteorBlockState = Blocks.OBSIDIAN.defaultBlockState();

    public CustomMeteorEntity(EntityType<? extends FallingBlockEntity> type, Level level) {
        super(type, level);
    }

    public CustomMeteorEntity(EntityType<? extends CustomMeteorEntity> type, Level level, BlockState state) {
        super(type, level);
        this.setMeteorBlockState(state);
    }

    public void setMeteorBlockState(BlockState state) {
        this.meteorBlockState = state;
    }

    public BlockState getBlockState() {
        return this.meteorBlockState;
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.put("BlockState", (Tag)NbtUtils.writeBlockState((BlockState)this.meteorBlockState));
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("BlockState", 10)) {
            this.meteorBlockState = NbtUtils.readBlockState((HolderGetter)this.level().holderLookup(Registries.BLOCK), (CompoundTag)compound.getCompound("BlockState"));
        }
    }

    public boolean isNoGravity() {
        return false;
    }

    public void tick() {
        if (this.meteorBlockState.isAir()) {
            this.discard();
            return;
        }
        this.baseTick();
        if (!this.isNoGravity()) {
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.04, 0.0));
        }
        this.move(MoverType.SELF, this.getDeltaMovement());
        if (!this.level().isClientSide) {
            if (this.onGround()) {
                this.setDeltaMovement(this.getDeltaMovement().multiply(0.7, -0.5, 0.7));
            } else {
                this.setDeltaMovement(this.getDeltaMovement().scale(0.98));
            }
        }
    }
}

