/*
 * Decompiled with CFR 0.152.
 */
package com.example.meteors;

import com.example.meteors.CustomMeteorEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.data.ModelData;

public class CustomMeteorEntityRenderer
extends EntityRenderer<CustomMeteorEntity> {
    private final BlockRenderDispatcher dispatcher;

    public CustomMeteorEntityRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.dispatcher = context.getBlockRenderDispatcher();
    }

    public void render(CustomMeteorEntity entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        Level level;
        BlockState blockState = entity.getBlockState();
        if (blockState.getRenderShape() == RenderShape.MODEL && blockState != (level = entity.level()).getBlockState(entity.blockPosition()) && blockState.getRenderShape() != RenderShape.INVISIBLE) {
            poseStack.pushPose();
            BlockPos blockpos = BlockPos.containing((double)entity.getX(), (double)entity.getBoundingBox().maxY, (double)entity.getZ());
            poseStack.translate(-0.5, 0.0, -0.5);
            float time = (float)entity.tickCount + partialTicks;
            poseStack.translate(0.5, 0.5, 0.5);
            poseStack.mulPose(Axis.YP.rotationDegrees(time * 10.0f + (float)(entity.getId() * 10)));
            poseStack.mulPose(Axis.XP.rotationDegrees(time * 7.0f + (float)(entity.getId() * 5)));
            poseStack.mulPose(Axis.ZP.rotationDegrees(time * 5.0f + (float)(entity.getId() * 3)));
            poseStack.translate(-0.5, -0.5, -0.5);
            this.dispatcher.renderSingleBlock(blockState, poseStack, buffer, packedLight, 10, ModelData.EMPTY, null);
            poseStack.popPose();
            super.render((Entity)entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
        }
    }

    public ResourceLocation getTextureLocation(CustomMeteorEntity entity) {
        return TextureAtlas.LOCATION_BLOCKS;
    }
}

