/*
 * Decompiled with CFR 0.152.
 */
package com.example.meteors;

import com.example.meteors.Meteors;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class GiantMeteorEntity
extends FallingBlockEntity {
    private BlockState meteorBlockState = Blocks.OBSIDIAN.defaultBlockState();

    public GiantMeteorEntity(EntityType<? extends FallingBlockEntity> type, Level level) {
        super(type, level);
    }

    public GiantMeteorEntity(EntityType<? extends GiantMeteorEntity> type, Level level, BlockState state) {
        super(type, level);
        this.setMeteorBlockState(state);
    }

    public GiantMeteorEntity(Level level, double x, double y, double z, BlockState state) {
        this(Meteors.GIANT_METEOR.get(), level);
        this.setPos(x, y, z);
        this.setMeteorBlockState(state);
        this.setStartPos(this.blockPosition());
        this.xo = x;
        this.yo = y;
        this.zo = z;
    }

    public void setMeteorBlockState(BlockState state) {
        this.meteorBlockState = state;
    }

    public BlockState getBlockState() {
        return this.meteorBlockState;
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.put("BlockState", (Tag)NbtUtils.writeBlockState((BlockState)this.meteorBlockState));
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("BlockState", 10)) {
            this.meteorBlockState = NbtUtils.readBlockState((HolderGetter)this.level().holderLookup(Registries.BLOCK), (CompoundTag)compound.getCompound("BlockState"));
        }
    }

    public boolean isNoGravity() {
        return true;
    }

    public void tick() {
        if (this.meteorBlockState.isAir()) {
            this.discard();
            return;
        }
        this.baseTick();
        if (this.tickCount % 20 == 0) {
            this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.BEACON_AMBIENT, SoundSource.HOSTILE, 10.0f, 0.5f);
            this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.FIREWORK_ROCKET_LAUNCH, SoundSource.HOSTILE, 10.0f, 0.1f);
        }
        if (!this.isNoGravity()) {
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.04, 0.0));
        } else {
            this.setDeltaMovement(0.0, -0.2, 0.0);
        }
        if (this.onGround()) {
            this.setDeltaMovement(0.0, 0.0, 0.0);
        }
        this.move(MoverType.SELF, this.getDeltaMovement());
    }

    public EntityDimensions getDimensions(Pose pose) {
        return super.getDimensions(pose).scale(5.0f);
    }
}

