/*
 * Decompiled with CFR 0.152.
 */
package com.example.meteors;

import com.example.meteors.CustomMeteorEntity;
import com.example.meteors.GiantMeteorEntity;
import com.example.meteors.Meteors;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetSubtitleTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetTitleTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetTitlesAnimationPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class MeteorManager {
    private static boolean active = false;
    private static int timer = 0;
    private static Difficulty currentDifficulty = Difficulty.EASY;
    private static ServerLevel level;
    private static final int DURATION = 6000;
    private static final Random random;
    private static final List<MeteorData> activeMeteors;

    public static void start(ServerLevel serverLevel, Difficulty difficulty) {
        active = true;
        timer = 6000;
        currentDifficulty = difficulty;
        level = serverLevel;
        activeMeteors.clear();
        if (difficulty == Difficulty.DESTRUCTIVE) {
            MeteorManager.spawnGiantMeteor();
            active = true;
        }
    }

    public static void tick() {
        if (level != null) {
            MeteorManager.checkMeteors();
        }
        if (!active) {
            return;
        }
        if (level == null || level.players().isEmpty()) {
            return;
        }
        if (timer-- <= 0) {
            active = false;
            return;
        }
        if (currentDifficulty != Difficulty.DESTRUCTIVE && timer % MeteorManager.currentDifficulty.spawnInterval == 0) {
            MeteorManager.spawnMeteors();
        }
    }

    private static void spawnGiantMeteor() {
        if (level.players().isEmpty()) {
            return;
        }
        ServerPlayer player = (ServerPlayer)level.players().get(random.nextInt(level.players().size()));
        int x = player.getBlockX();
        int z = player.getBlockZ();
        int y = 320;
        BlockPos spawnPos = new BlockPos(x, y, z);
        BlockState obsidian = Blocks.OBSIDIAN.defaultBlockState();
        GiantMeteorEntity meteor = new GiantMeteorEntity((Level)level, (double)spawnPos.getX() + 0.5, spawnPos.getY(), spawnPos.getZ(), obsidian);
        level.addFreshEntity((Entity)meteor);
        activeMeteors.add(new MeteorData(meteor.getUUID(), meteor.position(), true));
        MutableComponent title = Component.literal((String)"\u00a7c\u00a7lWARNING");
        MutableComponent subtitle = Component.literal((String)"\u00a76Massive Meteor Detected!");
        for (ServerPlayer p : level.players()) {
            p.connection.send((Packet)new ClientboundSetTitleTextPacket((Component)title));
            p.connection.send((Packet)new ClientboundSetSubtitleTextPacket((Component)subtitle));
            p.connection.send((Packet)new ClientboundSetTitlesAnimationPacket(10, 100, 20));
            p.sendSystemMessage((Component)Component.literal((String)"\u00a7c\u00a7lWARNING: MASSIVE METEOR DETECTED! IMPACT IMMINENT!"));
        }
    }

    private static void spawnMeteors() {
        for (ServerPlayer player : level.players()) {
            int x = player.getBlockX() + random.nextInt(100) - 50;
            int z = player.getBlockZ() + random.nextInt(100) - 50;
            int y = player.getBlockY() + 50 + random.nextInt(20);
            if (y > 319) {
                y = 319;
            }
            BlockPos spawnPos = new BlockPos(x, y, z);
            BlockState obsidian = Blocks.OBSIDIAN.defaultBlockState();
            CustomMeteorEntity meteor = new CustomMeteorEntity(Meteors.METEOR.get(), (Level)level);
            meteor.setPos((double)spawnPos.getX() + 0.5, spawnPos.getY(), spawnPos.getZ());
            meteor.setMeteorBlockState(obsidian);
            meteor.setStartPos(spawnPos);
            level.addFreshEntity((Entity)meteor);
            meteor.dropItem = false;
            double speed = 0.5 + random.nextDouble() * 1.0;
            double angle = random.nextDouble() * Math.PI * 2.0;
            double motionX = Math.cos(angle) * speed;
            double motionZ = Math.sin(angle) * speed;
            meteor.setDeltaMovement(motionX, -1.0, motionZ);
            activeMeteors.add(new MeteorData(meteor.getUUID(), meteor.position(), false));
        }
    }

    private static void checkMeteors() {
        Iterator<MeteorData> it = activeMeteors.iterator();
        while (it.hasNext()) {
            MeteorData data = it.next();
            Entity entity = level.getEntity(data.uuid);
            if (entity != null && entity.isAlive()) {
                data.lastPos = entity.position();
                ServerLevel serverLevel = (ServerLevel)entity.level();
                for (ServerPlayer player : serverLevel.players()) {
                    if (!(player.distanceToSqr(entity) < 1048576.0)) continue;
                    int count = data.isGiant ? 20 : 3;
                    float spread = data.isGiant ? 2.0f : 0.2f;
                    serverLevel.sendParticles(player, (ParticleOptions)ParticleTypes.FLAME, true, entity.getX(), entity.getY() + (data.isGiant ? 2.5 : 0.5), entity.getZ(), count, (double)spread, (double)spread, (double)spread, 0.05);
                    serverLevel.sendParticles(player, (ParticleOptions)ParticleTypes.LARGE_SMOKE, true, entity.getX(), entity.getY() + (data.isGiant ? 2.5 : 0.5), entity.getZ(), count, (double)spread, (double)spread, (double)spread, 0.05);
                }
                if (!entity.onGround()) continue;
                if (data.isGiant) {
                    MeteorManager.explodeGiant(data.lastPos);
                } else {
                    MeteorManager.explode(data.lastPos);
                }
                entity.discard();
                it.remove();
                continue;
            }
            it.remove();
        }
    }

    private static void explode(Vec3 pos) {
        BlockPos blockPos;
        level.explode(null, pos.x, pos.y, pos.z, MeteorManager.currentDifficulty.explosionPower, true, Level.ExplosionInteraction.TNT);
        if (random.nextBoolean() && level.getBlockState(blockPos = new BlockPos((int)pos.x, (int)pos.y, (int)pos.z)).isAir()) {
            level.setBlockAndUpdate(blockPos, Blocks.FIRE.defaultBlockState());
        }
    }

    private static void explodeGiant(Vec3 pos) {
        int radius = 250;
        level.explode(null, pos.x, pos.y, pos.z, 50.0f, true, Level.ExplosionInteraction.TNT);
        level.playSound(null, pos.x, pos.y, pos.z, (Holder)SoundEvents.GENERIC_EXPLODE, SoundSource.HOSTILE, 100.0f, 0.1f);
        level.playSound(null, pos.x, pos.y, pos.z, (Holder)SoundEvents.GENERIC_EXPLODE, SoundSource.HOSTILE, 100.0f, 0.5f);
        level.playSound(null, pos.x, pos.y, pos.z, SoundEvents.WITHER_DEATH, SoundSource.HOSTILE, 100.0f, 0.5f);
        BlockPos center = new BlockPos((int)pos.x, (int)pos.y, (int)pos.z);
        for (int x = -radius; x <= radius; x += 5) {
            for (int z = -radius; z <= radius; z += 5) {
                if (x * x + z * z > radius * radius || random.nextInt(10) != 0) continue;
                BlockPos target = level.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, center.offset(x, 0, z));
                if (level.getBlockState(target).isAir()) {
                    level.setBlockAndUpdate(target, Blocks.FIRE.defaultBlockState());
                }
                if (random.nextInt(5) == 0) {
                    level.setBlockAndUpdate(target.below(), Blocks.OBSIDIAN.defaultBlockState());
                }
                if (random.nextInt(100) != 0) continue;
                level.explode(null, (double)target.getX(), (double)target.getY(), (double)target.getZ(), 4.0f, true, Level.ExplosionInteraction.NONE);
            }
        }
        AABB damageArea = new AABB(center).inflate(150.0);
        List victims = level.getEntities(null, damageArea);
        for (Entity victim : victims) {
            if (!(victim instanceof LivingEntity)) continue;
            double distSqr = victim.distanceToSqr(pos);
            double dist = Math.sqrt(distSqr);
            if (dist <= 25.0) {
                victim.hurt(level.damageSources().explosion(null, null), Float.MAX_VALUE);
                continue;
            }
            if (dist <= 50.0) {
                victim.hurt(level.damageSources().explosion(null, null), 100.0f);
                continue;
            }
            if (dist <= 100.0) {
                victim.hurt(level.damageSources().explosion(null, null), 40.0f);
                continue;
            }
            if (!(dist <= 150.0)) continue;
            victim.hurt(level.damageSources().explosion(null, null), 10.0f);
        }
        for (ServerPlayer p : level.players()) {
            p.sendSystemMessage((Component)Component.literal((String)"\u00a74\u00a7lIMPACT CONFIRMED."));
        }
    }

    static {
        random = new Random();
        activeMeteors = new ArrayList<MeteorData>();
    }

    public static enum Difficulty {
        EASY(100, 2.0f),
        MEDIUM(50, 4.0f),
        HARD(20, 6.0f),
        DESTRUCTIVE(0, 0.0f);

        final int spawnInterval;
        final float explosionPower;

        private Difficulty(int spawnInterval, float explosionPower) {
            this.spawnInterval = spawnInterval;
            this.explosionPower = explosionPower;
        }
    }

    private static class MeteorData {
        UUID uuid;
        Vec3 lastPos;
        boolean isGiant;

        MeteorData(UUID uuid, Vec3 lastPos, boolean isGiant) {
            this.uuid = uuid;
            this.lastPos = lastPos;
            this.isGiant = isGiant;
        }
    }
}

