/*
 * Decompiled with CFR 0.152.
 */
package com.example.meteors;

import com.example.meteors.CustomMeteorEntity;
import com.example.meteors.CustomMeteorEntityRenderer;
import com.example.meteors.GiantMeteorEntity;
import com.example.meteors.GiantMeteorEntityRenderer;
import com.example.meteors.MeteorManager;
import com.example.meteors.MeteorsCommand;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.logging.LogUtils;
import java.util.function.Supplier;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.slf4j.Logger;

@Mod(value="meteors")
public class Meteors {
    public static final String MODID = "meteors";
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final DeferredRegister<EntityType<?>> ENTITY_TYPES = DeferredRegister.create((ResourceKey)Registries.ENTITY_TYPE, (String)"meteors");
    public static final Supplier<EntityType<CustomMeteorEntity>> METEOR = ENTITY_TYPES.register("meteor", () -> EntityType.Builder.of(CustomMeteorEntity::new, (MobCategory)MobCategory.MISC).sized(0.98f, 0.98f).clientTrackingRange(10).updateInterval(1).build("meteor"));
    public static final Supplier<EntityType<GiantMeteorEntity>> GIANT_METEOR = ENTITY_TYPES.register("giant_meteor", () -> EntityType.Builder.of(GiantMeteorEntity::new, (MobCategory)MobCategory.MISC).sized(5.0f, 5.0f).clientTrackingRange(20).updateInterval(1).build("giant_meteor"));

    public Meteors(IEventBus modEventBus) {
        NeoForge.EVENT_BUS.register((Object)this);
        ENTITY_TYPES.register(modEventBus);
        modEventBus.addListener(this::registerEntityRenderers);
    }

    private void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer(METEOR.get(), CustomMeteorEntityRenderer::new);
        event.registerEntityRenderer(GIANT_METEOR.get(), GiantMeteorEntityRenderer::new);
    }

    @SubscribeEvent
    public void onRegisterCommands(RegisterCommandsEvent event) {
        MeteorsCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent
    public void onServerTick(ServerTickEvent.Post event) {
        MeteorManager.tick();
    }
}

