/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.smartbrainlib.api.core.navigation;

import java.util.Set;
import net.minecraft.class_10;
import net.minecraft.class_11;
import net.minecraft.class_1297;
import net.minecraft.class_13;
import net.minecraft.class_1308;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1941;
import net.minecraft.class_1950;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_5867;
import net.minecraft.class_7;
import net.minecraft.class_8;
import net.minecraft.class_9316;
import org.jetbrains.annotations.Nullable;

public interface ExtendedNavigator {
    public static final float EPSILON = 1.0E-8f;

    public class_1308 getMob();

    public class_11 method_6345();

    default public boolean canPathOnto(class_7 pathType) {
        return switch (pathType) {
            case class_7.field_18, class_7.field_14, class_7.field_7 -> false;
            default -> true;
        };
    }

    default public boolean canPathInto(class_7 pathType) {
        return switch (pathType) {
            case class_7.field_3, class_7.field_9, class_7.field_17 -> true;
            default -> false;
        };
    }

    default public boolean isCloseToNextNode(float distance) {
        class_1308 mob = this.getMob();
        class_11 path = this.method_6345();
        class_243 nextNodePos = this.getEntityPosAtNode(path.method_39());
        return Math.abs(mob.method_23317() - nextNodePos.field_1352) < (double)distance && Math.abs(mob.method_23321() - nextNodePos.field_1350) < (double)distance && Math.abs(mob.method_23318() - nextNodePos.field_1351) < 1.0;
    }

    default public boolean isAboutToTraverseVertically() {
        class_1308 mob = this.getMob();
        class_11 path = this.method_6345();
        int fromNode = path.method_39();
        int fromNodeHeight = path.method_40((int)fromNode).field_39;
        int toNode = Math.min(path.method_38(), fromNode + class_3532.method_15384((double)((double)mob.method_17681() * 0.5)) + 1);
        for (int i = fromNode + 1; i < toNode; ++i) {
            if (path.method_40((int)i).field_39 == fromNodeHeight) continue;
            return true;
        }
        return false;
    }

    @Nullable
    default public class_11 patchPath(@Nullable class_11 path) {
        return path == null ? null : new class_11(path.field_52, path.method_48(), path.method_21655()){

            public class_243 method_47(class_1297 entity, int nodeIndex) {
                return ExtendedNavigator.this.getEntityPosAtNode(nodeIndex);
            }
        };
    }

    default public class_13 createSmoothPathFinder(class_8 nodeEvaluator, int maxVisitedNodes) {
        return new class_13(nodeEvaluator, maxVisitedNodes){

            @Nullable
            public class_11 method_52(class_1950 navigationRegion, class_1308 mob, Set<class_2338> targetPositions, float maxRange, int accuracy, float searchDepthMultiplier) {
                return ExtendedNavigator.this.patchPath(super.method_52(navigationRegion, mob, targetPositions, maxRange, accuracy, searchDepthMultiplier));
            }
        };
    }

    default public boolean attemptShortcut(int targetNode, class_243 safeSurfacePos) {
        class_1308 mob = this.getMob();
        class_11 path = this.method_6345();
        class_243 position = mob.method_19538();
        class_243 minBounds = safeSurfacePos.method_1031((double)(-mob.method_17681()) * 0.5, 0.0, (double)(-mob.method_17681()) * 0.5);
        class_243 maxBounds = minBounds.method_1031((double)mob.method_17681(), (double)mob.method_17682(), (double)mob.method_17681());
        for (int nodeIndex = targetNode - 1; nodeIndex > path.method_39(); --nodeIndex) {
            class_243 nodeDelta = this.getEntityPosAtNode(nodeIndex).method_1020(position);
            if (!this.isCollisionFreeTraversal(nodeDelta, minBounds, maxBounds)) continue;
            path.method_42(nodeIndex);
            return true;
        }
        return false;
    }

    default public class_243 getEntityPosAtNode(int nodeIndex) {
        class_1308 mob = this.getMob();
        class_11 path = this.method_6345();
        double lateralOffset = (double)class_3532.method_15357((double)((double)mob.method_17681() + 1.0)) / 2.0;
        return class_243.method_24954((class_2382)path.method_31031(nodeIndex)).method_1031(lateralOffset, 0.0, lateralOffset);
    }

    default public boolean isCollisionFreeTraversal(class_243 traversalVector, class_243 minBoundsPos, class_243 leadingEdgePos) {
        float traversalDistance = (float)traversalVector.method_1033();
        if (traversalDistance < 1.0E-8f) {
            return true;
        }
        VoxelRayDetails ray = new VoxelRayDetails();
        for (class_2350.class_2351 axis : class_2350.class_2351.values()) {
            int index = axis.ordinal();
            float axisLength = this.lengthForAxis(traversalVector, axis);
            boolean isPositive = axisLength >= 0.0f;
            float maxPos = this.lengthForAxis(isPositive ? leadingEdgePos : minBoundsPos, axis);
            ray.absStep[index] = isPositive ? 1 : -1;
            ray.minPos[index] = this.lengthForAxis(isPositive ? minBoundsPos : leadingEdgePos, axis);
            ray.leadingEdgeBound[index] = class_3532.method_15375((float)(maxPos - (float)ray.absStep[index] * 1.0E-8f));
            ray.trailingEdgeBound[index] = class_3532.method_15375((float)(ray.minPos[index] + (float)ray.absStep[index] * 1.0E-8f));
            ray.axisLengthNormalised[index] = axisLength / traversalDistance;
            ray.axisSteps[index] = class_3532.method_15379((float)(traversalDistance / axisLength));
            float dist = isPositive ? (float)(ray.leadingEdgeBound[index] + 1) - maxPos : maxPos - (float)ray.leadingEdgeBound[index];
            ray.rayTargetLength[index] = ray.axisSteps[index] < Float.POSITIVE_INFINITY ? ray.axisSteps[index] * dist : Float.POSITIVE_INFINITY;
        }
        return this.collidesWhileTraversing(ray, traversalDistance);
    }

    default public boolean collidesWhileTraversing(VoxelRayDetails ray, float traversalDistance) {
        class_1308 mob = this.getMob();
        class_1937 level = mob.method_37908();
        try (class_5867 sectionAccess = new class_5867((class_1936)level);){
            class_8 nodeEvaluator = mob.method_5942().method_6342();
            class_2338.class_2339 pos = new class_2338.class_2339();
            float target = 0.0f;
            do {
                class_2350.class_2351 longestEdge = ray.rayTargetLength[0] < ray.rayTargetLength[1] ? (ray.rayTargetLength[0] < ray.rayTargetLength[2] ? class_2350.class_2351.field_11048 : class_2350.class_2351.field_11051) : (ray.rayTargetLength[1] < ray.rayTargetLength[2] ? class_2350.class_2351.field_11052 : class_2350.class_2351.field_11051);
                int index = longestEdge.ordinal();
                float rayDelta = ray.rayTargetLength[index] - target;
                target = ray.rayTargetLength[index];
                int n = index;
                ray.leadingEdgeBound[n] = ray.leadingEdgeBound[n] + ray.absStep[index];
                int n2 = index;
                ray.rayTargetLength[n2] = ray.rayTargetLength[n2] + ray.axisSteps[index];
                for (class_2350.class_2351 axis : class_2350.class_2351.values()) {
                    int index2;
                    int n3 = index2 = axis.ordinal();
                    ray.minPos[n3] = ray.minPos[n3] + rayDelta * ray.axisLengthNormalised[index2];
                    ray.trailingEdgeBound[index2] = class_3532.method_15375((float)(ray.minPos[index2] + (float)ray.absStep[index2] * 1.0E-8f));
                }
                int xStep = ray.absStep[0];
                int yStep = ray.absStep[1];
                int zStep = ray.absStep[2];
                int xBound = longestEdge == class_2350.class_2351.field_11048 ? ray.leadingEdgeBound[0] : ray.trailingEdgeBound[0];
                int yBound = longestEdge == class_2350.class_2351.field_11052 ? ray.leadingEdgeBound[1] : ray.trailingEdgeBound[1];
                int zBound = longestEdge == class_2350.class_2351.field_11051 ? ray.leadingEdgeBound[2] : ray.trailingEdgeBound[2];
                int xStepBound = ray.leadingEdgeBound[0] + xStep;
                int yStepBound = ray.leadingEdgeBound[1] + yStep;
                int zStepBound = ray.leadingEdgeBound[2] + zStep;
                for (int x = xBound; x != xStepBound; x += xStep) {
                    for (int z = zBound; z != zStepBound; z += zStep) {
                        int y;
                        for (y = yBound; y != yStepBound; y += yStep) {
                            if (sectionAccess.method_33946((class_2338)pos.method_10103(x, y, z)).method_26171(class_10.field_50)) continue;
                            boolean bl = false;
                            return bl;
                        }
                        if (!this.canPathOnto(nodeEvaluator.method_17(new class_9316((class_1941)level, mob), x, yBound - 1, z))) {
                            y = 0;
                            return y != 0;
                        }
                        class_7 insidePathType = nodeEvaluator.method_17(new class_9316((class_1941)level, mob), x, yBound, z);
                        float pathMalus = mob.method_5944(insidePathType);
                        if (pathMalus < 0.0f || pathMalus >= 8.0f) {
                            boolean bl = false;
                            return bl;
                        }
                        if (!this.canPathInto(insidePathType)) continue;
                        boolean bl = false;
                        return bl;
                    }
                }
            } while (target <= traversalDistance);
        }
        return true;
    }

    default public float lengthForAxis(class_243 vector, class_2350.class_2351 axis) {
        return (float)axis.method_10172(vector.field_1352, vector.field_1351, vector.field_1350);
    }

    public record VoxelRayDetails(float[] minPos, int[] leadingEdgeBound, int[] trailingEdgeBound, int[] absStep, float[] axisSteps, float[] rayTargetLength, float[] axisLengthNormalised) {
        public VoxelRayDetails() {
            this(new float[3], new int[3], new int[3], new int[3], new float[3], new float[3], new float[3]);
        }
    }
}

