/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.smartbrainlib.object;

import java.util.function.BiPredicate;
import java.util.function.Function;
import net.minecraft.class_1267;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_5134;
import net.tslat.smartbrainlib.util.SensoryUtils;
import org.jetbrains.annotations.Nullable;

public class ExtendedTargetingConditions {
    protected BiPredicate<class_1309, class_1309> customFilter = null;
    protected Function<class_1309, Double> rangeRetriever = null;
    protected boolean isAttacking = true;
    protected boolean checkLineOfSight = true;
    protected boolean ignoresInvisibility = false;

    public static ExtendedTargetingConditions forLookTarget() {
        return new ExtendedTargetingConditions().isJustLooking();
    }

    public static ExtendedTargetingConditions forLookTargetIgnoringInvisibility() {
        return ExtendedTargetingConditions.forLookTarget().skipInvisibilityCheck();
    }

    public static ExtendedTargetingConditions forAttackTarget() {
        return new ExtendedTargetingConditions();
    }

    public static ExtendedTargetingConditions forAttackTargetIgnoringInvisibility() {
        return ExtendedTargetingConditions.forAttackTarget().skipInvisibilityCheck();
    }

    public ExtendedTargetingConditions isJustLooking() {
        this.isAttacking = false;
        return this;
    }

    public ExtendedTargetingConditions withRange(double range) {
        return this.withRange(entity -> range);
    }

    public ExtendedTargetingConditions withRange(Function<class_1309, Double> function) {
        this.rangeRetriever = function;
        return this;
    }

    public ExtendedTargetingConditions withFollowRange() {
        return this.withRange(entity -> entity.method_5996(class_5134.field_23717) != null ? entity.method_45325(class_5134.field_23717) : 16.0);
    }

    public ExtendedTargetingConditions onlyTargeting(BiPredicate<@Nullable class_1309, class_1309> predicate) {
        this.customFilter = predicate;
        return this;
    }

    public ExtendedTargetingConditions ignoreLineOfSight() {
        this.checkLineOfSight = false;
        return this;
    }

    public ExtendedTargetingConditions skipInvisibilityCheck() {
        this.ignoresInvisibility = true;
        return this;
    }

    public boolean test(@Nullable class_1309 entity, class_1309 target) {
        if (entity == target || !target.method_36608()) {
            return false;
        }
        if (this.customFilter != null && !this.customFilter.test(entity, target)) {
            return false;
        }
        if (entity == null) {
            return !this.isAttacking || target.method_33190() && target.method_37908().method_8407() != class_1267.field_5801;
        }
        if (this.isAttacking && (!entity.method_18395(target) || !entity.method_5973(target.method_5864()) || entity.method_5722((class_1297)target))) {
            return false;
        }
        double range = this.rangeRetriever.apply(entity);
        if (range > 0.0) {
            double sightRange = Math.max(range * (this.ignoresInvisibility ? 1.0 : target.method_18390((class_1297)entity)), 2.0);
            if (entity.method_5858((class_1297)target) > sightRange * sightRange) {
                return false;
            }
        }
        if (this.checkLineOfSight) {
            return SensoryUtils.hasLineOfSight(entity, (class_1297)target);
        }
        return true;
    }
}

