/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.smartbrainlib.util;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_4076;
import net.minecraft.class_5573;
import net.minecraft.class_5575;
import net.minecraft.class_5577;
import net.minecraft.class_5578;
import net.minecraft.class_7927;
import net.tslat.smartbrainlib.SBLConstants;
import org.apache.commons.lang3.mutable.MutableDouble;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public final class EntityRetrievalUtil {
    @Nullable
    public static <T extends class_1297> T getNearest(class_243 origin, List<T> entities) {
        if (entities.isEmpty()) {
            return null;
        }
        double dist = Double.MAX_VALUE;
        class_1297 closest = null;
        for (class_1297 entity : entities) {
            double entityDist = entity.method_5707(origin);
            if (!(entityDist < dist)) continue;
            dist = entityDist;
            closest = entity;
        }
        return (T)closest;
    }

    public static <T> Optional<T> getNearestEntity(class_1297 origin, double radius) {
        return EntityRetrievalUtil.getNearestEntity(origin, radius, radius, radius);
    }

    public static <T> Optional<T> getNearestEntity(class_1297 origin, double radiusX, double radiusY, double radiusZ) {
        return Optional.ofNullable(EntityRetrievalUtil.getNearestEntity(origin.method_37908(), origin.method_5829().method_1009(radiusX, radiusY, radiusZ), origin.method_19538(), (? extends class_1297 entity) -> entity != origin));
    }

    public static <T extends class_1297> Optional<T> getNearestEntity(class_1937 level, class_243 origin, double radius) {
        return EntityRetrievalUtil.getNearestEntity(level, origin, radius, radius, radius);
    }

    public static <T extends class_1297> Optional<T> getNearestEntity(class_1937 level, class_243 origin, double radiusX, double radiusY, double radiusZ) {
        return EntityRetrievalUtil.getNearestEntity(level, class_238.method_30048((class_243)origin, (double)radiusX, (double)radiusY, (double)radiusZ), origin);
    }

    public static <T extends class_1297> Optional<T> getNearestEntity(class_1937 level, class_238 bounds, class_243 origin) {
        return EntityRetrievalUtil.getNearestEntity(level, bounds, origin, class_1297.class);
    }

    public static <T extends class_1297> Optional<T> getNearestEntity(class_1297 origin, double radius, Class<T> minimumClass) {
        return EntityRetrievalUtil.getNearestEntity(origin, radius, radius, radius, minimumClass);
    }

    public static <T extends class_1297> Optional<T> getNearestEntity(class_1297 origin, double radiusX, double radiusY, double radiusZ, Class<T> minimumClass) {
        return EntityRetrievalUtil.getNearestEntity(origin.method_37908(), origin.method_5829().method_1009(radiusX, radiusY, radiusZ), origin.method_19538(), minimumClass, (T entity) -> entity != origin);
    }

    public static <T extends class_1297> Optional<T> getNearestEntity(class_1937 level, class_243 origin, double radius, Class<T> minimumClass) {
        return EntityRetrievalUtil.getNearestEntity(level, origin, radius, radius, radius, minimumClass);
    }

    public static <T extends class_1297> Optional<T> getNearestEntity(class_1937 level, class_243 origin, double radiusX, double radiusY, double radiusZ, Class<T> minimumClass) {
        return EntityRetrievalUtil.getNearestEntity(level, class_238.method_30048((class_243)origin, (double)radiusX, (double)radiusY, (double)radiusZ), origin, minimumClass);
    }

    public static <T extends class_1297> Optional<T> getNearestEntity(class_1937 level, class_238 bounds, class_243 origin, Class<T> minimumClass) {
        return EntityRetrievalUtil.getNearestEntity(level, bounds, origin, minimumClass, (T entity) -> true);
    }

    public static <T extends class_1297> T getNearestEntity(class_1297 origin, double radius, Predicate<? extends class_1297> predicate) {
        return EntityRetrievalUtil.getNearestEntity(origin, radius, radius, radius, predicate);
    }

    public static <T extends class_1297> T getNearestEntity(class_1297 origin, double radiusX, double radiusY, double radiusZ, Predicate<? extends class_1297> predicate) {
        return EntityRetrievalUtil.getNearestEntity(origin.method_37908(), origin.method_5829().method_1009(radiusX, radiusY, radiusZ), origin.method_19538(), ((Predicate<class_1297>)entity -> entity != origin).and(predicate));
    }

    public static <T extends class_1297> Optional<T> getNearestEntity(class_1937 level, class_243 origin, double radius, Predicate<class_1297> predicate) {
        return EntityRetrievalUtil.getNearestEntity(level, origin, radius, radius, radius, predicate);
    }

    public static <T extends class_1297> Optional<T> getNearestEntity(class_1937 level, class_243 origin, double radiusX, double radiusY, double radiusZ, Predicate<class_1297> predicate) {
        return Optional.ofNullable(EntityRetrievalUtil.getNearestEntity(level, class_238.method_30048((class_243)origin, (double)radiusX, (double)radiusY, (double)radiusZ), origin, predicate));
    }

    @Nullable
    public static <T extends class_1297> T getNearestEntity(class_1937 level, class_238 bounds, class_243 origin, Predicate<? extends class_1297> predicate) {
        return (T)((class_1297)EntityRetrievalUtil.getNearestEntity(level, bounds, origin, class_1297.class, predicate).orElse(null));
    }

    public static <T extends class_1297> Optional<T> getNearestEntity(class_1297 origin, double radius, Class<T> minimumClass, Predicate<T> predicate) {
        return EntityRetrievalUtil.getNearestEntity(origin, radius, radius, radius, minimumClass, predicate);
    }

    public static <T extends class_1297> Optional<T> getNearestEntity(class_1297 origin, double radiusX, double radiusY, double radiusZ, Class<T> minimumClass, Predicate<T> predicate) {
        return EntityRetrievalUtil.getNearestEntity(origin.method_37908(), origin.method_5829().method_1009(radiusX, radiusY, radiusZ), origin.method_19538(), minimumClass, ((Predicate<class_1297>)entity -> entity != origin).and(predicate));
    }

    public static <T extends class_1297> Optional<T> getNearestEntity(class_1937 level, class_243 origin, double radius, Class<T> minimumClass, Predicate<T> predicate) {
        return EntityRetrievalUtil.getNearestEntity(level, class_238.method_30048((class_243)origin, (double)radius, (double)radius, (double)radius), origin, minimumClass, predicate);
    }

    public static <T extends class_1297> Optional<T> getNearestEntity(class_1937 level, class_243 origin, double radiusX, double radiusY, double radiusZ, Class<T> minimumClass, Predicate<T> predicate) {
        return EntityRetrievalUtil.getNearestEntity(level, class_238.method_30048((class_243)origin, (double)radiusX, (double)radiusY, (double)radiusZ), origin, minimumClass, predicate);
    }

    public static <T extends class_1297> Optional<T> getNearestEntity(class_1937 level, class_238 bounds, class_243 origin, Class<T> minimumClass, Predicate<T> predicate) {
        MutableDouble dist = new MutableDouble(Double.MAX_VALUE);
        MutableObject closest = new MutableObject(null);
        class_5575<class_1297, T> typeTest = EntityRetrievalUtil.makeLazyTypeTest(minimumClass);
        level.method_31592().method_31805(typeTest, bounds, entity -> {
            double entityDist;
            if (predicate.test(entity) && (entityDist = entity.method_5707(origin)) < dist.doubleValue()) {
                dist.setValue(entityDist);
                closest.setValue(entity);
            }
            return class_7927.class_7928.field_41283;
        });
        return Optional.ofNullable((class_1297)closest.getValue());
    }

    public static <T extends class_1657> T getNearestPlayer(class_1297 origin, double radius) {
        return EntityRetrievalUtil.getNearestPlayer(origin, radius, radius, radius);
    }

    public static <T extends class_1657> T getNearestPlayer(class_1297 origin, double radiusX, double radiusY, double radiusZ) {
        return (T)EntityRetrievalUtil.getNearestPlayer(origin.method_37908(), origin.method_5829().method_1009(radiusX, radiusY, radiusZ), origin.method_19538(), (class_1657 entity) -> entity != origin);
    }

    public static <T extends class_1657> T getNearestPlayer(class_1937 level, class_243 origin, double radius) {
        return EntityRetrievalUtil.getNearestPlayer(level, origin, radius, radius, radius);
    }

    public static <T extends class_1657> T getNearestPlayer(class_1937 level, class_243 origin, double radiusX, double radiusY, double radiusZ) {
        return EntityRetrievalUtil.getNearestPlayer(level, class_238.method_30048((class_243)origin, (double)radiusX, (double)radiusY, (double)radiusZ), origin);
    }

    public static <T extends class_1657> T getNearestPlayer(class_1937 level, class_238 area, class_243 origin) {
        return (T)EntityRetrievalUtil.getNearestPlayer(level, area, origin, (class_1657 pl) -> true);
    }

    public static class_1657 getNearestPlayer(class_1297 origin, double radius, Predicate<class_1657> predicate) {
        return EntityRetrievalUtil.getNearestPlayer(origin, radius, radius, radius, predicate);
    }

    public static class_1657 getNearestPlayer(class_1297 origin, double radiusX, double radiusY, double radiusZ, Predicate<class_1657> predicate) {
        return EntityRetrievalUtil.getNearestPlayer(origin.method_37908(), origin.method_5829().method_1009(radiusX, radiusY, radiusZ), origin.method_19538(), ((Predicate<class_1657>)entity -> entity != origin).and(predicate));
    }

    public static <T extends class_1657> T getNearestPlayer(class_1937 level, class_243 origin, double radius, Predicate<class_1657> predicate) {
        return EntityRetrievalUtil.getNearestPlayer(level, origin, radius, radius, radius, predicate);
    }

    public static <T extends class_1657> T getNearestPlayer(class_1937 level, class_243 origin, double radiusX, double radiusY, double radiusZ, Predicate<class_1657> predicate) {
        return (T)EntityRetrievalUtil.getNearestPlayer(level, class_238.method_30048((class_243)origin, (double)radiusX, (double)radiusY, (double)radiusZ), origin, predicate);
    }

    @Nullable
    public static class_1657 getNearestPlayer(class_1937 level, class_238 bounds, class_243 origin, Predicate<class_1657> predicate) {
        double dist = Double.MAX_VALUE;
        class_1657 closest = null;
        for (class_1657 player : level.method_18456()) {
            double playerDist;
            if (!bounds.method_1006(player.method_19538()) || !predicate.test(player) || !((playerDist = player.method_5707(origin)) < dist)) continue;
            dist = playerDist;
            closest = player;
        }
        return closest;
    }

    public static List<class_1657> getPlayers(class_1297 origin, double radius) {
        return EntityRetrievalUtil.getPlayers(origin, radius, radius, radius);
    }

    public static List<class_1657> getPlayers(class_1297 origin, double radiusX, double radiusY, double radiusZ) {
        return EntityRetrievalUtil.getPlayers(origin.method_37908(), origin.method_5829().method_1009(radiusX, radiusY, radiusZ), (class_1657 entity) -> entity != origin);
    }

    public static <T extends class_1657> List<T> getPlayers(class_1937 level, class_243 origin, double radius) {
        return EntityRetrievalUtil.getPlayers(level, origin, radius, radius, radius);
    }

    public static <T extends class_1657> List<T> getPlayers(class_1937 level, class_243 origin, double radiusX, double radiusY, double radiusZ) {
        return EntityRetrievalUtil.getPlayers(level, class_238.method_30048((class_243)origin, (double)radiusX, (double)radiusY, (double)radiusZ));
    }

    public static <T extends class_1657> List<T> getPlayers(class_1937 level, class_243 from, class_243 to) {
        return EntityRetrievalUtil.getPlayers(level, new class_238(from, to));
    }

    public static List<class_1657> getPlayers(class_1937 level, class_238 area) {
        return EntityRetrievalUtil.getPlayers(level, area, (class_1657 pl) -> true);
    }

    public static List<class_1657> getPlayers(class_1297 origin, double radius, Predicate<class_1657> predicate) {
        return EntityRetrievalUtil.getPlayers(origin, radius, radius, radius, predicate);
    }

    public static List<class_1657> getPlayers(class_1297 origin, double radiusX, double radiusY, double radiusZ, Predicate<class_1657> predicate) {
        return EntityRetrievalUtil.getPlayers(origin.method_37908(), origin.method_5829().method_1009(radiusX, radiusY, radiusZ), ((Predicate<class_1657>)entity -> entity != origin).and(predicate));
    }

    public static <T extends class_1657> List<T> getPlayers(class_1937 level, class_243 origin, double radius, Predicate<class_1657> predicate) {
        return EntityRetrievalUtil.getPlayers(level, origin, radius, radius, radius, predicate);
    }

    public static <T extends class_1657> List<T> getPlayers(class_1937 level, class_243 origin, double radiusX, double radiusY, double radiusZ, Predicate<class_1657> predicate) {
        return EntityRetrievalUtil.getPlayers(level, class_238.method_30048((class_243)origin, (double)radiusX, (double)radiusY, (double)radiusZ), predicate);
    }

    public static <T extends class_1657> List<T> getPlayers(class_1937 level, class_243 from, class_243 to, Predicate<class_1657> predicate) {
        return EntityRetrievalUtil.getPlayers(level, new class_238(from, to), predicate);
    }

    public static List<class_1657> getPlayers(class_1937 level, class_238 bounds, Predicate<class_1657> predicate) {
        ObjectArrayList players = new ObjectArrayList();
        for (class_1657 player : level.method_18456()) {
            if (!bounds.method_1006(player.method_19538()) || !predicate.test(player)) continue;
            players.add(player);
        }
        return players;
    }

    public static <T> List<T> getEntities(class_1297 origin, double radius) {
        return EntityRetrievalUtil.getEntities(origin, radius, radius, radius);
    }

    public static <T> List<T> getEntities(class_1297 origin, double radiusX, double radiusY, double radiusZ) {
        return EntityRetrievalUtil.getEntities(origin.method_37908(), origin.method_5829().method_1009(radiusX, radiusY, radiusZ), (? extends class_1297 entity) -> entity != origin);
    }

    public static <T extends class_1297> List<T> getEntities(class_1937 level, class_243 origin, double radius) {
        return EntityRetrievalUtil.getEntities(level, class_238.method_30048((class_243)origin, (double)radius, (double)radius, (double)radius));
    }

    public static <T extends class_1297> List<T> getEntities(class_1937 level, class_243 origin, double radiusX, double radiusY, double radiusZ) {
        return EntityRetrievalUtil.getEntities(level, class_238.method_30048((class_243)origin, (double)radiusX, (double)radiusY, (double)radiusZ));
    }

    public static <T extends class_1297> List<T> getEntities(class_1937 level, class_243 from, class_243 to) {
        return EntityRetrievalUtil.getEntities(level, new class_238(from, to));
    }

    public static <T extends class_1297> List<T> getEntities(class_1937 level, class_238 area) {
        return EntityRetrievalUtil.getEntities(level, area, class_1297.class);
    }

    public static <T extends class_1297> List<T> getEntities(class_1297 origin, double radius, Class<T> minimumClass) {
        return EntityRetrievalUtil.getEntities(origin, radius, radius, radius, minimumClass);
    }

    public static <T extends class_1297> List<T> getEntities(class_1297 origin, double radiusX, double radiusY, double radiusZ, Class<T> minimumClass) {
        return EntityRetrievalUtil.getEntities(origin.method_37908(), origin.method_5829().method_1009(radiusX, radiusY, radiusZ), minimumClass, (T entity) -> entity != origin);
    }

    public static <T extends class_1297> List<T> getEntities(class_1937 level, class_243 origin, double radius, Class<T> minimumClass) {
        return EntityRetrievalUtil.getEntities(level, class_238.method_30048((class_243)origin, (double)radius, (double)radius, (double)radius), minimumClass);
    }

    public static <T extends class_1297> List<T> getEntities(class_1937 level, class_243 origin, double radiusX, double radiusY, double radiusZ, Class<T> minimumClass) {
        return EntityRetrievalUtil.getEntities(level, class_238.method_30048((class_243)origin, (double)radiusX, (double)radiusY, (double)radiusZ), minimumClass);
    }

    public static <T extends class_1297> List<T> getEntities(class_1937 level, class_243 from, class_243 to, Class<T> minimumClass) {
        return EntityRetrievalUtil.getEntities(level, new class_238(from, to), minimumClass);
    }

    public static <T extends class_1297> List<T> getEntities(class_1937 level, class_238 bounds, Class<T> minimumClass) {
        return EntityRetrievalUtil.getEntities(level, bounds, minimumClass, (T entity) -> true);
    }

    public static <T> List<T> getEntities(class_1297 origin, double radius, Predicate<? extends class_1297> predicate) {
        return EntityRetrievalUtil.getEntities(origin, radius, radius, radius, predicate);
    }

    public static <T> List<T> getEntities(class_1297 origin, double radiusX, double radiusY, double radiusZ, Predicate<? extends class_1297> predicate) {
        return EntityRetrievalUtil.getEntities(origin.method_37908(), origin.method_5829().method_1009(radiusX, radiusY, radiusZ), ((Predicate<class_1297>)entity -> entity != origin).and(predicate));
    }

    public static <T extends class_1297> List<T> getEntities(class_1937 level, class_243 origin, double radius, Predicate<class_1297> predicate) {
        return EntityRetrievalUtil.getEntities(level, class_238.method_30048((class_243)origin, (double)radius, (double)radius, (double)radius), predicate);
    }

    public static <T extends class_1297> List<T> getEntities(class_1937 level, class_243 origin, double radiusX, double radiusY, double radiusZ, Predicate<class_1297> predicate) {
        return EntityRetrievalUtil.getEntities(level, class_238.method_30048((class_243)origin, (double)radiusX, (double)radiusY, (double)radiusZ), predicate);
    }

    public static <T extends class_1297> List<T> getEntities(class_1937 level, class_243 from, class_243 to, Predicate<class_1297> predicate) {
        return EntityRetrievalUtil.getEntities(level, new class_238(from, to), predicate);
    }

    public static <T extends class_1297> List<T> getEntities(class_1937 level, class_238 area, Predicate<? extends class_1297> predicate) {
        return EntityRetrievalUtil.getEntities(level, area, class_1297.class, predicate);
    }

    public static <T extends class_1297> List<T> getEntities(class_1297 origin, double radius, Class<T> minimumClass, Predicate<T> predicate) {
        return EntityRetrievalUtil.getEntities(origin, radius, radius, radius, minimumClass, predicate);
    }

    public static <T extends class_1297> List<T> getEntities(class_1297 origin, double radiusX, double radiusY, double radiusZ, Class<T> minimumClass, Predicate<T> predicate) {
        return EntityRetrievalUtil.getEntities(origin.method_37908(), origin.method_5829().method_1009(radiusX, radiusY, radiusZ), minimumClass, ((Predicate<class_1297>)entity -> entity != origin).and(predicate));
    }

    public static <T extends class_1297> List<T> getEntities(class_1937 level, class_243 origin, double radius, Class<T> minimumClass, Predicate<T> predicate) {
        return EntityRetrievalUtil.getEntities(level, class_238.method_30048((class_243)origin, (double)radius, (double)radius, (double)radius), minimumClass, predicate);
    }

    public static <T extends class_1297> List<T> getEntities(class_1937 level, class_243 origin, double radiusX, double radiusY, double radiusZ, Class<T> minimumClass, Predicate<T> predicate) {
        return EntityRetrievalUtil.getEntities(level, class_238.method_30048((class_243)origin, (double)radiusX, (double)radiusY, (double)radiusZ), minimumClass, predicate);
    }

    public static <T extends class_1297> List<T> getEntities(class_1937 level, class_243 from, class_243 to, Class<T> minimumClass, Predicate<T> predicate) {
        return EntityRetrievalUtil.getEntities(level, new class_238(from, to), minimumClass, predicate);
    }

    public static <T extends class_1297> List<T> getEntities(class_1937 level, class_238 bounds, Class<T> minimumClass, Predicate<T> predicate) {
        ObjectArrayList foundEntities = new ObjectArrayList();
        class_5575<class_1297, T> typeTest = EntityRetrievalUtil.makeLazyTypeTest(minimumClass);
        level.method_31592().method_31805(typeTest, bounds, arg_0 -> EntityRetrievalUtil.lambda$getEntities$17(predicate, (List)foundEntities, arg_0));
        Pair<Collection<? extends class_1297>, Function<class_1297, ? extends class_1297>> partEntities = SBLConstants.SBL_LOADER.getPartEntities(level);
        for (class_1297 part : (Collection)partEntities.getFirst()) {
            class_1297 entity = (class_1297)typeTest.method_31796((Object)((class_1297)((Function)partEntities.getSecond()).apply(part)));
            if (entity == null || !part.method_5829().method_994(bounds) || !predicate.test(entity)) continue;
            foundEntities.add(entity);
        }
        return foundEntities;
    }

    public static <T extends class_1657> Optional<T> findPlayer(class_1297 origin, double radius, Predicate<class_1657> predicate) {
        return EntityRetrievalUtil.findPlayer(origin, radius, radius, radius, predicate);
    }

    public static <T extends class_1657> Optional<T> findPlayer(class_1297 origin, double radiusX, double radiusY, double radiusZ, Predicate<class_1657> predicate) {
        return EntityRetrievalUtil.findPlayer(origin.method_37908(), origin.method_5829().method_1009(radiusX, radiusY, radiusZ), ((Predicate<class_1657>)entity -> entity != origin).and(predicate));
    }

    public static <T extends class_1657> Optional<T> findPlayer(class_1937 level, class_243 origin, double radius, Predicate<class_1657> predicate) {
        return EntityRetrievalUtil.findPlayer(level, class_238.method_30048((class_243)origin, (double)radius, (double)radius, (double)radius), predicate);
    }

    public static <T extends class_1657> Optional<T> findPlayer(class_1937 level, class_243 origin, double radiusX, double radiusY, double radiusZ, Predicate<class_1657> predicate) {
        return EntityRetrievalUtil.findPlayer(level, class_238.method_30048((class_243)origin, (double)radiusX, (double)radiusY, (double)radiusZ), predicate);
    }

    public static <T extends class_1657> Optional<T> findPlayer(class_1937 level, class_243 from, class_243 to, Predicate<class_1657> predicate) {
        return EntityRetrievalUtil.findPlayer(level, new class_238(from, to), predicate);
    }

    public static <T extends class_1657> Optional<T> findPlayer(class_1937 level, class_238 bounds, Predicate<class_1657> predicate) {
        for (class_1657 player : level.method_18456()) {
            if (!bounds.method_1006(player.method_19538()) || !predicate.test(player)) continue;
            return Optional.of(player);
        }
        return Optional.empty();
    }

    public static <T extends class_1297> Optional<T> findEntity(class_1297 origin, double radius, Predicate<class_1297> predicate) {
        return EntityRetrievalUtil.findEntity(origin, radius, radius, radius, predicate);
    }

    public static <T extends class_1297> Optional<T> findEntity(class_1297 origin, double radiusX, double radiusY, double radiusZ, Predicate<class_1297> predicate) {
        return EntityRetrievalUtil.findEntity(origin.method_37908(), origin.method_5829().method_1009(radiusX, radiusY, radiusZ), ((Predicate<class_1297>)entity -> entity != origin).and(predicate));
    }

    public static <T extends class_1297> Optional<T> findEntity(class_1937 level, class_243 origin, double radius, Predicate<class_1297> predicate) {
        return EntityRetrievalUtil.findEntity(level, class_238.method_30048((class_243)origin, (double)radius, (double)radius, (double)radius), predicate);
    }

    public static <T extends class_1297> Optional<T> findEntity(class_1937 level, class_243 origin, double radiusX, double radiusY, double radiusZ, Predicate<class_1297> predicate) {
        return EntityRetrievalUtil.findEntity(level, class_238.method_30048((class_243)origin, (double)radiusX, (double)radiusY, (double)radiusZ), predicate);
    }

    public static <T extends class_1297> Optional<T> findEntity(class_1937 level, class_243 from, class_243 to, Predicate<class_1297> predicate) {
        return EntityRetrievalUtil.findEntity(level, new class_238(from, to), predicate);
    }

    public static <T extends class_1297> Optional<T> findEntity(class_1937 level, class_238 bounds, Predicate<class_1297> predicate) {
        return EntityRetrievalUtil.findEntity(level, bounds, class_1297.class, predicate);
    }

    public static <T extends class_1297> Optional<T> findEntity(class_1297 origin, double radius, Class<T> minimumClass, Predicate<T> predicate) {
        return EntityRetrievalUtil.findEntity(origin, radius, radius, radius, minimumClass, predicate);
    }

    public static <T extends class_1297> Optional<T> findEntity(class_1297 origin, double radiusX, double radiusY, double radiusZ, Class<T> minimumClass, Predicate<T> predicate) {
        return EntityRetrievalUtil.findEntity(origin.method_37908(), origin.method_5829().method_1009(radiusX, radiusY, radiusZ), minimumClass, ((Predicate<class_1297>)entity -> entity != origin).and(predicate));
    }

    public static <T extends class_1297> Optional<T> findEntity(class_1937 level, class_243 origin, double radius, Class<T> minimumClass, Predicate<T> predicate) {
        return EntityRetrievalUtil.findEntity(level, class_238.method_30048((class_243)origin, (double)radius, (double)radius, (double)radius), minimumClass, predicate);
    }

    public static <T extends class_1297> Optional<T> findEntity(class_1937 level, class_243 origin, double radiusX, double radiusY, double radiusZ, Class<T> minimumClass, Predicate<T> predicate) {
        return EntityRetrievalUtil.findEntity(level, class_238.method_30048((class_243)origin, (double)radiusX, (double)radiusY, (double)radiusZ), minimumClass, predicate);
    }

    public static <T extends class_1297> Optional<T> findEntity(class_1937 level, class_243 from, class_243 to, Class<T> minimumClass, Predicate<T> predicate) {
        return EntityRetrievalUtil.findEntity(level, new class_238(from, to), minimumClass, predicate);
    }

    public static <T extends class_1297> Optional<T> findEntity(class_1937 level, class_238 bounds, Class<T> minimumClass, Predicate<T> predicate) {
        AtomicReference<Object> foundEntity = new AtomicReference<Object>(null);
        class_5575<class_1297, T> typeTest = EntityRetrievalUtil.makeLazyTypeTest(minimumClass);
        level.method_31592().method_31805(typeTest, bounds, entity -> {
            if (predicate.test((class_1297)entity)) {
                foundEntity.set(entity);
                return class_7927.class_7928.field_41284;
            }
            return class_7927.class_7928.field_41283;
        });
        if (foundEntity.get() == null) {
            Pair<Collection<? extends class_1297>, Function<class_1297, ? extends class_1297>> partEntities = SBLConstants.SBL_LOADER.getPartEntities(level);
            for (class_1297 part : (Collection)partEntities.getFirst()) {
                class_1297 entity2 = (class_1297)typeTest.method_31796((Object)((class_1297)((Function)partEntities.getSecond()).apply(part)));
                if (entity2 == null || !part.method_5829().method_994(bounds) || !predicate.test(entity2)) continue;
                foundEntity.set(entity2);
                break;
            }
        }
        return Optional.ofNullable(foundEntity.get());
    }

    public static <T extends class_1297> List<T> findEntities(class_1297 origin, double radius, int max, Predicate<class_1297> predicate) {
        return EntityRetrievalUtil.findEntities(origin, radius, radius, radius, max, predicate);
    }

    public static <T extends class_1297> List<T> findEntities(class_1297 origin, double radiusX, double radiusY, double radiusZ, int max, Predicate<class_1297> predicate) {
        return EntityRetrievalUtil.findEntities(origin.method_37908(), origin.method_5829().method_1009(radiusX, radiusY, radiusZ), class_1297.class, max, ((Predicate<class_1297>)entity -> entity != origin).and(predicate));
    }

    public static <T extends class_1297> List<T> findEntities(class_1937 level, class_243 origin, double radius, int max, Predicate<class_1297> predicate) {
        return EntityRetrievalUtil.findEntities(level, origin, radius, radius, radius, max, predicate);
    }

    public static <T extends class_1297> List<T> findEntities(class_1937 level, class_243 origin, double radiusX, double radiusY, double radiusZ, int max, Predicate<class_1297> predicate) {
        return EntityRetrievalUtil.findEntities(level, class_238.method_30048((class_243)origin, (double)radiusX, (double)radiusY, (double)radiusZ), class_1297.class, max, predicate);
    }

    public static <T extends class_1297> List<T> findEntities(class_1937 level, class_243 from, class_243 to, int max, Predicate<class_1297> predicate) {
        return EntityRetrievalUtil.findEntities(level, new class_238(from, to), class_1297.class, max, predicate);
    }

    public static <T extends class_1297> List<T> findEntities(class_1297 origin, double radius, Class<T> minimumClass, int max, Predicate<? super T> predicate) {
        return EntityRetrievalUtil.findEntities(origin, radius, radius, radius, minimumClass, max, predicate);
    }

    public static <T extends class_1297> List<T> findEntities(class_1297 origin, double radiusX, double radiusY, double radiusZ, Class<T> minimumClass, int max, Predicate<? super T> predicate) {
        return EntityRetrievalUtil.findEntities(origin.method_37908(), origin.method_5829().method_1009(radiusX, radiusY, radiusZ), minimumClass, max, ((Predicate<class_1297>)entity -> entity != origin).and(predicate));
    }

    public static <T extends class_1297> List<T> findEntities(class_1937 level, class_243 origin, double radius, Class<T> minimumClass, int max, Predicate<? super T> predicate) {
        return EntityRetrievalUtil.findEntities(level, class_238.method_30048((class_243)origin, (double)radius, (double)radius, (double)radius), minimumClass, max, predicate);
    }

    public static <T extends class_1297> List<T> findEntities(class_1937 level, class_243 origin, double radiusX, double radiusY, double radiusZ, Class<T> minimumClass, int max, Predicate<? super T> predicate) {
        return EntityRetrievalUtil.findEntities(level, class_238.method_30048((class_243)origin, (double)radiusX, (double)radiusY, (double)radiusZ), minimumClass, max, predicate);
    }

    public static <T extends class_1297> List<T> findEntities(class_1937 level, class_243 from, class_243 to, Class<T> minimumClass, int max, Predicate<? super T> predicate) {
        return EntityRetrievalUtil.findEntities(level, new class_238(from, to), minimumClass, max, predicate);
    }

    public static <T extends class_1297> List<T> findEntities(class_1937 level, class_238 bounds, Class<T> minimumClass, int max, Predicate<? super T> predicate) {
        ObjectArrayList foundEntities = new ObjectArrayList(max);
        class_5575<class_1297, T> typeTest = EntityRetrievalUtil.makeLazyTypeTest(minimumClass);
        level.method_31592().method_31805(typeTest, bounds, arg_0 -> EntityRetrievalUtil.lambda$findEntities$24(predicate, (List)foundEntities, max, arg_0));
        if (foundEntities.size() < max) {
            Pair<Collection<? extends class_1297>, Function<class_1297, ? extends class_1297>> partEntities = SBLConstants.SBL_LOADER.getPartEntities(level);
            for (class_1297 part : (Collection)partEntities.getFirst()) {
                class_1297 entity = (class_1297)typeTest.method_31796((Object)((class_1297)((Function)partEntities.getSecond()).apply(part)));
                if (entity == null || !part.method_5829().method_994(bounds) || !predicate.test(entity)) continue;
                foundEntities.add(entity);
                if (foundEntities.size() < max) continue;
                break;
            }
        }
        return foundEntities;
    }

    public static Stream<class_1297> streamEntities(class_1297 origin, double radius) {
        return EntityRetrievalUtil.streamEntities(origin, radius, radius, radius);
    }

    public static Stream<class_1297> streamEntities(class_1297 origin, double radiusX, double radiusY, double radiusZ) {
        return EntityRetrievalUtil.streamEntities(origin.method_37908(), origin.method_5829().method_1009(radiusX, radiusY, radiusZ), class_1297.class);
    }

    public static Stream<class_1297> streamEntities(class_1937 level, class_243 origin, double radius) {
        return EntityRetrievalUtil.streamEntities(level, origin, radius, radius, radius);
    }

    public static Stream<class_1297> streamEntities(class_1937 level, class_243 origin, double radiusX, double radiusY, double radiusZ) {
        return EntityRetrievalUtil.streamEntities(level, class_238.method_30048((class_243)origin, (double)radiusX, (double)radiusY, (double)radiusZ), class_1297.class);
    }

    public static Stream<class_1297> streamEntities(class_1937 level, class_243 fromPos, class_243 toPos) {
        return EntityRetrievalUtil.streamEntities(level, new class_238(fromPos, toPos), class_1297.class);
    }

    public static <T extends class_1297> Stream<T> streamEntities(class_1297 origin, double radius, Class<T> minimumClass) {
        return EntityRetrievalUtil.streamEntities(origin, radius, radius, radius, minimumClass);
    }

    public static <T extends class_1297> Stream<T> streamEntities(class_1297 origin, double radiusX, double radiusY, double radiusZ, Class<T> minimumClass) {
        return EntityRetrievalUtil.streamEntities(origin.method_37908(), origin.method_5829().method_1009(radiusX, radiusY, radiusZ), minimumClass);
    }

    public static <T extends class_1297> Stream<T> streamEntities(class_1937 level, class_243 origin, double radius, Class<T> minimumClass) {
        return EntityRetrievalUtil.streamEntities(level, origin, radius, radius, radius, minimumClass);
    }

    public static <T extends class_1297> Stream<T> streamEntities(class_1937 level, class_243 origin, double radiusX, double radiusY, double radiusZ, Class<T> minimumClass) {
        return EntityRetrievalUtil.streamEntities(level, class_238.method_30048((class_243)origin, (double)radiusX, (double)radiusY, (double)radiusZ), minimumClass);
    }

    public static <T extends class_1297> Stream<T> streamEntities(class_1937 level, class_243 fromPos, class_243 toPos, Class<T> minimumClass) {
        return EntityRetrievalUtil.streamEntities(level, new class_238(fromPos, toPos), minimumClass);
    }

    public static <T extends class_1297> Stream<T> streamEntities(class_1937 level, class_238 bounds, Class<T> minimumClass) {
        level.method_16107().method_39278("getEntities");
        class_5577 class_55772 = level.method_31592();
        if (!(class_55772 instanceof class_5578)) {
            return (minimumClass == class_1297.class ? EntityRetrievalUtil.getEntities(level, bounds, (? extends class_1297 entity) -> true) : EntityRetrievalUtil.getEntities(level, bounds, minimumClass, (T entity) -> true)).stream();
        }
        class_5578 entities = (class_5578)class_55772;
        class_5573 entitySectionStorage = entities.field_27259;
        class_5575 clazzLookup = EntityRetrievalUtil.makeLazyTypeTest(minimumClass);
        int minSectionX = class_4076.method_32204((double)(bounds.field_1323 - 2.0));
        int minSectionY = class_4076.method_32204((double)(bounds.field_1322 - 4.0));
        int minSectionZ = class_4076.method_32204((double)(bounds.field_1321 - 2.0));
        int maxSectionX = class_4076.method_32204((double)(bounds.field_1320 + 2.0));
        int maxSectionY = class_4076.method_32204((double)bounds.field_1325);
        int maxSectionZ = class_4076.method_32204((double)(bounds.field_1324 + 2.0));
        Pair<Collection<? extends class_1297>, Function<class_1297, ? extends class_1297>> partEntities = SBLConstants.SBL_LOADER.getPartEntities(level);
        Stream<class_1297> stream = IntStream.rangeClosed(minSectionX, maxSectionX).mapToObj(sectionX -> entitySectionStorage.field_27253.subSet(class_4076.method_18685((int)sectionX, (int)0, (int)0), class_4076.method_18685((int)sectionX, (int)-1, (int)-1)).iterator()).mapMulti((iterator, consumer) -> consumer.accept(iterator.nextLong())).filter(sectionId -> {
            int sectionYPos = class_4076.method_18689((long)sectionId);
            if (sectionYPos < minSectionY || sectionYPos > maxSectionY) {
                return false;
            }
            int sectionZPos = class_4076.method_18690((long)sectionId);
            return sectionZPos >= minSectionZ && sectionZPos <= maxSectionZ;
        }).map(arg_0 -> ((class_5573)entitySectionStorage).method_31785(arg_0)).filter(section -> section != null && !section.method_31761() && section.method_31768().method_31885()).map(section -> section.field_27248.method_15216(clazzLookup.method_31794())).filter(collection -> !collection.isEmpty()).mapMulti(Iterable::forEach).map(arg_0 -> clazzLookup.method_31796(arg_0)).filter(entity -> entity != null && entity.method_5829().method_994(bounds));
        return ((Collection)partEntities.getFirst()).isEmpty() ? stream : Stream.concat(stream, ((Collection)partEntities.getFirst()).stream().map(entity -> Pair.of((Object)entity, (Object)((class_1297)clazzLookup.method_31796((Object)((class_1297)((Function)partEntities.getSecond()).apply(entity)))))).filter(entity -> ((class_1297)entity.getFirst()).method_5829().method_994(bounds)).map(Pair::getSecond));
    }

    @ApiStatus.Internal
    private static <T extends class_1297> class_5575<class_1297, T> makeLazyTypeTest(Class<T> forClass) {
        if (forClass != class_1297.class) {
            return class_5575.method_31795(forClass);
        }
        return new class_5575<class_1297, class_1297>(){

            @Nullable
            public class_1297 tryCast(class_1297 entity) {
                return entity;
            }

            public Class<? extends class_1297> method_31794() {
                return class_1297.class;
            }
        };
    }

    private static /* synthetic */ class_7927.class_7928 lambda$findEntities$24(Predicate predicate, List foundEntities, int max, class_1297 entity) {
        if (predicate.test(entity)) {
            foundEntities.add(entity);
            if (foundEntities.size() >= max) {
                return class_7927.class_7928.field_41284;
            }
        }
        return class_7927.class_7928.field_41283;
    }

    private static /* synthetic */ class_7927.class_7928 lambda$getEntities$17(Predicate predicate, List foundEntities, class_1297 entity) {
        if (predicate.test(entity)) {
            foundEntities.add(entity);
        }
        return class_7927.class_7928.field_41283;
    }
}

