/*
 * Decompiled with CFR 0.152.
 */
package haage.config;

import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.annotation.ConfigEntry;

@Config(name="locator-heads")
public class LocatorHeadsConfig
implements ConfigData {
    @ConfigEntry.Category(value="general")
    @ConfigEntry.Gui.Tooltip(count=1)
    public boolean enableMod = true;
    @ConfigEntry.Category(value="general")
    @ConfigEntry.Gui.Tooltip(count=1)
    public boolean renderHeads = true;
    @ConfigEntry.Category(value="general")
    @ConfigEntry.Gui.Tooltip(count=1)
    public boolean alwaysShowXP = false;
    @ConfigEntry.Category(value="compass")
    @ConfigEntry.Gui.Tooltip(count=1)
    public boolean showCompass = false;
    @ConfigEntry.Category(value="compass")
    @ConfigEntry.Gui.Tooltip(count=1)
    @ConfigEntry.ColorPicker
    public int compassColor = 0xFFFFFF;
    @ConfigEntry.Category(value="compass")
    @ConfigEntry.Gui.Tooltip(count=1)
    public boolean compassShadow = true;
    @ConfigEntry.Category(value="borders")
    @ConfigEntry.Gui.Tooltip(count=1)
    public boolean enableTeamBorder = false;
    @ConfigEntry.Category(value="borders")
    @ConfigEntry.Gui.Tooltip(count=1)
    @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
    public BorderThickness teamBorderThickness = BorderThickness.NORMAL;
    @ConfigEntry.Category(value="borders")
    @ConfigEntry.Gui.Tooltip(count=1)
    @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
    public BorderStyle borderStyle = BorderStyle.TEAM_COLOR;
    @ConfigEntry.Category(value="borders")
    @ConfigEntry.Gui.Tooltip(count=1)
    @ConfigEntry.ColorPicker
    public int staticBorderColor = 0xFFFFFF;
    @ConfigEntry.Category(value="general")
    @ConfigEntry.BoundedDiscrete(min=1L, max=9L)
    public int headSizeMultiplier = 5;
    @ConfigEntry.Category(value="general")
    @ConfigEntry.Gui.Tooltip(count=1)
    @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
    public NameDisplayMode showPlayerNames = NameDisplayMode.OFF;
    @ConfigEntry.Category(value="playerFiltering")
    @ConfigEntry.Gui.Tooltip(count=1)
    @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
    public PlayerFilterMode playerFilterMode = PlayerFilterMode.ALL;
    @ConfigEntry.Category(value="playerFiltering")
    @ConfigEntry.Gui.Tooltip(count=1)
    public String includedPlayers = "";
    @ConfigEntry.Category(value="playerFiltering")
    @ConfigEntry.Gui.Tooltip(count=1)
    public String excludedPlayers = "";

    public double getHeadSizeMultiplier() {
        if (this.headSizeMultiplier == 0) {
            return 1.0;
        }
        switch (this.headSizeMultiplier) {
            case 1: {
                return 0.5;
            }
            case 2: {
                return 0.6;
            }
            case 3: {
                return 0.7;
            }
            case 4: {
                return 0.8;
            }
            case 5: {
                return 1.0;
            }
            case 6: {
                return 1.1;
            }
            case 7: {
                return 1.2;
            }
            case 8: {
                return 1.3;
            }
            case 9: {
                return 1.5;
            }
        }
        return 1.0;
    }

    public String getHeadSizeDisplayText() {
        return String.format("%.1fx", this.getHeadSizeMultiplier());
    }

    public static enum BorderThickness {
        THIN(0.3),
        MEDIUM(0.5),
        NORMAL(1.0),
        THICK(2.0);

        private final double value;

        private BorderThickness(double value) {
            this.value = value;
        }

        public double getValue() {
            return this.value;
        }
    }

    public static enum BorderStyle {
        TEAM_COLOR,
        STATIC_COLOR;

    }

    public static enum NameDisplayMode {
        OFF,
        ALWAYS,
        LOOKING_AT,
        PLAYER_LIST;

    }

    public static enum PlayerFilterMode {
        ALL,
        INCLUDE,
        EXCLUDE;

    }
}

