/*
 * Decompiled with CFR 0.152.
 */
package com.github.smallinger.coppergolemlegacy.client.renderer;

import com.github.smallinger.coppergolemlegacy.CopperGolemLegacy;
import com.github.smallinger.coppergolemlegacy.block.CopperGolemStatueBlock;
import com.github.smallinger.coppergolemlegacy.client.model.CopperGolemModel;
import com.github.smallinger.coppergolemlegacy.client.model.CopperGolemStatueModel;
import com.github.smallinger.coppergolemlegacy.entity.CopperGolemOxidationLevels;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;

public class CopperItemRenderer
extends BlockEntityWithoutLevelRenderer {
    private ModelPart chestLid;
    private ModelPart chestBottom;
    private ModelPart chestLock;
    private Map<CopperGolemStatueBlock.Pose, CopperGolemStatueModel> statueModels;
    private boolean initialized = false;
    private static final Material COPPER_CHEST_MATERIAL = CopperItemRenderer.chestMaterial("copper");
    private static final Material EXPOSED_COPPER_CHEST_MATERIAL = CopperItemRenderer.chestMaterial("copper_exposed");
    private static final Material WEATHERED_COPPER_CHEST_MATERIAL = CopperItemRenderer.chestMaterial("copper_weathered");
    private static final Material OXIDIZED_COPPER_CHEST_MATERIAL = CopperItemRenderer.chestMaterial("copper_oxidized");

    public CopperItemRenderer() {
        super(Minecraft.getInstance().getBlockEntityRenderDispatcher(), Minecraft.getInstance().getEntityModels());
    }

    private void ensureInitialized() {
        if (this.initialized) {
            return;
        }
        ModelPart singleChest = Minecraft.getInstance().getEntityModels().bakeLayer(ModelLayers.CHEST);
        this.chestBottom = singleChest.getChild("bottom");
        this.chestLid = singleChest.getChild("lid");
        this.chestLock = singleChest.getChild("lock");
        this.statueModels = new HashMap<CopperGolemStatueBlock.Pose, CopperGolemStatueModel>();
        EntityModelSet modelSet = Minecraft.getInstance().getEntityModels();
        this.statueModels.put(CopperGolemStatueBlock.Pose.STANDING, new CopperGolemStatueModel(modelSet.bakeLayer(CopperGolemModel.STATUE_STANDING)));
        this.statueModels.put(CopperGolemStatueBlock.Pose.RUNNING, new CopperGolemStatueModel(modelSet.bakeLayer(CopperGolemModel.STATUE_RUNNING)));
        this.statueModels.put(CopperGolemStatueBlock.Pose.SITTING, new CopperGolemStatueModel(modelSet.bakeLayer(CopperGolemModel.STATUE_SITTING)));
        this.statueModels.put(CopperGolemStatueBlock.Pose.STAR, new CopperGolemStatueModel(modelSet.bakeLayer(CopperGolemModel.STATUE_STAR)));
        this.initialized = true;
    }

    private static Material chestMaterial(String name) {
        return new Material(Sheets.CHEST_SHEET, ResourceLocation.fromNamespaceAndPath((String)"coppergolemlegacy", (String)("entity/chest/" + name)));
    }

    public void renderByItem(ItemStack stack, ItemDisplayContext displayContext, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        this.ensureInitialized();
        Item item = stack.getItem();
        if (!(item instanceof BlockItem)) {
            return;
        }
        BlockItem blockItem = (BlockItem)item;
        Block block = blockItem.getBlock();
        if (this.isChestBlock(block)) {
            this.renderChestItem(block, poseStack, bufferSource, packedLight, packedOverlay);
        } else if (block instanceof CopperGolemStatueBlock) {
            CopperGolemStatueBlock statueBlock = (CopperGolemStatueBlock)block;
            this.renderStatueItem(statueBlock, poseStack, bufferSource, packedLight, packedOverlay);
        }
    }

    private boolean isChestBlock(Block block) {
        return block == CopperGolemLegacy.COPPER_CHEST.get() || block == CopperGolemLegacy.EXPOSED_COPPER_CHEST.get() || block == CopperGolemLegacy.WEATHERED_COPPER_CHEST.get() || block == CopperGolemLegacy.OXIDIZED_COPPER_CHEST.get() || block == CopperGolemLegacy.WAXED_COPPER_CHEST.get() || block == CopperGolemLegacy.WAXED_EXPOSED_COPPER_CHEST.get() || block == CopperGolemLegacy.WAXED_WEATHERED_COPPER_CHEST.get() || block == CopperGolemLegacy.WAXED_OXIDIZED_COPPER_CHEST.get();
    }

    private void renderChestItem(Block block, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        poseStack.pushPose();
        poseStack.translate(0.5f, 0.5f, 0.5f);
        Material material = this.getChestMaterial(block);
        VertexConsumer vertexConsumer = material.buffer(bufferSource, RenderType::entityCutout);
        float openness = 0.0f;
        this.chestLock.xRot = this.chestLid.xRot = -(openness * 1.5707964f);
        this.chestLid.render(poseStack, vertexConsumer, packedLight, packedOverlay);
        this.chestLock.render(poseStack, vertexConsumer, packedLight, packedOverlay);
        this.chestBottom.render(poseStack, vertexConsumer, packedLight, packedOverlay);
        poseStack.popPose();
    }

    private void renderStatueItem(CopperGolemStatueBlock statueBlock, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        poseStack.pushPose();
        poseStack.translate(0.5f, 0.0f, 0.5f);
        CopperGolemStatueModel model = this.statueModels.get((Object)CopperGolemStatueBlock.Pose.STANDING);
        if (model == null) {
            poseStack.popPose();
            return;
        }
        ResourceLocation texture = CopperGolemOxidationLevels.getOxidationLevel(statueBlock.getWeatheringState()).texture();
        model.setupAnim(Direction.SOUTH);
        RenderType renderType = RenderType.entityCutoutNoCull((ResourceLocation)texture);
        model.renderToBuffer(poseStack, bufferSource.getBuffer(renderType), packedLight, packedOverlay, -1);
        poseStack.popPose();
    }

    private Material getChestMaterial(Block block) {
        if (block == CopperGolemLegacy.COPPER_CHEST.get() || block == CopperGolemLegacy.WAXED_COPPER_CHEST.get()) {
            return COPPER_CHEST_MATERIAL;
        }
        if (block == CopperGolemLegacy.EXPOSED_COPPER_CHEST.get() || block == CopperGolemLegacy.WAXED_EXPOSED_COPPER_CHEST.get()) {
            return EXPOSED_COPPER_CHEST_MATERIAL;
        }
        if (block == CopperGolemLegacy.WEATHERED_COPPER_CHEST.get() || block == CopperGolemLegacy.WAXED_WEATHERED_COPPER_CHEST.get()) {
            return WEATHERED_COPPER_CHEST_MATERIAL;
        }
        if (block == CopperGolemLegacy.OXIDIZED_COPPER_CHEST.get() || block == CopperGolemLegacy.WAXED_OXIDIZED_COPPER_CHEST.get()) {
            return OXIDIZED_COPPER_CHEST_MATERIAL;
        }
        return COPPER_CHEST_MATERIAL;
    }
}

