/*
 * Decompiled with CFR 0.152.
 */
package com.github.smallinger.coppergolemlegacy.block;

import com.github.smallinger.coppergolemlegacy.CopperGolemLegacy;
import com.github.smallinger.coppergolemlegacy.block.WaxedCopperButtonBlock;
import com.github.smallinger.coppergolemlegacy.util.WeatheringHelper;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class CopperButtonBlock
extends ButtonBlock
implements WeatheringCopper {
    private final WeatheringCopper.WeatherState weatherState;
    private Supplier<WaxedCopperButtonBlock> waxedButton;

    public CopperButtonBlock(WeatheringCopper.WeatherState weatherState, BlockBehaviour.Properties properties) {
        super(properties, BlockSetType.f_271132_, 15, true);
        this.weatherState = weatherState;
    }

    public void setWaxedButton(Supplier<WaxedCopperButtonBlock> waxedButton) {
        this.waxedButton = waxedButton;
    }

    public static Optional<Block> getNextBlock(Block block) {
        if (block == CopperGolemLegacy.COPPER_BUTTON.get()) {
            return Optional.of((Block)CopperGolemLegacy.EXPOSED_COPPER_BUTTON.get());
        }
        if (block == CopperGolemLegacy.EXPOSED_COPPER_BUTTON.get()) {
            return Optional.of((Block)CopperGolemLegacy.WEATHERED_COPPER_BUTTON.get());
        }
        if (block == CopperGolemLegacy.WEATHERED_COPPER_BUTTON.get()) {
            return Optional.of((Block)CopperGolemLegacy.OXIDIZED_COPPER_BUTTON.get());
        }
        return WeatheringCopper.m_154904_((Block)block);
    }

    public WeatheringCopper.WeatherState getAge() {
        return this.weatherState;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_150930_(Items.f_42784_) && this.waxedButton != null) {
            level.m_5594_(player, pos, SoundEvents.f_144178_, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.m_5898_(player, 3003, pos, 0);
            if (!level.f_46443_) {
                BlockState waxedState = (BlockState)((BlockState)((BlockState)this.waxedButton.get().m_49966_().m_61124_((Property)f_54117_, (Comparable)((Direction)state.m_61143_((Property)f_54117_)))).m_61124_((Property)f_51045_, (Comparable)((Boolean)state.m_61143_((Property)f_51045_)))).m_61124_((Property)f_53179_, (Comparable)((AttachFace)state.m_61143_((Property)f_53179_)));
                level.m_7731_(pos, waxedState, 11);
                if (player != null && !player.m_7500_()) {
                    stack.m_41774_(1);
                }
            }
            return level.f_46443_ ? InteractionResult.SUCCESS : InteractionResult.CONSUME;
        }
        if (stack.m_204117_(ItemTags.f_271207_)) {
            Block previousBlock = null;
            if (this == CopperGolemLegacy.OXIDIZED_COPPER_BUTTON.get()) {
                previousBlock = (Block)CopperGolemLegacy.WEATHERED_COPPER_BUTTON.get();
            } else if (this == CopperGolemLegacy.WEATHERED_COPPER_BUTTON.get()) {
                previousBlock = (Block)CopperGolemLegacy.EXPOSED_COPPER_BUTTON.get();
            } else if (this == CopperGolemLegacy.EXPOSED_COPPER_BUTTON.get()) {
                previousBlock = (Block)CopperGolemLegacy.COPPER_BUTTON.get();
            }
            if (previousBlock != null) {
                level.m_5594_(player, pos, SoundEvents.f_144059_, SoundSource.BLOCKS, 1.0f, 1.0f);
                level.m_5898_(player, 3005, pos, 0);
                if (!level.f_46443_) {
                    BlockState newState = (BlockState)((BlockState)((BlockState)previousBlock.m_49966_().m_61124_((Property)f_54117_, (Comparable)((Direction)state.m_61143_((Property)f_54117_)))).m_61124_((Property)f_51045_, (Comparable)((Boolean)state.m_61143_((Property)f_51045_)))).m_61124_((Property)f_53179_, (Comparable)((AttachFace)state.m_61143_((Property)f_53179_)));
                    level.m_7731_(pos, newState, 11);
                    if (player != null && !player.m_7500_()) {
                        stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
                    }
                }
                return level.f_46443_ ? InteractionResult.SUCCESS : InteractionResult.CONSUME;
            }
        }
        return InteractionResult.PASS;
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        WeatheringHelper.tryWeather(state, level, pos, random, CopperButtonBlock::getNextBlock);
    }

    public boolean m_6724_(BlockState state) {
        return WeatheringHelper.canWeather(state, CopperButtonBlock::getNextBlock);
    }
}

