/*
 * Decompiled with CFR 0.152.
 */
package com.github.smallinger.coppergolemlegacy.block;

import com.github.smallinger.coppergolemlegacy.CopperGolemLegacy;
import com.github.smallinger.coppergolemlegacy.ModSounds;
import com.github.smallinger.coppergolemlegacy.block.entity.CopperChestBlockEntity;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CopperChestBlock
extends ChestBlock {
    private static final Map<Block, Supplier<Block>> COPPER_TO_COPPER_CHEST_MAPPING = Map.of(Blocks.f_152504_, () -> (Block)CopperGolemLegacy.COPPER_CHEST.get(), Blocks.f_152503_, () -> (Block)CopperGolemLegacy.EXPOSED_COPPER_CHEST.get(), Blocks.f_152502_, () -> (Block)CopperGolemLegacy.WEATHERED_COPPER_CHEST.get(), Blocks.f_152501_, () -> (Block)CopperGolemLegacy.OXIDIZED_COPPER_CHEST.get(), Blocks.f_152571_, () -> (Block)CopperGolemLegacy.COPPER_CHEST.get(), Blocks.f_152573_, () -> (Block)CopperGolemLegacy.EXPOSED_COPPER_CHEST.get(), Blocks.f_152572_, () -> (Block)CopperGolemLegacy.WEATHERED_COPPER_CHEST.get(), Blocks.f_152574_, () -> (Block)CopperGolemLegacy.OXIDIZED_COPPER_CHEST.get());
    protected final WeatheringCopper.WeatherState weatherState;
    private final SoundEvent openSound;
    private final SoundEvent closeSound;

    public CopperChestBlock(WeatheringCopper.WeatherState weatherState, BlockBehaviour.Properties properties) {
        super(properties, () -> (BlockEntityType)CopperGolemLegacy.COPPER_CHEST_BLOCK_ENTITY.get());
        this.weatherState = weatherState;
        this.openSound = (SoundEvent)ModSounds.COPPER_CHEST_OPEN.get();
        this.closeSound = (SoundEvent)ModSounds.COPPER_CHEST_CLOSE.get();
    }

    public WeatheringCopper.WeatherState getState() {
        return this.weatherState;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0);
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0);
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new CopperChestBlockEntity(pos, state);
    }

    public static BlockState getFromCopperBlock(Block block, Direction direction, Level level, BlockPos pos) {
        Block chestBlock = COPPER_TO_COPPER_CHEST_MAPPING.getOrDefault(block, () -> (Block)CopperGolemLegacy.COPPER_CHEST.get()).get();
        return (BlockState)chestBlock.m_49966_().m_61124_((Property)f_51478_, (Comparable)direction);
    }

    public static Optional<Block> getUnwaxedBlock(Block block) {
        if (block == CopperGolemLegacy.WAXED_COPPER_CHEST.get()) {
            return Optional.of((Block)CopperGolemLegacy.COPPER_CHEST.get());
        }
        if (block == CopperGolemLegacy.WAXED_EXPOSED_COPPER_CHEST.get()) {
            return Optional.of((Block)CopperGolemLegacy.EXPOSED_COPPER_CHEST.get());
        }
        if (block == CopperGolemLegacy.WAXED_WEATHERED_COPPER_CHEST.get()) {
            return Optional.of((Block)CopperGolemLegacy.WEATHERED_COPPER_CHEST.get());
        }
        if (block == CopperGolemLegacy.WAXED_OXIDIZED_COPPER_CHEST.get()) {
            return Optional.of((Block)CopperGolemLegacy.OXIDIZED_COPPER_CHEST.get());
        }
        return Optional.empty();
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_204117_(ItemTags.f_271207_)) {
            CopperChestBlockEntity chestEntity;
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof CopperChestBlockEntity && (chestEntity = (CopperChestBlockEntity)blockEntity).isChestOpen()) {
                return InteractionResult.PASS;
            }
            Optional<Block> unwaxedBlock = CopperChestBlock.getUnwaxedBlock(state.m_60734_());
            if (unwaxedBlock.isPresent()) {
                ChestType chestType = (ChestType)state.m_61143_((Property)f_51479_);
                Block newBlock = unwaxedBlock.get();
                if (chestType != ChestType.SINGLE) {
                    Direction connectedDir = ChestBlock.m_51584_((BlockState)state);
                    BlockPos connectedPos = pos.m_121945_(connectedDir);
                    BlockState connectedState = level.m_8055_(connectedPos);
                    if (connectedState.m_60734_() == state.m_60734_()) {
                        level.m_5594_(player, pos, SoundEvents.f_144060_, SoundSource.BLOCKS, 1.0f, 1.0f);
                        level.m_5898_(player, 3004, pos, 0);
                        level.m_5594_(player, connectedPos, SoundEvents.f_144060_, SoundSource.BLOCKS, 1.0f, 1.0f);
                        level.m_5898_(player, 3004, connectedPos, 0);
                    } else {
                        level.m_5594_(player, pos, SoundEvents.f_144060_, SoundSource.BLOCKS, 1.0f, 1.0f);
                        level.m_5898_(player, 3004, pos, 0);
                    }
                } else {
                    level.m_5594_(player, pos, SoundEvents.f_144060_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    level.m_5898_(player, 3004, pos, 0);
                }
                if (!level.f_46443_) {
                    NonNullList<ItemStack> currentItems = CopperChestBlock.copyInventoryAndClear(level, pos);
                    NonNullList<ItemStack> connectedItems = NonNullList.m_122779_();
                    BlockState newState = newBlock.m_152465_(state);
                    if (chestType != ChestType.SINGLE) {
                        Direction connectedDir = ChestBlock.m_51584_((BlockState)state);
                        BlockPos connectedPos = pos.m_121945_(connectedDir);
                        BlockState connectedState = level.m_8055_(connectedPos);
                        if (connectedState.m_60734_() == state.m_60734_()) {
                            BlockState connectedNewState = newBlock.m_152465_(connectedState);
                            connectedItems = CopperChestBlock.copyInventoryAndClear(level, connectedPos);
                            level.m_7731_(pos, newState, 2);
                            level.m_7731_(connectedPos, connectedNewState, 2);
                            level.m_6289_(pos, newBlock);
                            level.m_6289_(connectedPos, newBlock);
                            CopperChestBlock.restoreInventory(level, pos, currentItems);
                            CopperChestBlock.restoreInventory(level, connectedPos, connectedItems);
                        } else {
                            level.m_46597_(pos, newState);
                            CopperChestBlock.restoreInventory(level, pos, currentItems);
                        }
                    } else {
                        level.m_46597_(pos, newState);
                        CopperChestBlock.restoreInventory(level, pos, currentItems);
                    }
                    if (!player.m_7500_()) {
                        stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
                    }
                }
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(state, level, pos, player, hand, hit);
    }

    protected static NonNullList<ItemStack> copyInventoryAndClear(Level level, BlockPos pos) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof Container) {
            Container container = (Container)blockEntity;
            NonNullList items = NonNullList.m_122780_((int)container.m_6643_(), (Object)ItemStack.f_41583_);
            for (int i = 0; i < container.m_6643_(); ++i) {
                items.set(i, (Object)container.m_8020_(i).m_41777_());
            }
            container.m_6211_();
            if (blockEntity instanceof CopperChestBlockEntity) {
                CopperChestBlockEntity chestEntity = (CopperChestBlockEntity)blockEntity;
                chestEntity.m_6596_();
            }
            return items;
        }
        return NonNullList.m_122779_();
    }

    protected static void restoreInventory(Level level, BlockPos pos, NonNullList<ItemStack> items) {
        if (items.isEmpty()) {
            return;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof Container) {
            Container container = (Container)blockEntity;
            for (int i = 0; i < Math.min(container.m_6643_(), items.size()); ++i) {
                container.m_6836_(i, (ItemStack)items.get(i));
            }
            if (blockEntity instanceof CopperChestBlockEntity) {
                CopperChestBlockEntity chestEntity = (CopperChestBlockEntity)blockEntity;
                chestEntity.m_6596_();
            }
        }
    }
}

