/*
 * Decompiled with CFR 0.152.
 */
package com.github.smallinger.coppergolemlegacy.block;

import com.github.smallinger.coppergolemlegacy.CopperGolemLegacy;
import com.github.smallinger.coppergolemlegacy.block.CopperChestBlock;
import com.github.smallinger.coppergolemlegacy.block.entity.CopperChestBlockEntity;
import com.github.smallinger.coppergolemlegacy.util.WeatheringHelper;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class WeatheringCopperChestBlock
extends CopperChestBlock
implements WeatheringCopper {
    public WeatheringCopperChestBlock(WeatheringCopper.WeatherState weatheringState, BlockBehaviour.Properties properties) {
        super(weatheringState, properties);
    }

    public static Optional<Block> getNextBlock(Block block) {
        if (block == CopperGolemLegacy.COPPER_CHEST.get()) {
            return Optional.of((Block)CopperGolemLegacy.EXPOSED_COPPER_CHEST.get());
        }
        if (block == CopperGolemLegacy.EXPOSED_COPPER_CHEST.get()) {
            return Optional.of((Block)CopperGolemLegacy.WEATHERED_COPPER_CHEST.get());
        }
        if (block == CopperGolemLegacy.WEATHERED_COPPER_CHEST.get()) {
            return Optional.of((Block)CopperGolemLegacy.OXIDIZED_COPPER_CHEST.get());
        }
        return WeatheringCopper.m_154904_((Block)block);
    }

    public static Optional<Block> getPreviousBlock(Block block) {
        if (block == CopperGolemLegacy.OXIDIZED_COPPER_CHEST.get()) {
            return Optional.of((Block)CopperGolemLegacy.WEATHERED_COPPER_CHEST.get());
        }
        if (block == CopperGolemLegacy.WEATHERED_COPPER_CHEST.get()) {
            return Optional.of((Block)CopperGolemLegacy.EXPOSED_COPPER_CHEST.get());
        }
        if (block == CopperGolemLegacy.EXPOSED_COPPER_CHEST.get()) {
            return Optional.of((Block)CopperGolemLegacy.COPPER_CHEST.get());
        }
        return Optional.empty();
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_204117_(ItemTags.f_271207_)) {
            CopperChestBlockEntity chestEntity;
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof CopperChestBlockEntity && (chestEntity = (CopperChestBlockEntity)blockEntity).isChestOpen()) {
                return InteractionResult.PASS;
            }
            Optional<Block> previousBlock = WeatheringCopperChestBlock.getPreviousBlock(state.m_60734_());
            if (previousBlock.isPresent()) {
                ChestType chestType = (ChestType)state.m_61143_((Property)f_51479_);
                Block newBlock = previousBlock.get();
                if (chestType != ChestType.SINGLE) {
                    Direction connectedDir = ChestBlock.m_51584_((BlockState)state);
                    BlockPos connectedPos = pos.m_121945_(connectedDir);
                    BlockState connectedState = level.m_8055_(connectedPos);
                    if (connectedState.m_60734_() == state.m_60734_()) {
                        level.m_5594_(player, pos, SoundEvents.f_144059_, SoundSource.BLOCKS, 1.0f, 1.0f);
                        level.m_5898_(player, 3005, pos, 0);
                        level.m_5594_(player, connectedPos, SoundEvents.f_144059_, SoundSource.BLOCKS, 1.0f, 1.0f);
                        level.m_5898_(player, 3005, connectedPos, 0);
                    } else {
                        level.m_5594_(player, pos, SoundEvents.f_144059_, SoundSource.BLOCKS, 1.0f, 1.0f);
                        level.m_5898_(player, 3005, pos, 0);
                    }
                } else {
                    level.m_5594_(player, pos, SoundEvents.f_144059_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    level.m_5898_(player, 3005, pos, 0);
                }
                if (!level.f_46443_) {
                    NonNullList<ItemStack> currentItems = WeatheringCopperChestBlock.copyInventoryAndClear(level, pos);
                    NonNullList<ItemStack> connectedItems = NonNullList.m_122779_();
                    BlockState newState = newBlock.m_152465_(state);
                    if (chestType != ChestType.SINGLE) {
                        Direction connectedDir = ChestBlock.m_51584_((BlockState)state);
                        BlockPos connectedPos = pos.m_121945_(connectedDir);
                        BlockState connectedState = level.m_8055_(connectedPos);
                        if (connectedState.m_60734_() == state.m_60734_()) {
                            BlockState connectedNewState = newBlock.m_152465_(connectedState);
                            connectedItems = WeatheringCopperChestBlock.copyInventoryAndClear(level, connectedPos);
                            level.m_7731_(pos, newState, 2);
                            level.m_7731_(connectedPos, connectedNewState, 2);
                            level.m_6289_(pos, newBlock);
                            level.m_6289_(connectedPos, newBlock);
                            WeatheringCopperChestBlock.restoreInventory(level, pos, currentItems);
                            WeatheringCopperChestBlock.restoreInventory(level, connectedPos, connectedItems);
                            if (!player.m_7500_()) {
                                stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
                                stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
                            }
                        } else {
                            level.m_46597_(pos, newState);
                            WeatheringCopperChestBlock.restoreInventory(level, pos, currentItems);
                            if (!player.m_7500_()) {
                                stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
                            }
                        }
                    } else {
                        level.m_46597_(pos, newState);
                        WeatheringCopperChestBlock.restoreInventory(level, pos, currentItems);
                        if (!player.m_7500_()) {
                            stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
                        }
                    }
                }
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }
        if (stack.m_150930_(Items.f_42784_)) {
            CopperChestBlockEntity chestEntity;
            BlockEntity chestType = level.m_7702_(pos);
            if (chestType instanceof CopperChestBlockEntity && (chestEntity = (CopperChestBlockEntity)chestType).isChestOpen()) {
                return InteractionResult.PASS;
            }
            Block waxedBlock = null;
            if (this == CopperGolemLegacy.COPPER_CHEST.get()) {
                waxedBlock = (Block)CopperGolemLegacy.WAXED_COPPER_CHEST.get();
            } else if (this == CopperGolemLegacy.EXPOSED_COPPER_CHEST.get()) {
                waxedBlock = (Block)CopperGolemLegacy.WAXED_EXPOSED_COPPER_CHEST.get();
            } else if (this == CopperGolemLegacy.WEATHERED_COPPER_CHEST.get()) {
                waxedBlock = (Block)CopperGolemLegacy.WAXED_WEATHERED_COPPER_CHEST.get();
            } else if (this == CopperGolemLegacy.OXIDIZED_COPPER_CHEST.get()) {
                waxedBlock = (Block)CopperGolemLegacy.WAXED_OXIDIZED_COPPER_CHEST.get();
            }
            if (waxedBlock != null) {
                chestType = (ChestType)state.m_61143_((Property)f_51479_);
                if (chestType != ChestType.SINGLE) {
                    Direction connectedDir = ChestBlock.m_51584_((BlockState)state);
                    BlockPos connectedPos = pos.m_121945_(connectedDir);
                    BlockState connectedState = level.m_8055_(connectedPos);
                    if (connectedState.m_60734_() == state.m_60734_()) {
                        level.m_5594_(player, pos, SoundEvents.f_144178_, SoundSource.BLOCKS, 1.0f, 1.0f);
                        level.m_5898_(player, 3003, pos, 0);
                        level.m_5594_(player, connectedPos, SoundEvents.f_144178_, SoundSource.BLOCKS, 1.0f, 1.0f);
                        level.m_5898_(player, 3003, connectedPos, 0);
                    } else {
                        level.m_5594_(player, pos, SoundEvents.f_144178_, SoundSource.BLOCKS, 1.0f, 1.0f);
                        level.m_5898_(player, 3003, pos, 0);
                    }
                } else {
                    level.m_5594_(player, pos, SoundEvents.f_144178_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    level.m_5898_(player, 3003, pos, 0);
                }
                if (!level.f_46443_) {
                    NonNullList<ItemStack> currentItems = WeatheringCopperChestBlock.copyInventoryAndClear(level, pos);
                    NonNullList<ItemStack> connectedItems = NonNullList.m_122779_();
                    BlockState waxedState = waxedBlock.m_152465_(state);
                    if (chestType != ChestType.SINGLE) {
                        Direction connectedDir = ChestBlock.m_51584_((BlockState)state);
                        BlockPos connectedPos = pos.m_121945_(connectedDir);
                        BlockState connectedState = level.m_8055_(connectedPos);
                        if (connectedState.m_60734_() == state.m_60734_()) {
                            BlockState connectedWaxedState = waxedBlock.m_152465_(connectedState);
                            connectedItems = WeatheringCopperChestBlock.copyInventoryAndClear(level, connectedPos);
                            level.m_7731_(pos, waxedState, 2);
                            level.m_7731_(connectedPos, connectedWaxedState, 2);
                            level.m_6289_(pos, waxedBlock);
                            level.m_6289_(connectedPos, waxedBlock);
                            WeatheringCopperChestBlock.restoreInventory(level, pos, currentItems);
                            WeatheringCopperChestBlock.restoreInventory(level, connectedPos, connectedItems);
                        } else {
                            level.m_46597_(pos, waxedState);
                            WeatheringCopperChestBlock.restoreInventory(level, pos, currentItems);
                        }
                    } else {
                        level.m_46597_(pos, waxedState);
                        WeatheringCopperChestBlock.restoreInventory(level, pos, currentItems);
                    }
                    if (!player.m_7500_()) {
                        stack.m_41774_(1);
                    }
                }
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }
        return super.m_6227_(state, level, pos, player, hand, hit);
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        ChestType chestType = (ChestType)state.m_61143_((Property)f_51479_);
        if (!chestType.equals((Object)ChestType.RIGHT)) {
            CopperChestBlockEntity chestEntity;
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof CopperChestBlockEntity && (chestEntity = (CopperChestBlockEntity)blockEntity).isChestOpen()) {
                return;
            }
            Optional<Block> nextBlock = WeatheringCopperChestBlock.getNextBlock(state.m_60734_());
            if (nextBlock.isPresent() && random.m_188501_() < 0.05688889f) {
                Direction connectedDir;
                BlockPos otherPos;
                BlockState otherState;
                Block newBlock = nextBlock.get();
                if (chestType != ChestType.SINGLE && newBlock instanceof WeatheringCopperChestBlock && (otherState = level.m_8055_(otherPos = pos.m_121945_(connectedDir = ChestBlock.m_51584_((BlockState)state)))).m_60734_() == state.m_60734_()) {
                    CopperChestBlockEntity otherChestEntity;
                    BlockEntity blockEntity2 = level.m_7702_(otherPos);
                    if (blockEntity2 instanceof CopperChestBlockEntity && (otherChestEntity = (CopperChestBlockEntity)blockEntity2).isChestOpen()) {
                        return;
                    }
                    NonNullList<ItemStack> thisItems = WeatheringCopperChestBlock.copyInventoryAndClear((Level)level, pos);
                    NonNullList<ItemStack> otherItems = WeatheringCopperChestBlock.copyInventoryAndClear((Level)level, otherPos);
                    BlockState newState = newBlock.m_152465_(state);
                    BlockState newOtherState = newBlock.m_152465_(otherState);
                    level.m_7731_(pos, newState, 2);
                    level.m_7731_(otherPos, newOtherState, 2);
                    WeatheringCopperChestBlock.restoreInventory((Level)level, pos, thisItems);
                    WeatheringCopperChestBlock.restoreInventory((Level)level, otherPos, otherItems);
                    level.m_6289_(pos, newBlock);
                    level.m_6289_(otherPos, newBlock);
                    return;
                }
                NonNullList<ItemStack> currentItems = WeatheringCopperChestBlock.copyInventoryAndClear((Level)level, pos);
                BlockState newState = newBlock.m_152465_(state);
                level.m_7731_(pos, newState, 2);
                WeatheringCopperChestBlock.restoreInventory((Level)level, pos, currentItems);
                level.m_6289_(pos, newBlock);
            }
        }
    }

    public boolean m_6724_(BlockState state) {
        return WeatheringHelper.canWeather(state, WeatheringCopperChestBlock::getNextBlock);
    }

    public WeatheringCopper.WeatherState getAge() {
        return this.weatherState;
    }
}

