/*
 * Decompiled with CFR 0.152.
 */
package com.github.smallinger.coppergolemlegacy.client.renderer;

import com.github.smallinger.coppergolemlegacy.CopperGolemLegacy;
import com.github.smallinger.coppergolemlegacy.block.CopperChestBlock;
import com.github.smallinger.coppergolemlegacy.block.WeatheringCopperChestBlock;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import it.unimi.dsi.fastutil.floats.Float2FloatFunction;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.BrightnessCombiner;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.DoubleBlockCombiner;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.entity.LidBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;

public class CopperChestRenderer
implements BlockEntityRenderer<ChestBlockEntity> {
    private static final Material COPPER_CHEST_MATERIAL = CopperChestRenderer.chestMaterial("copper");
    private static final Material COPPER_CHEST_LEFT_MATERIAL = CopperChestRenderer.chestMaterial("copper_left");
    private static final Material COPPER_CHEST_RIGHT_MATERIAL = CopperChestRenderer.chestMaterial("copper_right");
    private static final Material EXPOSED_COPPER_CHEST_MATERIAL = CopperChestRenderer.chestMaterial("copper_exposed");
    private static final Material EXPOSED_COPPER_CHEST_LEFT_MATERIAL = CopperChestRenderer.chestMaterial("copper_exposed_left");
    private static final Material EXPOSED_COPPER_CHEST_RIGHT_MATERIAL = CopperChestRenderer.chestMaterial("copper_exposed_right");
    private static final Material WEATHERED_COPPER_CHEST_MATERIAL = CopperChestRenderer.chestMaterial("copper_weathered");
    private static final Material WEATHERED_COPPER_CHEST_LEFT_MATERIAL = CopperChestRenderer.chestMaterial("copper_weathered_left");
    private static final Material WEATHERED_COPPER_CHEST_RIGHT_MATERIAL = CopperChestRenderer.chestMaterial("copper_weathered_right");
    private static final Material OXIDIZED_COPPER_CHEST_MATERIAL = CopperChestRenderer.chestMaterial("copper_oxidized");
    private static final Material OXIDIZED_COPPER_CHEST_LEFT_MATERIAL = CopperChestRenderer.chestMaterial("copper_oxidized_left");
    private static final Material OXIDIZED_COPPER_CHEST_RIGHT_MATERIAL = CopperChestRenderer.chestMaterial("copper_oxidized_right");
    private final ModelPart lid;
    private final ModelPart bottom;
    private final ModelPart lock;
    private final ModelPart doubleLeftLid;
    private final ModelPart doubleLeftBottom;
    private final ModelPart doubleLeftLock;
    private final ModelPart doubleRightLid;
    private final ModelPart doubleRightBottom;
    private final ModelPart doubleRightLock;

    public CopperChestRenderer(BlockEntityRendererProvider.Context context) {
        ModelPart singleChest = context.m_173582_(ModelLayers.f_171275_);
        this.bottom = singleChest.m_171324_("bottom");
        this.lid = singleChest.m_171324_("lid");
        this.lock = singleChest.m_171324_("lock");
        ModelPart doubleChestLeft = context.m_173582_(ModelLayers.f_171133_);
        this.doubleLeftBottom = doubleChestLeft.m_171324_("bottom");
        this.doubleLeftLid = doubleChestLeft.m_171324_("lid");
        this.doubleLeftLock = doubleChestLeft.m_171324_("lock");
        ModelPart doubleChestRight = context.m_173582_(ModelLayers.f_171134_);
        this.doubleRightBottom = doubleChestRight.m_171324_("bottom");
        this.doubleRightLid = doubleChestRight.m_171324_("lid");
        this.doubleRightLock = doubleChestRight.m_171324_("lock");
    }

    private static Material chestMaterial(String name) {
        return new Material(Sheets.f_110740_, new ResourceLocation("coppergolemlegacy", "entity/chest/" + name));
    }

    public void render(ChestBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        Level level = blockEntity.m_58904_();
        boolean flag = level != null;
        BlockState blockstate = flag ? blockEntity.m_58900_() : (BlockState)((WeatheringCopperChestBlock)((Object)CopperGolemLegacy.COPPER_CHEST.get())).m_49966_().m_61124_((Property)ChestBlock.f_51478_, (Comparable)Direction.SOUTH);
        Block block = blockstate.m_60734_();
        if (block instanceof CopperChestBlock) {
            CopperChestBlock copperChestBlock = (CopperChestBlock)block;
            poseStack.m_85836_();
            float f = ((Direction)blockstate.m_61143_((Property)ChestBlock.f_51478_)).m_122435_();
            poseStack.m_252880_(0.5f, 0.5f, 0.5f);
            poseStack.m_252781_(Axis.f_252436_.m_252977_(-f));
            poseStack.m_252880_(-0.5f, -0.5f, -0.5f);
            DoubleBlockCombiner.NeighborCombineResult result = flag ? copperChestBlock.m_5641_(blockstate, level, blockEntity.m_58899_(), true) : DoubleBlockCombiner.Combiner::m_6502_;
            float openness = ((Float2FloatFunction)result.m_5649_(ChestBlock.m_51517_((LidBlockEntity)blockEntity))).get(partialTick);
            openness = 1.0f - openness;
            openness = 1.0f - openness * openness * openness;
            int light = ((Int2IntFunction)result.m_5649_((DoubleBlockCombiner.Combiner)new BrightnessCombiner())).applyAsInt(packedLight);
            ChestType chestType = blockstate.m_61138_((Property)ChestBlock.f_51479_) ? (ChestType)blockstate.m_61143_((Property)ChestBlock.f_51479_) : ChestType.SINGLE;
            Material material = this.getMaterial(blockstate, chestType);
            VertexConsumer vertexconsumer = material.m_119194_(bufferSource, RenderType::m_110452_);
            if (chestType == ChestType.LEFT) {
                this.renderParts(poseStack, vertexconsumer, this.doubleLeftLid, this.doubleLeftLock, this.doubleLeftBottom, openness, light, packedOverlay);
            } else if (chestType == ChestType.RIGHT) {
                this.renderParts(poseStack, vertexconsumer, this.doubleRightLid, this.doubleRightLock, this.doubleRightBottom, openness, light, packedOverlay);
            } else {
                this.renderParts(poseStack, vertexconsumer, this.lid, this.lock, this.bottom, openness, light, packedOverlay);
            }
            poseStack.m_85849_();
        }
    }

    private void renderParts(PoseStack poseStack, VertexConsumer consumer, ModelPart lid, ModelPart lock, ModelPart bottom, float openness, int light, int overlay) {
        lock.f_104203_ = lid.f_104203_ = -(openness * 1.5707964f);
        lid.m_104301_(poseStack, consumer, light, overlay);
        lock.m_104301_(poseStack, consumer, light, overlay);
        bottom.m_104301_(poseStack, consumer, light, overlay);
    }

    private Material getMaterial(BlockState state, ChestType chestType) {
        Block block = state.m_60734_();
        if (block == CopperGolemLegacy.COPPER_CHEST.get() || block == CopperGolemLegacy.WAXED_COPPER_CHEST.get()) {
            return switch (chestType) {
                case ChestType.LEFT -> COPPER_CHEST_LEFT_MATERIAL;
                case ChestType.RIGHT -> COPPER_CHEST_RIGHT_MATERIAL;
                default -> COPPER_CHEST_MATERIAL;
            };
        }
        if (block == CopperGolemLegacy.EXPOSED_COPPER_CHEST.get() || block == CopperGolemLegacy.WAXED_EXPOSED_COPPER_CHEST.get()) {
            return switch (chestType) {
                case ChestType.LEFT -> EXPOSED_COPPER_CHEST_LEFT_MATERIAL;
                case ChestType.RIGHT -> EXPOSED_COPPER_CHEST_RIGHT_MATERIAL;
                default -> EXPOSED_COPPER_CHEST_MATERIAL;
            };
        }
        if (block == CopperGolemLegacy.WEATHERED_COPPER_CHEST.get() || block == CopperGolemLegacy.WAXED_WEATHERED_COPPER_CHEST.get()) {
            return switch (chestType) {
                case ChestType.LEFT -> WEATHERED_COPPER_CHEST_LEFT_MATERIAL;
                case ChestType.RIGHT -> WEATHERED_COPPER_CHEST_RIGHT_MATERIAL;
                default -> WEATHERED_COPPER_CHEST_MATERIAL;
            };
        }
        if (block == CopperGolemLegacy.OXIDIZED_COPPER_CHEST.get() || block == CopperGolemLegacy.WAXED_OXIDIZED_COPPER_CHEST.get()) {
            return switch (chestType) {
                case ChestType.LEFT -> OXIDIZED_COPPER_CHEST_LEFT_MATERIAL;
                case ChestType.RIGHT -> OXIDIZED_COPPER_CHEST_RIGHT_MATERIAL;
                default -> OXIDIZED_COPPER_CHEST_MATERIAL;
            };
        }
        return Sheets.f_110751_;
    }
}

