/*
 * Decompiled with CFR 0.152.
 */
package com.github.smallinger.coppergolemlegacy.entity.ai.behavior;

import com.github.smallinger.coppergolemlegacy.ModMemoryTypes;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.behavior.BlockPosTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class TransportItemsBetweenContainers
extends Behavior<PathfinderMob> {
    public static final int TARGET_INTERACTION_TIME = 60;
    private static final int VISITED_POSITIONS_MEMORY_TIME = 6000;
    private static final int TRANSPORTED_ITEM_MAX_STACK_SIZE = 16;
    private static final int MAX_VISITED_POSITIONS = 10;
    private static final int MAX_UNREACHABLE_POSITIONS = 50;
    private static final int PASSENGER_MOB_TARGET_SEARCH_DISTANCE = 1;
    private static final int IDLE_COOLDOWN = 140;
    private static final double CLOSE_ENOUGH_TO_START_QUEUING_DISTANCE = 3.0;
    private static final double CLOSE_ENOUGH_TO_START_INTERACTING_WITH_TARGET_DISTANCE = 0.5;
    private static final double CLOSE_ENOUGH_TO_START_INTERACTING_WITH_TARGET_PATH_END_DISTANCE = 1.1;
    private static final double CLOSE_ENOUGH_TO_CONTINUE_INTERACTING_WITH_TARGET = 2.0;
    private final float speedModifier;
    private final int horizontalSearchDistance;
    private final int verticalSearchDistance;
    private final Predicate<BlockState> sourceBlockType;
    private final Predicate<BlockState> destinationBlockType;
    private final Predicate<TransportItemTarget> shouldQueueForTarget;
    private final Consumer<PathfinderMob> onStartTravelling;
    private final Map<ContainerInteractionState, OnTargetReachedInteraction> onTargetInteractionActions;
    @Nullable
    private TransportItemTarget target = null;
    private TransportItemState state;
    @Nullable
    private ContainerInteractionState interactionState;
    private int ticksSinceReachingTarget;

    public TransportItemsBetweenContainers(float speedModifier, Predicate<BlockState> sourceBlockType, Predicate<BlockState> destinationBlockType, int horizontalSearchDistance, int verticalSearchDistance, Map<ContainerInteractionState, OnTargetReachedInteraction> onTargetInteractionActions, Consumer<PathfinderMob> onStartTravelling, Predicate<TransportItemTarget> shouldQueueForTarget) {
        super((Map)ImmutableMap.of((Object)((MemoryModuleType)ModMemoryTypes.VISITED_BLOCK_POSITIONS.get()), (Object)MemoryStatus.REGISTERED, (Object)((MemoryModuleType)ModMemoryTypes.UNREACHABLE_TRANSPORT_BLOCK_POSITIONS.get()), (Object)MemoryStatus.REGISTERED, (Object)((MemoryModuleType)ModMemoryTypes.TRANSPORT_ITEMS_COOLDOWN_TICKS.get()), (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.f_217768_, (Object)MemoryStatus.VALUE_ABSENT, (Object)((MemoryModuleType)ModMemoryTypes.IS_PRESSING_BUTTON.get()), (Object)MemoryStatus.VALUE_ABSENT));
        this.speedModifier = speedModifier;
        this.sourceBlockType = sourceBlockType;
        this.destinationBlockType = destinationBlockType;
        this.horizontalSearchDistance = horizontalSearchDistance;
        this.verticalSearchDistance = verticalSearchDistance;
        this.onStartTravelling = onStartTravelling;
        this.shouldQueueForTarget = shouldQueueForTarget;
        this.onTargetInteractionActions = onTargetInteractionActions;
        this.state = TransportItemState.TRAVELLING;
    }

    protected void start(ServerLevel level, PathfinderMob mob, long gameTime) {
    }

    protected boolean checkExtraStartConditions(ServerLevel level, PathfinderMob mob) {
        return !mob.m_21523_();
    }

    protected boolean canStillUse(ServerLevel level, PathfinderMob mob, long gameTime) {
        return mob.m_6274_().m_21952_((MemoryModuleType)ModMemoryTypes.TRANSPORT_ITEMS_COOLDOWN_TICKS.get()).isEmpty() && !mob.m_6274_().m_21874_(MemoryModuleType.f_26383_) && !mob.m_21523_();
    }

    protected boolean m_7773_(long gameTime) {
        return false;
    }

    protected void tick(ServerLevel level, PathfinderMob mob, long gameTime) {
        boolean invalidTarget = this.updateInvalidTarget(level, mob);
        if (this.target == null) {
            this.stop(level, mob, gameTime);
        } else if (!invalidTarget) {
            if (this.state.equals((Object)TransportItemState.QUEUING)) {
                this.onQueuingForTarget(this.target, (Level)level, mob);
            }
            if (this.state.equals((Object)TransportItemState.TRAVELLING)) {
                this.onTravelToTarget(this.target, (Level)level, mob);
            }
            if (this.state.equals((Object)TransportItemState.INTERACTING)) {
                this.onReachedTarget(this.target, (Level)level, mob);
            }
        }
    }

    private boolean updateInvalidTarget(ServerLevel level, PathfinderMob mob) {
        if (!this.hasValidTarget((Level)level, mob)) {
            this.stopTargetingCurrentTarget(mob);
            Optional<TransportItemTarget> optional = this.getTransportTarget(level, mob);
            if (optional.isPresent()) {
                this.target = optional.get();
                this.onStartTravelling(mob);
                this.setVisitedBlockPos(mob, (Level)level, this.target.pos);
                return true;
            }
            this.enterCooldownAfterNoMatchingTargetFound(mob);
            return true;
        }
        return false;
    }

    private void onQueuingForTarget(TransportItemTarget target, Level level, PathfinderMob mob) {
        if (!this.isAnotherMobInteractingWithTarget(target, level)) {
            this.resumeTravelling(mob);
        }
    }

    protected void onTravelToTarget(TransportItemTarget target, Level level, PathfinderMob mob) {
        double interactionRange = TransportItemsBetweenContainers.getInteractionRange(mob);
        if (this.isWithinTargetDistance(3.0, target, level, mob, this.getCenterPos(mob)) && this.isAnotherMobInteractingWithTarget(target, level)) {
            this.startQueuing(mob);
        } else if (this.isWithinTargetDistance(interactionRange, target, level, mob, this.getCenterPos(mob))) {
            this.startOnReachedTargetInteraction(target, mob);
        } else {
            this.walkTowardsTarget(mob);
        }
    }

    private Vec3 getCenterPos(PathfinderMob mob) {
        return this.setMiddleYPosition(mob, mob.m_20182_());
    }

    protected void onReachedTarget(TransportItemTarget target, Level level, PathfinderMob mob) {
        if (!this.isWithinTargetDistance(2.0, target, level, mob, this.getCenterPos(mob))) {
            this.onStartTravelling(mob);
        } else {
            ++this.ticksSinceReachingTarget;
            this.onTargetInteraction(target, mob);
            if (this.ticksSinceReachingTarget >= 60) {
                this.doReachedTargetInteraction(mob, target.container, this::pickUpItems, (p1, p2) -> this.stopTargetingCurrentTarget(mob), this::putDownItem, (p1, p2) -> this.stopTargetingCurrentTarget(mob));
                this.onStartTravelling(mob);
            }
        }
    }

    private void startQueuing(PathfinderMob mob) {
        this.stopInPlace(mob);
        this.setTransportingState(TransportItemState.QUEUING);
    }

    private void resumeTravelling(PathfinderMob mob) {
        this.setTransportingState(TransportItemState.TRAVELLING);
        this.walkTowardsTarget(mob);
    }

    private void walkTowardsTarget(PathfinderMob mob) {
        if (this.target != null) {
            BehaviorUtils.m_22617_((LivingEntity)mob, (BlockPos)this.target.pos, (float)this.speedModifier, (int)0);
        }
    }

    private void startOnReachedTargetInteraction(TransportItemTarget target, PathfinderMob mob) {
        this.doReachedTargetInteraction(mob, target.container, this.onReachedInteraction(ContainerInteractionState.PICKUP_ITEM), this.onReachedInteraction(ContainerInteractionState.PICKUP_NO_ITEM), this.onReachedInteraction(ContainerInteractionState.PLACE_ITEM), this.onReachedInteraction(ContainerInteractionState.PLACE_NO_ITEM));
        this.setTransportingState(TransportItemState.INTERACTING);
    }

    private void onStartTravelling(PathfinderMob mob) {
        this.onStartTravelling.accept(mob);
        this.setTransportingState(TransportItemState.TRAVELLING);
        this.interactionState = null;
        this.ticksSinceReachingTarget = 0;
    }

    private BiConsumer<PathfinderMob, Container> onReachedInteraction(ContainerInteractionState interactionState) {
        return (mob, container) -> this.setInteractionState(interactionState);
    }

    private void setTransportingState(TransportItemState transportingState) {
        this.state = transportingState;
    }

    private void setInteractionState(ContainerInteractionState interactionState) {
        this.interactionState = interactionState;
    }

    private void onTargetInteraction(TransportItemTarget target, PathfinderMob mob) {
        mob.m_6274_().m_21879_(MemoryModuleType.f_26371_, (Object)new BlockPosTracker(target.pos));
        this.stopInPlace(mob);
        if (this.interactionState != null) {
            Optional.ofNullable(this.onTargetInteractionActions.get((Object)this.interactionState)).ifPresent(action -> action.accept(mob, target, this.ticksSinceReachingTarget));
        }
    }

    private void doReachedTargetInteraction(PathfinderMob mob, Container container, BiConsumer<PathfinderMob, Container> pickupItem, BiConsumer<PathfinderMob, Container> pickupNoItem, BiConsumer<PathfinderMob, Container> placeItem, BiConsumer<PathfinderMob, Container> placeNoItem) {
        if (TransportItemsBetweenContainers.isPickingUpItems(mob)) {
            if (TransportItemsBetweenContainers.matchesGettingItemsRequirement(container)) {
                pickupItem.accept(mob, container);
            } else {
                pickupNoItem.accept(mob, container);
            }
        } else if (TransportItemsBetweenContainers.matchesLeavingItemsRequirement(mob, container)) {
            placeItem.accept(mob, container);
        } else {
            placeNoItem.accept(mob, container);
        }
    }

    private Optional<TransportItemTarget> getTransportTarget(ServerLevel level, PathfinderMob mob) {
        AABB aabb = this.getTargetSearchArea(mob);
        Set<GlobalPos> visited = TransportItemsBetweenContainers.getVisitedPositions(mob);
        Set<GlobalPos> unreachable = TransportItemsBetweenContainers.getUnreachablePositions(mob);
        ChunkPos centerChunk = new ChunkPos(mob.m_20183_());
        int chunkRadius = Math.floorDiv(this.getHorizontalSearchDistance(mob), 16) + 1;
        ArrayList<ChunkPos> chunks = new ArrayList<ChunkPos>();
        for (int x = centerChunk.f_45578_ - chunkRadius; x <= centerChunk.f_45578_ + chunkRadius; ++x) {
            for (int z = centerChunk.f_45579_ - chunkRadius; z <= centerChunk.f_45579_ + chunkRadius; ++z) {
                chunks.add(new ChunkPos(x, z));
            }
        }
        TransportItemTarget bestTarget = null;
        double bestDistance = 3.4028234663852886E38;
        int chestsFound = 0;
        int vanillaChestsFound = 0;
        for (ChunkPos chunkPos : chunks) {
            LevelChunk chunk = level.m_6325_(chunkPos.f_45578_, chunkPos.f_45579_);
            if (chunk == null) continue;
            for (BlockEntity blockEntity : chunk.m_62954_().values()) {
                TransportItemTarget candidateTarget;
                double distance;
                if (!(blockEntity instanceof BaseContainerBlockEntity)) continue;
                BaseContainerBlockEntity containerBlockEntity = (BaseContainerBlockEntity)blockEntity;
                ++chestsFound;
                BlockState state = containerBlockEntity.m_58900_();
                if (state.m_60734_() == Blocks.f_50087_) {
                    ++vanillaChestsFound;
                }
                if (!((distance = containerBlockEntity.m_58899_().m_203193_((Position)mob.m_20182_())) < bestDistance) || (candidateTarget = this.isTargetValidToPick(mob, (Level)level, (BlockEntity)containerBlockEntity, visited, unreachable, aabb)) == null) continue;
                bestTarget = candidateTarget;
                bestDistance = distance;
            }
        }
        return bestTarget == null ? Optional.empty() : Optional.of(bestTarget);
    }

    @Nullable
    private TransportItemTarget isTargetValidToPick(PathfinderMob mob, Level level, BlockEntity blockEntity, Set<GlobalPos> visited, Set<GlobalPos> unreachable, AABB searchArea) {
        BlockPos blockpos = blockEntity.m_58899_();
        boolean inArea = searchArea.m_82393_((double)blockpos.m_123341_(), (double)blockpos.m_123342_(), (double)blockpos.m_123343_());
        if (!inArea) {
            return null;
        }
        TransportItemTarget target = TransportItemTarget.tryCreatePossibleTarget(blockEntity, level);
        if (target == null) {
            return null;
        }
        boolean isWanted = this.isWantedBlock(mob, target.state);
        boolean notVisited = !this.isPositionAlreadyVisited(visited, unreachable, target, level);
        boolean notLocked = !this.isContainerLocked(target);
        boolean isValid = isWanted && notVisited && notLocked;
        return isValid ? target : null;
    }

    private boolean isContainerLocked(TransportItemTarget target) {
        return false;
    }

    private boolean hasValidTarget(Level level, PathfinderMob mob) {
        boolean hasTarget;
        boolean bl = hasTarget = this.target != null && this.isWantedBlock(mob, this.target.state) && this.targetHasNotChanged(level, this.target);
        if (hasTarget && !this.isTargetBlocked(level, this.target)) {
            if (!this.state.equals((Object)TransportItemState.TRAVELLING)) {
                return true;
            }
            if (this.hasValidTravellingPath(level, this.target, mob)) {
                return true;
            }
            this.markVisitedBlockPosAsUnreachable(mob, level, this.target.pos);
        }
        return false;
    }

    private boolean hasValidTravellingPath(Level level, TransportItemTarget target, PathfinderMob mob) {
        Path path = mob.m_21573_().m_26570_() == null ? mob.m_21573_().m_7864_(target.pos, 0) : mob.m_21573_().m_26570_();
        Vec3 vec3 = this.getPositionToReachTargetFrom(path, mob);
        boolean withinRange = this.isWithinTargetDistance(TransportItemsBetweenContainers.getInteractionRange(mob), target, level, mob, vec3);
        boolean noPathAndNotInRange = path == null && !withinRange;
        boolean reachable = this.targetIsReachableFromPosition(level, withinRange, vec3, target, mob);
        boolean hasValidPath = path != null;
        return hasValidPath || noPathAndNotInRange || reachable;
    }

    private Vec3 getPositionToReachTargetFrom(@Nullable Path path, PathfinderMob mob) {
        boolean noPath = path == null || path.m_77395_() == null;
        Vec3 vec3 = noPath ? mob.m_20182_() : new BlockPos(path.m_77395_().f_77271_, path.m_77395_().f_77272_, path.m_77395_().f_77273_).m_252807_();
        return this.setMiddleYPosition(mob, vec3);
    }

    private Vec3 setMiddleYPosition(PathfinderMob mob, Vec3 pos) {
        return pos.m_82520_(0.0, (double)mob.m_20206_() / 2.0, 0.0);
    }

    private boolean isTargetBlocked(Level level, TransportItemTarget target) {
        return ChestBlock.m_51508_((LevelAccessor)level, (BlockPos)target.pos);
    }

    private boolean targetHasNotChanged(Level level, TransportItemTarget target) {
        return target.blockEntity.equals(level.m_7702_(target.pos));
    }

    private Stream<TransportItemTarget> getConnectedTargets(TransportItemTarget target, Level level) {
        if (target.state.m_61138_((Property)ChestBlock.f_51479_) && target.state.m_61143_((Property)ChestBlock.f_51479_) != ChestType.SINGLE) {
            Direction facing = (Direction)target.state.m_61143_((Property)ChestBlock.f_51478_);
            ChestType chestType = (ChestType)target.state.m_61143_((Property)ChestBlock.f_51479_);
            Direction connectedDir = chestType == ChestType.LEFT ? facing.m_122427_() : facing.m_122428_();
            BlockPos connectedPos = target.pos.m_121945_(connectedDir);
            TransportItemTarget connectedTarget = TransportItemTarget.tryCreatePossibleTarget(level.m_7702_(connectedPos), level);
            return connectedTarget != null ? Stream.of(target, connectedTarget) : Stream.of(target);
        }
        return Stream.of(target);
    }

    private AABB getTargetSearchArea(PathfinderMob mob) {
        int horizontal = this.getHorizontalSearchDistance(mob);
        return new AABB(mob.m_20183_()).m_82377_((double)horizontal, (double)this.getVerticalSearchDistance(mob), (double)horizontal);
    }

    private int getHorizontalSearchDistance(PathfinderMob mob) {
        return mob.m_20159_() ? 1 : this.horizontalSearchDistance;
    }

    private int getVerticalSearchDistance(PathfinderMob mob) {
        return mob.m_20159_() ? 1 : this.verticalSearchDistance;
    }

    private static Set<GlobalPos> getVisitedPositions(PathfinderMob mob) {
        return mob.m_6274_().m_21952_((MemoryModuleType)ModMemoryTypes.VISITED_BLOCK_POSITIONS.get()).orElse(Set.of());
    }

    private static Set<GlobalPos> getUnreachablePositions(PathfinderMob mob) {
        return mob.m_6274_().m_21952_((MemoryModuleType)ModMemoryTypes.UNREACHABLE_TRANSPORT_BLOCK_POSITIONS.get()).orElse(Set.of());
    }

    private boolean isPositionAlreadyVisited(Set<GlobalPos> visited, Set<GlobalPos> unreachable, TransportItemTarget target, Level level) {
        return this.getConnectedTargets(target, level).map(t -> GlobalPos.m_122643_((ResourceKey)level.m_46472_(), (BlockPos)t.pos)).anyMatch(globalPos -> visited.contains(globalPos) || unreachable.contains(globalPos));
    }

    private static boolean hasFinishedPath(PathfinderMob mob) {
        return mob.m_21573_().m_26570_() != null && mob.m_21573_().m_26570_().m_77392_();
    }

    protected void setVisitedBlockPos(PathfinderMob mob, Level level, BlockPos pos) {
        HashSet<GlobalPos> visited = new HashSet<GlobalPos>(TransportItemsBetweenContainers.getVisitedPositions(mob));
        visited.add(GlobalPos.m_122643_((ResourceKey)level.m_46472_(), (BlockPos)pos));
        if (visited.size() > 10) {
            this.enterCooldownAfterNoMatchingTargetFound(mob);
        } else {
            mob.m_6274_().m_21882_((MemoryModuleType)ModMemoryTypes.VISITED_BLOCK_POSITIONS.get(), visited, 6000L);
        }
    }

    protected void markVisitedBlockPosAsUnreachable(PathfinderMob mob, Level level, BlockPos pos) {
        HashSet<GlobalPos> visited = new HashSet<GlobalPos>(TransportItemsBetweenContainers.getVisitedPositions(mob));
        visited.remove(GlobalPos.m_122643_((ResourceKey)level.m_46472_(), (BlockPos)pos));
        HashSet<GlobalPos> unreachable = new HashSet<GlobalPos>(TransportItemsBetweenContainers.getUnreachablePositions(mob));
        unreachable.add(GlobalPos.m_122643_((ResourceKey)level.m_46472_(), (BlockPos)pos));
        if (unreachable.size() > 50) {
            this.enterCooldownAfterNoMatchingTargetFound(mob);
        } else {
            mob.m_6274_().m_21882_((MemoryModuleType)ModMemoryTypes.VISITED_BLOCK_POSITIONS.get(), visited, 6000L);
            mob.m_6274_().m_21882_((MemoryModuleType)ModMemoryTypes.UNREACHABLE_TRANSPORT_BLOCK_POSITIONS.get(), unreachable, 6000L);
        }
    }

    private boolean isWantedBlock(PathfinderMob mob, BlockState state) {
        boolean picking = TransportItemsBetweenContainers.isPickingUpItems(mob);
        boolean result = picking ? this.sourceBlockType.test(state) : this.destinationBlockType.test(state);
        return result;
    }

    private static double getInteractionRange(PathfinderMob mob) {
        return TransportItemsBetweenContainers.hasFinishedPath(mob) ? 1.1 : 0.5;
    }

    private boolean isWithinTargetDistance(double distance, TransportItemTarget target, Level level, PathfinderMob mob, Vec3 center) {
        AABB mobBounds = mob.m_20191_();
        double width = mobBounds.m_82362_();
        double height = mob.m_20206_();
        AABB centerBounds = new AABB(center.f_82479_ - width / 2.0, center.f_82480_ - height / 2.0, center.f_82481_ - width / 2.0, center.f_82479_ + width / 2.0, center.f_82480_ + height / 2.0, center.f_82481_ + width / 2.0);
        return target.state.m_60812_((BlockGetter)level, target.pos).m_83215_().m_82377_(distance, distance, distance).m_82338_(target.pos).m_82381_(centerBounds);
    }

    private boolean targetIsReachableFromPosition(Level level, boolean withinDistance, Vec3 targetPos, TransportItemTarget target, PathfinderMob mob) {
        return withinDistance && this.canSeeAnyTargetSide(target, level, mob, targetPos);
    }

    private boolean canSeeAnyTargetSide(TransportItemTarget target, Level level, PathfinderMob mob, Vec3 pos) {
        Vec3 targetCenter = target.pos.m_252807_();
        return Arrays.stream(Direction.values()).map(dir -> targetCenter.m_82520_(0.5 * (double)dir.m_122429_(), 0.5 * (double)dir.m_122430_(), 0.5 * (double)dir.m_122431_())).map(sidePos -> level.m_45547_(new ClipContext(pos, sidePos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)mob))).anyMatch(hitResult -> hitResult.m_6662_() == HitResult.Type.BLOCK && hitResult.m_82425_().equals((Object)target.pos));
    }

    private boolean isAnotherMobInteractingWithTarget(TransportItemTarget target, Level level) {
        return this.getConnectedTargets(target, level).anyMatch(this.shouldQueueForTarget);
    }

    private static boolean isPickingUpItems(PathfinderMob mob) {
        return mob.m_21205_().m_41619_();
    }

    private static boolean matchesGettingItemsRequirement(Container container) {
        return !container.m_7983_();
    }

    private static boolean matchesLeavingItemsRequirement(PathfinderMob mob, Container container) {
        return container.m_7983_() || TransportItemsBetweenContainers.hasItemMatchingHandItem(mob, container);
    }

    private static boolean hasItemMatchingHandItem(PathfinderMob mob, Container container) {
        ItemStack handItem = mob.m_21205_();
        for (int i = 0; i < container.m_6643_(); ++i) {
            ItemStack containerItem = container.m_8020_(i);
            if (!ItemStack.m_41656_((ItemStack)containerItem, (ItemStack)handItem)) continue;
            return true;
        }
        return false;
    }

    private void pickUpItems(PathfinderMob mob, Container container) {
        ItemStack pickedUp = TransportItemsBetweenContainers.pickupItemFromContainer(container);
        mob.m_8061_(EquipmentSlot.MAINHAND, pickedUp);
        mob.m_21508_(EquipmentSlot.MAINHAND);
        container.m_6596_();
        this.clearMemoriesAfterMatchingTargetFound(mob);
    }

    private void putDownItem(PathfinderMob mob, Container container) {
        ItemStack remainingItems = TransportItemsBetweenContainers.addItemsToContainer(mob, container);
        container.m_6596_();
        mob.m_8061_(EquipmentSlot.MAINHAND, remainingItems);
        if (remainingItems.m_41619_()) {
            this.clearMemoriesAfterMatchingTargetFound(mob);
        } else {
            this.stopTargetingCurrentTarget(mob);
        }
    }

    private static ItemStack pickupItemFromContainer(Container container) {
        for (int slot = 0; slot < container.m_6643_(); ++slot) {
            ItemStack itemStack = container.m_8020_(slot);
            if (itemStack.m_41619_()) continue;
            int count = Math.min(itemStack.m_41613_(), 16);
            return container.m_7407_(slot, count);
        }
        return ItemStack.f_41583_;
    }

    private static ItemStack addItemsToContainer(PathfinderMob mob, Container container) {
        ItemStack handItem = mob.m_21205_();
        for (int slot = 0; slot < container.m_6643_(); ++slot) {
            ItemStack containerItem = container.m_8020_(slot);
            if (containerItem.m_41619_()) {
                container.m_6836_(slot, handItem);
                return ItemStack.f_41583_;
            }
            if (!ItemStack.m_150942_((ItemStack)containerItem, (ItemStack)handItem) || containerItem.m_41613_() >= containerItem.m_41741_()) continue;
            int spaceLeft = containerItem.m_41741_() - containerItem.m_41613_();
            int toAdd = Math.min(spaceLeft, handItem.m_41613_());
            containerItem.m_41764_(containerItem.m_41613_() + toAdd);
            handItem.m_41764_(handItem.m_41613_() - toAdd);
            container.m_6836_(slot, containerItem);
            if (!handItem.m_41619_()) continue;
            return ItemStack.f_41583_;
        }
        return handItem;
    }

    protected void stopTargetingCurrentTarget(PathfinderMob mob) {
        this.ticksSinceReachingTarget = 0;
        this.target = null;
        mob.m_21573_().m_26573_();
        mob.m_6274_().m_21936_(MemoryModuleType.f_26370_);
    }

    protected void clearMemoriesAfterMatchingTargetFound(PathfinderMob mob) {
        this.stopTargetingCurrentTarget(mob);
        mob.m_6274_().m_21936_((MemoryModuleType)ModMemoryTypes.VISITED_BLOCK_POSITIONS.get());
        mob.m_6274_().m_21936_((MemoryModuleType)ModMemoryTypes.UNREACHABLE_TRANSPORT_BLOCK_POSITIONS.get());
    }

    private void enterCooldownAfterNoMatchingTargetFound(PathfinderMob mob) {
        this.stopTargetingCurrentTarget(mob);
        mob.m_6274_().m_21879_((MemoryModuleType)ModMemoryTypes.TRANSPORT_ITEMS_COOLDOWN_TICKS.get(), (Object)140);
        mob.m_6274_().m_21936_((MemoryModuleType)ModMemoryTypes.VISITED_BLOCK_POSITIONS.get());
        mob.m_6274_().m_21936_((MemoryModuleType)ModMemoryTypes.UNREACHABLE_TRANSPORT_BLOCK_POSITIONS.get());
    }

    protected void stop(ServerLevel level, PathfinderMob mob, long gameTime) {
        this.onStartTravelling(mob);
    }

    private void stopInPlace(PathfinderMob mob) {
        mob.m_21573_().m_26573_();
        mob.m_21570_(0.0f);
        mob.m_21567_(0.0f);
        mob.m_7910_(0.0f);
        mob.m_20334_(0.0, mob.m_20184_().f_82480_, 0.0);
    }

    public record TransportItemTarget(BlockPos pos, Container container, BlockEntity blockEntity, BlockState state) {
        @Nullable
        public static TransportItemTarget tryCreatePossibleTarget(BlockEntity blockEntity, Level level) {
            BlockPos blockpos = blockEntity.m_58899_();
            BlockState blockstate = blockEntity.m_58900_();
            Container container = TransportItemTarget.getBlockEntityContainer(blockEntity, blockstate, level, blockpos);
            return container != null ? new TransportItemTarget(blockpos, container, blockEntity, blockstate) : null;
        }

        @Nullable
        public static TransportItemTarget tryCreatePossibleTarget(BlockPos pos, Level level) {
            BlockEntity blockentity = level.m_7702_(pos);
            return blockentity == null ? null : TransportItemTarget.tryCreatePossibleTarget(blockentity, level);
        }

        @Nullable
        private static Container getBlockEntityContainer(BlockEntity blockEntity, BlockState state, Level level, BlockPos pos) {
            Container container;
            Block block = state.m_60734_();
            if (block instanceof ChestBlock) {
                ChestBlock chestblock = (ChestBlock)block;
                return ChestBlock.m_51511_((ChestBlock)chestblock, (BlockState)state, (Level)level, (BlockPos)pos, (boolean)false);
            }
            return blockEntity instanceof Container ? (container = (Container)blockEntity) : null;
        }
    }

    public static enum TransportItemState {
        TRAVELLING,
        QUEUING,
        INTERACTING;

    }

    public static enum ContainerInteractionState {
        PICKUP_ITEM,
        PICKUP_NO_ITEM,
        PLACE_ITEM,
        PLACE_NO_ITEM;

    }

    public static interface OnTargetReachedInteraction {
        public void accept(PathfinderMob var1, TransportItemTarget var2, Integer var3);
    }
}

