/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse.client.renderers.entities;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.wenxin2.marioverse.client.models.entities.DryBonesModel;
import com.wenxin2.marioverse.entities.DryBonesEntity;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.level.block.AbstractSkullBlock;
import net.minecraft.world.level.block.SkullBlock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.renderer.layer.AutoGlowingGeoLayer;
import software.bernie.geckolib.renderer.layer.BlockAndItemGeoLayer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;
import software.bernie.geckolib.renderer.layer.ItemArmorGeoLayer;

public class DryBonesRenderer
extends GeoEntityRenderer<DryBonesEntity> {
    private static final String HELMET = "armorHead";
    private static final String CHEST = "armorBody";
    private static final String LEFT_ARM = "armorLeftArm";
    private static final String RIGHT_ARM = "armorRightArm";
    private static final String LEFT_LEG = "armorLeftLeg";
    private static final String RIGHT_LEG = "armorRightLeg";
    private static final String LEFT_BOOT = "armorLeftBoot";
    private static final String RIGHT_BOOT = "armorRightBoot";
    protected ItemStack mainHandItem;
    protected ItemStack offhandItem;

    public DryBonesRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, (GeoModel)new DryBonesModel());
        this.shadowRadius = 0.5f;
        this.addRenderLayer((GeoRenderLayer)new AutoGlowingGeoLayer((GeoRenderer)this));
        this.addRenderLayer((GeoRenderLayer)new ItemArmorGeoLayer<DryBonesEntity>(this, (GeoRenderer)this){

            @Nullable
            protected ItemStack getArmorItemForBone(GeoBone bone, DryBonesEntity animatable) {
                return switch (bone.getName()) {
                    case DryBonesRenderer.HELMET -> this.helmetStack;
                    case DryBonesRenderer.CHEST, DryBonesRenderer.LEFT_ARM, DryBonesRenderer.RIGHT_ARM -> this.chestplateStack;
                    case DryBonesRenderer.LEFT_LEG, DryBonesRenderer.RIGHT_LEG -> this.leggingsStack;
                    case DryBonesRenderer.LEFT_BOOT, DryBonesRenderer.RIGHT_BOOT -> this.bootsStack;
                    default -> super.getArmorItemForBone(bone, (LivingEntity)animatable);
                };
            }

            @NotNull
            protected EquipmentSlot getEquipmentSlotForBone(GeoBone bone, ItemStack stack, DryBonesEntity animatable) {
                return switch (bone.getName()) {
                    case DryBonesRenderer.HELMET -> EquipmentSlot.HEAD;
                    case DryBonesRenderer.CHEST -> EquipmentSlot.CHEST;
                    case DryBonesRenderer.RIGHT_ARM -> {
                        if (!animatable.isLeftHanded()) {
                            yield EquipmentSlot.MAINHAND;
                        }
                        yield EquipmentSlot.OFFHAND;
                    }
                    case DryBonesRenderer.LEFT_ARM -> {
                        if (animatable.isLeftHanded()) {
                            yield EquipmentSlot.OFFHAND;
                        }
                        yield EquipmentSlot.MAINHAND;
                    }
                    case DryBonesRenderer.LEFT_LEG, DryBonesRenderer.RIGHT_LEG -> EquipmentSlot.LEGS;
                    case DryBonesRenderer.LEFT_BOOT, DryBonesRenderer.RIGHT_BOOT -> EquipmentSlot.FEET;
                    default -> super.getEquipmentSlotForBone(bone, stack, (LivingEntity)animatable);
                };
            }

            @NotNull
            protected ModelPart getModelPartForBone(GeoBone bone, EquipmentSlot slot, ItemStack stack, DryBonesEntity animatable, HumanoidModel<?> baseModel) {
                return switch (bone.getName()) {
                    case DryBonesRenderer.HELMET -> baseModel.head;
                    case DryBonesRenderer.CHEST -> baseModel.body;
                    case DryBonesRenderer.LEFT_ARM -> baseModel.leftArm;
                    case DryBonesRenderer.RIGHT_ARM -> baseModel.rightArm;
                    case DryBonesRenderer.LEFT_LEG, DryBonesRenderer.LEFT_BOOT -> baseModel.leftLeg;
                    case DryBonesRenderer.RIGHT_LEG, DryBonesRenderer.RIGHT_BOOT -> baseModel.rightLeg;
                    default -> super.getModelPartForBone(bone, slot, stack, (LivingEntity)animatable, baseModel);
                };
            }

            protected void renderSkullAsArmor(PoseStack poseStack, GeoBone bone, ItemStack stack, AbstractSkullBlock skullBlock, MultiBufferSource bufferSource, int packedLight) {
                poseStack.scale(1.0f, 1.0f, 1.0f);
                poseStack.mulPose(Axis.XP.rotationDegrees(-30.0f));
                poseStack.translate(0.0f, 0.05f, 0.75f);
                super.renderSkullAsArmor(poseStack, bone, stack, skullBlock, bufferSource, packedLight);
            }
        });
        this.addRenderLayer((GeoRenderLayer)new BlockAndItemGeoLayer<DryBonesEntity>((GeoRenderer)this){

            @Nullable
            protected ItemStack getStackForBone(GeoBone bone, DryBonesEntity animatable) {
                return switch (bone.getName()) {
                    case DryBonesRenderer.HELMET -> {
                        BlockItem blockItem;
                        Item var6_5;
                        if (!(animatable.getItemBySlot(EquipmentSlot.HEAD).getItem() instanceof ArmorItem || (var6_5 = animatable.getItemBySlot(EquipmentSlot.HEAD).getItem()) instanceof BlockItem && (blockItem = (BlockItem)var6_5).getBlock() instanceof SkullBlock)) {
                            yield animatable.getItemBySlot(EquipmentSlot.HEAD);
                        }
                        yield ItemStack.EMPTY;
                    }
                    case DryBonesRenderer.LEFT_ARM -> {
                        if (animatable.isLeftHanded()) {
                            yield DryBonesRenderer.this.mainHandItem;
                        }
                        yield DryBonesRenderer.this.offhandItem;
                    }
                    case DryBonesRenderer.RIGHT_ARM -> {
                        if (animatable.isLeftHanded()) {
                            yield DryBonesRenderer.this.offhandItem;
                        }
                        yield DryBonesRenderer.this.mainHandItem;
                    }
                    default -> null;
                };
            }

            protected ItemDisplayContext getTransformTypeForStack(GeoBone bone, ItemStack stack, DryBonesEntity animatable) {
                return switch (bone.getName()) {
                    case DryBonesRenderer.HELMET -> ItemDisplayContext.HEAD;
                    case DryBonesRenderer.LEFT_ARM, DryBonesRenderer.RIGHT_ARM -> ItemDisplayContext.THIRD_PERSON_RIGHT_HAND;
                    default -> ItemDisplayContext.NONE;
                };
            }

            protected void renderStackForBone(PoseStack poseStack, GeoBone bone, ItemStack stack, DryBonesEntity animatable, MultiBufferSource bufferSource, float partialTick, int packedLight, int packedOverlay) {
                if (stack == DryBonesRenderer.this.mainHandItem) {
                    poseStack.mulPose(Axis.XP.rotationDegrees(-90.0f));
                    poseStack.translate(0.0, 0.125, -0.5);
                    if (stack.getItem() instanceof ShieldItem) {
                        poseStack.translate(-0.05, 0.0, 0.4);
                    }
                } else if (stack == DryBonesRenderer.this.offhandItem) {
                    poseStack.mulPose(Axis.XP.rotationDegrees(-90.0f));
                    poseStack.translate(0.0, 0.125, -0.5);
                    if (stack.getItem() instanceof ShieldItem) {
                        poseStack.translate(-0.05, 0.0, 0.4);
                        poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
                    }
                } else if (stack.getItem() instanceof BlockItem) {
                    poseStack.scale(0.85f, 0.85f, 0.85f);
                    poseStack.mulPose(Axis.XP.rotationDegrees(-30.0f));
                    poseStack.translate(0.0f, 0.5f, 0.1f);
                } else {
                    poseStack.scale(0.6f, 0.6f, 0.6f);
                    poseStack.translate(0.0f, 0.5f, 0.0f);
                }
                super.renderStackForBone(poseStack, bone, stack, (GeoAnimatable)animatable, bufferSource, partialTick, packedLight, packedOverlay);
            }
        });
    }

    public void preRender(PoseStack poseStack, DryBonesEntity animatable, BakedGeoModel model, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int colour) {
        super.preRender(poseStack, (Entity)animatable, model, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, colour);
        this.mainHandItem = animatable.getMainHandItem();
        this.offhandItem = animatable.getOffhandItem();
    }
}

