/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse.entities;

import com.wenxin2.marioverse.entities.CrackableEntity;
import com.wenxin2.marioverse.entities.GoldKoopaTroopaEntity;
import com.wenxin2.marioverse.entities.KoopaShellEntity;
import com.wenxin2.marioverse.entities.KoopaTroopaEntity;
import com.wenxin2.marioverse.registries.BlockRegistry;
import com.wenxin2.marioverse.registries.ConfigRegistry;
import com.wenxin2.marioverse.registries.EntityRegistry;
import com.wenxin2.marioverse.registries.ParticleRegistry;
import com.wenxin2.marioverse.registries.TagRegistry;
import com.wenxin2.marioverse.utils.ServerParticleUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoEntity;

public class GoldKoopaShellEntity
extends KoopaShellEntity
implements CrackableEntity,
GeoEntity,
TraceableEntity {
    private int coinCount = 0;

    public GoldKoopaShellEntity(EntityType<? extends GoldKoopaShellEntity> type, Level world) {
        super(type, world);
    }

    @Override
    protected void registerGoals() {
        this.targetSelector.addGoal(0, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[]{GoldKoopaTroopaEntity.class}));
    }

    @Override
    public void tick() {
        super.tick();
        Level world = this.level();
        BlockPos pos = this.blockPosition();
        FluidState fluidState = world.getFluidState(pos);
        BlockState coinState = ((Block)BlockRegistry.COIN.get()).defaultBlockState();
        if (!world.isClientSide && this.level().getGameTime() % 4L == 0L && world.getBlockState(pos).canBeReplaced() && this.coinCount <= (Integer)ConfigRegistry.MAX_GOLD_KOOPA_SHELL_TRAIL_COINS.get() && this.getDeltaMovement().length() > 0.25 && this.isAlive()) {
            world.setBlock(this.blockPosition(), (BlockState)coinState.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.getType() == Fluids.WATER)), 3);
            world.playSound(null, pos, ((Block)BlockRegistry.COIN.get()).getSoundType(coinState, (LevelReader)world, pos, null).getPlaceSound(), SoundSource.BLOCKS, 1.0f, 1.0f);
            if (world instanceof ServerLevel) {
                ServerLevel serverWorld = (ServerLevel)world;
                ServerParticleUtils.spawnParticlesOnBlockFaces((ParticleOptions)ParticleRegistry.COIN_GLINT.get(), serverWorld, pos, (IntProvider)UniformInt.of((int)1, (int)1));
            }
            ++this.coinCount;
        }
        if (this.coinCount >= (Integer)ConfigRegistry.MAX_GOLD_KOOPA_SHELL_TRAIL_COINS.get()) {
            this.playDeathAnimation((Entity)this);
            this.discard();
        }
    }

    @Override
    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putInt("CoinCount", this.coinCount);
    }

    @Override
    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.coinCount = tag.getInt("CoinCount");
    }

    @Override
    @NotNull
    public SimpleParticleType getShatterParticle() {
        return (SimpleParticleType)ParticleRegistry.GOLD_KOOPA_SHELL_SHATTER.get();
    }

    @Override
    @NotNull
    public KoopaTroopaEntity getKoopaTroopaEntity() {
        return new GoldKoopaTroopaEntity((EntityType<? extends GoldKoopaTroopaEntity>)((EntityType)EntityRegistry.GOLD_KOOPA_TROOPA.get()), this.level());
    }

    @Override
    public TagKey<EntityType<?>> getInstaKillEntityTag() {
        return TagRegistry.GOLD_KOOPA_SHELL_CAN_INSTAKILL;
    }

    @Override
    public float getShellDamage() {
        return ((Double)ConfigRegistry.GOLD_KOOPA_SHELL_DAMAGE.get()).floatValue();
    }

    @Override
    public void playDeathAnimation(Entity entity) {
        super.playDeathAnimation(entity);
        if (!this.level().isClientSide()) {
            BlockPos center = this.blockPosition();
            this.placeCoinCircle(this.level(), center);
        }
    }

    @Override
    public void trailParticles(BlockState state, BlockPos pos, double x, double z, Vec3 vec3) {
        super.trailParticles(state, pos, x, z, vec3);
        if (this.level().getGameTime() % 4L == 0L) {
            this.level().addParticle((ParticleOptions)ParticleRegistry.COIN_GLINT.get(), x, this.getY() + 0.1, z, vec3.x * -4.0, 1.5, vec3.z * -4.0);
        }
    }

    public void placeCoinCircle(Level world, BlockPos center) {
        int radius = (Integer)ConfigRegistry.GOLD_KOOPA_SHELL_COIN_CIRCLE_RADIUS.get();
        int coinCount = (Integer)ConfigRegistry.MAX_GOLD_KOOPA_SHELL_CIRCLE_COINS.get();
        for (int i = 0; i < coinCount; ++i) {
            double angle = Math.PI * 2 * (double)i / (double)coinCount;
            int x = center.getX() + (int)Math.round((double)radius * Math.cos(angle));
            int z = center.getZ() + (int)Math.round((double)radius * Math.sin(angle));
            BlockPos basePos = new BlockPos(x, center.getY(), z);
            BlockPos coinPos = this.findValidCoinPosition(world, basePos);
            BlockState coinState = world.getBlockState(coinPos);
            if (!coinState.canBeReplaced() && !coinState.getFluidState().is(FluidTags.WATER) && coinState.getBlock() != BlockRegistry.COIN.get()) continue;
            world.setBlock(coinPos, (BlockState)((Block)BlockRegistry.COIN.get()).defaultBlockState().setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(coinState.getFluidState().is(FluidTags.WATER))), 3);
            world.playSound(null, coinPos, ((Block)BlockRegistry.COIN.get()).getSoundType(coinState, (LevelReader)world, coinPos, null).getPlaceSound(), SoundSource.BLOCKS, 1.0f, 1.0f);
            if (!(world instanceof ServerLevel)) continue;
            ServerLevel serverWorld = (ServerLevel)world;
            ServerParticleUtils.spawnParticlesOnBlockFaces((ParticleOptions)ParticleRegistry.COIN_GLINT.get(), serverWorld, coinPos, (IntProvider)UniformInt.of((int)1, (int)1));
        }
    }

    private BlockPos findValidCoinPosition(Level world, BlockPos basePos) {
        boolean isAirOrWater;
        BlockPos pos = basePos;
        BlockState state = world.getBlockState(pos);
        boolean bl = isAirOrWater = state.canBeReplaced() || state.getFluidState().is(FluidTags.WATER) || state.getBlock() == BlockRegistry.COIN.get();
        if (isAirOrWater) {
            return pos;
        }
        for (int i = 1; i <= 3; ++i) {
            BlockPos posAbove = pos.above(i);
            BlockState stateAbove = world.getBlockState(posAbove);
            if (!stateAbove.canBeReplaced() && !stateAbove.getFluidState().is(FluidTags.WATER) && stateAbove.getBlock() != BlockRegistry.COIN.get()) continue;
            pos = posAbove;
            break;
        }
        return pos;
    }
}

