/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse.entities;

import com.wenxin2.marioverse.entities.CrackableEntity;
import com.wenxin2.marioverse.entities.KoopaShellEntity;
import com.wenxin2.marioverse.entities.KoopaTroopaEntity;
import com.wenxin2.marioverse.entities.RedKoopaTroopaEntity;
import com.wenxin2.marioverse.registries.ConfigRegistry;
import com.wenxin2.marioverse.registries.EntityRegistry;
import com.wenxin2.marioverse.registries.ParticleRegistry;
import com.wenxin2.marioverse.registries.TagRegistry;
import java.util.List;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Shulker;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.entity.PartEntity;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoEntity;

public class RedKoopaShellEntity
extends KoopaShellEntity
implements CrackableEntity,
GeoEntity,
TraceableEntity {
    public RedKoopaShellEntity(EntityType<? extends RedKoopaShellEntity> type, Level world) {
        super(type, world);
    }

    @Override
    protected void registerGoals() {
        this.targetSelector.addGoal(0, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[]{RedKoopaTroopaEntity.class}));
    }

    @Override
    public void tick() {
        int ticksToDie;
        super.tick();
        if (this.isAlive()) {
            this.targetEntity();
        }
        if ((ticksToDie = this.getPersistentData().getInt("marioverse:ticks_to_die")) > 1) {
            this.getPersistentData().putInt("marioverse:ticks_to_die", ticksToDie - 1);
        } else if (ticksToDie == 1) {
            this.kill();
        }
    }

    @Override
    @NotNull
    public SimpleParticleType getShatterParticle() {
        return (SimpleParticleType)ParticleRegistry.RED_KOOPA_SHELL_SHATTER.get();
    }

    @Override
    @NotNull
    public KoopaTroopaEntity getKoopaTroopaEntity() {
        return new RedKoopaTroopaEntity((EntityType<? extends RedKoopaTroopaEntity>)((EntityType)EntityRegistry.RED_KOOPA_TROOPA.get()), this.level());
    }

    @Override
    public TagKey<EntityType<?>> getInstaKillEntityTag() {
        return TagRegistry.RED_KOOPA_SHELL_CAN_INSTAKILL;
    }

    @Override
    public float getShellDamage() {
        return ((Double)ConfigRegistry.RED_KOOPA_SHELL_DAMAGE.get()).floatValue();
    }

    @NotNull
    public Integer getMobDetectionRadius() {
        return (Integer)ConfigRegistry.RED_KOOPA_SHELL_MOB_DETECTION_RADIUS.get();
    }

    @NotNull
    public Integer getPlayerDetectionRadius() {
        return (Integer)ConfigRegistry.RED_KOOPA_SHELL_PLAYER_DETECTION_RADIUS.get();
    }

    public void targetEntity() {
        double dist;
        Object target = null;
        double closestDistance = Double.MAX_VALUE;
        double speed = this.getDeltaMovement().horizontalDistance();
        List players = this.level().getEntitiesOfClass(Player.class, this.getBoundingBox().inflate((double)this.getPlayerDetectionRadius().intValue(), 3.0, (double)this.getPlayerDetectionRadius().intValue()));
        for (Object player : players) {
            if (player.isSpectator() || !player.isAlive() || player.isInvisible() || player.getType().is(TagRegistry.RED_KOOPA_SHELL_CANNOT_ATTACK) || this.getOwner() != null && this.getOwner().getUUID().equals(player.getUUID())) continue;
            double dist2 = this.distanceToSqr((Entity)player);
            if (this.getOwner() != null && player.getTeam() != null && this.getOwner().getTeam() != null && player.getTeam() == this.getOwner().getTeam() || this.getOwner() != null && !(this.getOwner() instanceof Monster) && !(this.getOwner() instanceof Player) || !(dist2 < closestDistance)) continue;
            closestDistance = dist2;
            target = player;
        }
        if (target == null) {
            List entities = this.level().getEntitiesOfClass(PartEntity.class, this.getBoundingBox().inflate((double)this.getMobDetectionRadius().intValue(), 3.0, (double)this.getMobDetectionRadius().intValue()));
            for (PartEntity entity : entities) {
                if (!entity.isAlive() || entity.is((Entity)this) || entity.isInvisible() || entity.getType().is(TagRegistry.RED_KOOPA_SHELL_CANNOT_ATTACK)) continue;
                dist = this.distanceToSqr((Entity)entity);
                if (this.getOwner() != null && entity.getTeam() != null && this.getOwner().getTeam() != null && entity.getTeam() == this.getOwner().getTeam() || !(dist < closestDistance)) continue;
                closestDistance = dist;
                target = entity;
            }
        }
        if (target == null && this.getOwner() instanceof Monster) {
            List mobs = this.level().getEntitiesOfClass(Mob.class, this.getBoundingBox().inflate((double)this.getMobDetectionRadius().intValue(), 3.0, (double)this.getMobDetectionRadius().intValue()));
            for (Mob mob : mobs) {
                if (!mob.isAlive() || mob.is((Entity)this) || mob.isNoAi() || mob.isInvisible() || mob.getType().is(TagRegistry.RED_KOOPA_SHELL_CANNOT_ATTACK)) continue;
                dist = this.distanceToSqr((Entity)mob);
                if (this.getOwner() != null && mob.getTeam() != null && this.getOwner().getTeam() != null && mob.getTeam() == this.getOwner().getTeam() || mob instanceof Monster || !(dist < closestDistance)) continue;
                closestDistance = dist;
                target = mob;
            }
        }
        if (target == null) {
            List monsters = this.level().getEntitiesOfClass(Monster.class, this.getBoundingBox().inflate((double)this.getMobDetectionRadius().intValue(), 3.0, (double)this.getMobDetectionRadius().intValue()));
            for (Monster monster : monsters) {
                if (!monster.isAlive() || monster.is((Entity)this) || monster.isNoAi() || monster.isInvisible() || monster.getType().is(TagRegistry.RED_KOOPA_SHELL_CANNOT_ATTACK)) continue;
                dist = this.distanceToSqr((Entity)monster);
                if (this.getOwner() != null && monster.getTeam() != null && this.getOwner().getTeam() != null && monster.getTeam() == this.getOwner().getTeam() || !(dist < closestDistance)) continue;
                closestDistance = dist;
                target = monster;
            }
        }
        if (target == null) {
            List shulkers = this.level().getEntitiesOfClass(Shulker.class, this.getBoundingBox().inflate((double)this.getMobDetectionRadius().intValue(), 3.0, (double)this.getMobDetectionRadius().intValue()));
            for (Shulker shulker : shulkers) {
                if (!shulker.isAlive() || shulker.isClosed() || shulker.isInvisible() || shulker.is((Entity)this) || shulker.isNoAi() || shulker.getType().is(TagRegistry.RED_KOOPA_SHELL_CANNOT_ATTACK)) continue;
                dist = this.distanceToSqr((Entity)shulker);
                if (this.getOwner() != null && shulker.getTeam() != null && this.getOwner().getTeam() != null && shulker.getTeam() == this.getOwner().getTeam() || !(dist < closestDistance)) continue;
                closestDistance = dist;
                target = shulker;
            }
        }
        if (target != null && speed >= 0.1) {
            Vec3 toTarget = target.position().add(0.0, (double)(target.getBbHeight() / 2.0f), 0.0).subtract(this.position().add(0.0, (double)(this.getBbHeight() / 2.0f), 0.0));
            Vec3 currentVelocity = this.getDeltaMovement();
            double currentSpeed = currentVelocity.length();
            Vec3 desiredDirection = toTarget.normalize();
            Vec3 blendedDirection = currentVelocity.normalize().scale(0.6).add(desiredDirection.scale(0.4)).normalize();
            Vec3 newVelocity = blendedDirection.scale(currentSpeed);
            this.setDeltaMovement(newVelocity.x, currentVelocity.y * 0.98, newVelocity.z);
            this.slidingMovement = new Vec3(newVelocity.x, currentVelocity.y * 0.98, newVelocity.z);
            this.setYRot((float)(Mth.atan2((double)(-newVelocity.x), (double)newVelocity.z) * 57.29577951308232));
        }
    }
}

