/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse.entities.ai.goals;

import com.wenxin2.marioverse.entities.projectiles.BouncingFireballProjectile;
import com.wenxin2.marioverse.registries.ConfigRegistry;
import com.wenxin2.marioverse.registries.EntityRegistry;
import com.wenxin2.marioverse.registries.SoundRegistry;
import com.wenxin2.marioverse.utils.AbilitiesHandler;
import java.util.EnumSet;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class ShootBouncingFireballGoal
extends Goal {
    private final LivingEntity livingEntity;
    private final int maxFireballs;
    private final int addFireballsWithFireFlower;
    private final boolean requireFireFlower;
    private static final int FIREBALL_COOLDOWN = 5;

    public ShootBouncingFireballGoal(LivingEntity entity, int maxFireballs, int addFireballsWithFireFlower, boolean requireFireFlower) {
        this.livingEntity = entity;
        this.maxFireballs = maxFireballs;
        this.addFireballsWithFireFlower = addFireballsWithFireFlower;
        this.requireFireFlower = requireFireFlower;
        this.setFlags(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
    }

    public void start() {
        super.start();
        LivingEntity livingEntity = this.livingEntity;
        if (livingEntity instanceof Mob) {
            Mob mob = (Mob)livingEntity;
            mob.setAggressive(true);
        }
    }

    public void stop() {
        super.stop();
        LivingEntity livingEntity = this.livingEntity;
        if (livingEntity instanceof Mob) {
            Mob mob = (Mob)livingEntity;
            mob.setAggressive(false);
        }
    }

    public boolean canUse() {
        AbilitiesHandler handler;
        LivingEntity livingEntity;
        boolean canShoot = !this.requireFireFlower || (livingEntity = this.livingEntity) instanceof AbilitiesHandler && (handler = (AbilitiesHandler)livingEntity).mv$hasFireFlower();
        return this.livingEntity.getDeltaMovement().horizontalDistance() > 0.0 && canShoot;
    }

    public void tick() {
        Mob mob;
        LivingEntity target;
        AbilitiesHandler handler;
        LivingEntity golem;
        Monster monster;
        LivingEntity livingEntity;
        if (this.canUse() && ((livingEntity = this.livingEntity) instanceof Monster && (monster = (Monster)livingEntity).getTarget() != null && monster.getSensing().hasLineOfSight((Entity)monster.getTarget()) || (livingEntity = this.livingEntity) instanceof AbstractGolem && (golem = (AbstractGolem)livingEntity).getTarget() != null && golem.getSensing().hasLineOfSight((Entity)golem.getTarget()) || !(this.livingEntity instanceof Monster) && !(this.livingEntity instanceof AbstractGolem))) {
            this.handleFireballShooting();
        }
        if ((golem = this.livingEntity) instanceof AbilitiesHandler && (handler = (AbilitiesHandler)golem).mv$getFireballCooldown() > 0) {
            handler.mv$setFireballCooldown(handler.mv$getFireballCooldown() - 1);
        }
        if ((golem = this.livingEntity) instanceof Mob && (target = (mob = (Mob)golem).getTarget()) != null) {
            mob.getNavigation().moveTo((Entity)target, 1.2);
            if (mob.getControlledVehicle() instanceof Mob) {
                mob.getLookControl().setLookAt(target.getX(), target.getEyeY(), target.getZ());
            }
            mob.getLookControl().setLookAt(target.getX(), target.getEyeY(), target.getZ());
        }
        super.tick();
    }

    public void handleFireballShooting() {
        LivingEntity livingEntity = this.livingEntity;
        if (livingEntity instanceof AbilitiesHandler) {
            AbilitiesHandler handler = (AbilitiesHandler)livingEntity;
            if (!this.requireFireFlower && handler.mv$getFireballCooldown() == 0 && handler.mv$getFireballCount() < this.maxFireballs + this.addFireballsWithFireFlower) {
                this.shootFireball();
                handler.mv$setFireballCooldown(5);
                handler.mv$setFireballCount(handler.mv$getFireballCount() + 1);
            } else if (handler.mv$getFireballCooldown() == 0 && handler.mv$getFireballCount() < this.maxFireballs + this.addFireballsWithFireFlower && handler.mv$hasFireFlower()) {
                this.shootFireball();
                handler.mv$setFireballCooldown(5);
                handler.mv$setFireballCount(handler.mv$getFireballCount() + 1);
            } else if (!this.requireFireFlower && handler.mv$getFireballCount() >= this.maxFireballs + this.addFireballsWithFireFlower) {
                handler.mv$setFireballCooldown((Integer)ConfigRegistry.FIREBALL_COOLDOWN.get());
                handler.mv$setFireballCount(0);
            } else if (handler.mv$getFireballCount() >= this.maxFireballs) {
                handler.mv$setFireballCooldown((Integer)ConfigRegistry.FIREBALL_COOLDOWN.get());
                handler.mv$setFireballCount(0);
            }
        }
    }

    public void shootFireball() {
        Level world = this.livingEntity.level();
        BouncingFireballProjectile fireball = new BouncingFireballProjectile((EntityType<? extends BouncingFireballProjectile>)((EntityType)EntityRegistry.BOUNCING_FIREBALL.get()), world);
        fireball.setOwner((Entity)this.livingEntity);
        fireball.setPos(this.livingEntity.getX(), this.livingEntity.getEyeY() - 0.5, this.livingEntity.getZ());
        fireball.shootFromRotation((Entity)this.livingEntity, this.livingEntity.getXRot(), this.livingEntity.getYRot(), 0.0f, 1.2f, 1.0f);
        world.playSound(null, this.livingEntity.blockPosition(), (SoundEvent)SoundRegistry.FIREBALL_THROWN.get(), SoundSource.HOSTILE, 1.0f, 1.0f);
        Vec3 look = this.livingEntity.getLookAngle();
        fireball.setDeltaMovement(look.scale(0.5));
        fireball.setYRot((float)Math.toDegrees(Math.atan2(look.z, look.x)) + 90.0f);
        fireball.setXRot((float)Math.toDegrees(Math.atan2(look.y, Math.sqrt(look.x * look.x + look.z * look.z))));
        world.addFreshEntity((Entity)fireball);
        this.livingEntity.swing(InteractionHand.MAIN_HAND);
    }
}

