/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse.entities.power_ups;

import com.wenxin2.marioverse.entities.power_ups.AbstractPowerUpEntity;
import com.wenxin2.marioverse.registries.ItemRegistry;
import com.wenxin2.marioverse.registries.TagRegistry;
import com.wenxin2.marioverse.utils.AbilitiesHandler;
import java.util.List;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class FireFlowerEntity
extends AbstractPowerUpEntity
implements GeoEntity {
    protected static final RawAnimation IDLE_ANIM = RawAnimation.begin().thenLoop("animation.fire_flower.idle");
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public FireFlowerEntity(EntityType<? extends FireFlowerEntity> entityType, Level world) {
        super(entityType, world);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "Idle", 0, this::idleAnimController));
    }

    protected <E extends GeoAnimatable> PlayState idleAnimController(AnimationState<E> event) {
        event.setAndContinue(IDLE_ANIM);
        return PlayState.CONTINUE;
    }

    @Override
    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    @Override
    public void collideWithEntity(Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (entity instanceof AbilitiesHandler) {
                AbilitiesHandler handler = (AbilitiesHandler)entity;
                handler.applyFireFlowerPowerUp(this.level(), livingEntity, this);
            }
        }
    }

    @Override
    public TagKey<Item> getPowerUpCostumeTag() {
        return TagRegistry.FIRE_COSTUMES;
    }

    @Override
    public List<ItemStack> getPowerUpHatItems() {
        return List.of(ItemRegistry.MARIO_FIRE_HAT.toStack(), ItemRegistry.LUIGI_FIRE_HAT.toStack(), ItemRegistry.PEACH_CROWN.toStack());
    }

    @Override
    public List<ItemStack> getPowerUpShirtItems() {
        return List.of(ItemRegistry.MARIO_FIRE_SHIRT.toStack(), ItemRegistry.LUIGI_FIRE_SHIRT.toStack(), ItemRegistry.PEACH_FIRE_BODICE.toStack());
    }

    @Override
    public List<ItemStack> getPowerUpPantsItems() {
        return List.of(ItemRegistry.MARIO_FIRE_PANTS.toStack(), ItemRegistry.LUIGI_FIRE_PANTS.toStack(), ItemRegistry.PEACH_FIRE_DRESS.toStack());
    }

    @Override
    public List<ItemStack> getPowerUpShoesItems() {
        return List.of(ItemRegistry.MARIO_FIRE_SHOES.toStack(), ItemRegistry.LUIGI_FIRE_SHOES.toStack(), ItemRegistry.PEACH_FIRE_SHOES.toStack());
    }
}

