/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse.network.server_bound.handler;

import com.wenxin2.marioverse.Marioverse;
import com.wenxin2.marioverse.entities.KoopaShellEntity;
import com.wenxin2.marioverse.entities.KoopaTroopaEntity;
import com.wenxin2.marioverse.network.server_bound.data.SquashEntityPayload;
import com.wenxin2.marioverse.registries.ConfigRegistry;
import com.wenxin2.marioverse.registries.DamageSourceRegistry;
import com.wenxin2.marioverse.registries.DataAttachmentRegistry;
import com.wenxin2.marioverse.registries.ItemRegistry;
import com.wenxin2.marioverse.registries.ParticleRegistry;
import com.wenxin2.marioverse.registries.SoundRegistry;
import com.wenxin2.marioverse.registries.TagRegistry;
import com.wenxin2.marioverse.utils.AbilitiesHandler;
import com.wenxin2.marioverse.utils.ServerParticleUtils;
import io.wispforest.accessories.api.AccessoriesCapability;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.registries.DeferredItem;
import org.spongepowered.asm.mixin.Unique;

public class SquashEntityPacket {
    public static final SquashEntityPacket INSTANCE = new SquashEntityPacket();

    public static SquashEntityPacket get() {
        return INSTANCE;
    }

    public void handle(SquashEntityPayload payload, IPayloadContext context) {
        if (context.flow().isServerbound()) {
            context.enqueueWork(() -> {
                Player player = context.player();
                if (((Boolean)ConfigRegistry.ENABLE_STOMPABLE_ENEMIES.get()).booleanValue() && (player.getType().is(TagRegistry.CAN_STOMP_ENEMIES) || ((Boolean)ConfigRegistry.ALL_MOBS_CAN_STOMP.get()).booleanValue() || player.level().getGameRules().getBoolean(Marioverse.ALL_MOBS_CAN_STOMP)) && (player.fallDistance > 0.0f || player.isInWaterOrBubble())) {
                    this.squashEntity(player, payload.isHoldingJump());
                }
            });
        }
    }

    public void squashEntity(Player stompingPlayer, boolean isHoldingJump) {
        List nearbyEntities = stompingPlayer.level().getEntities((Entity)stompingPlayer, stompingPlayer.getBoundingBox().inflate(0.0, 0.5, 0.0));
        if (!nearbyEntities.isEmpty()) {
            for (Entity entity : nearbyEntities) {
                LivingEntity damagedEntity;
                if (!(entity instanceof LivingEntity) || (damagedEntity = (LivingEntity)entity).isVehicle() || !stompingPlayer.getType().is(TagRegistry.CAN_STOMP_ENEMIES) && !((Boolean)ConfigRegistry.ALL_MOBS_CAN_STOMP.get()).booleanValue() && !stompingPlayer.level().getGameRules().getBoolean(Marioverse.ALL_MOBS_CAN_STOMP) || damagedEntity.getType().is(TagRegistry.POWER_UP_ENTITIES) || !damagedEntity.getType().is(TagRegistry.CAN_BE_STOMPED) && !damagedEntity.getType().is(TagRegistry.CAN_BE_INSTAKILL_STOMPED) && !((Boolean)ConfigRegistry.STOMP_ALL_MOBS.get()).booleanValue() && !stompingPlayer.level().getGameRules().getBoolean(Marioverse.STOMP_ALL_MOBS)) continue;
                if (stompingPlayer instanceof Player) {
                    Player player = stompingPlayer;
                    if (player.getAbilities().flying) {
                        return;
                    }
                }
                if (((Boolean)stompingPlayer.getData(DataAttachmentRegistry.HAS_SUPER_STAR)).booleanValue() || ((Boolean)damagedEntity.getData(DataAttachmentRegistry.HAS_SUPER_STAR)).booleanValue()) {
                    return;
                }
                if (!(stompingPlayer.getY() >= damagedEntity.getY() + (double)damagedEntity.getEyeHeight()) || !(stompingPlayer.fallDistance > 0.0f) && !stompingPlayer.isInWaterOrBubble()) continue;
                double bounceBlockHeight = ConfigRegistry.STOMP_BOUNCE_HEIGHT.getAsDouble();
                if (isHoldingJump) {
                    bounceBlockHeight = ConfigRegistry.STOMP_BOUNCE_HEIGHT_JUMP.getAsDouble();
                }
                double gravity = 0.08;
                double bounceVelocity = Math.sqrt(2.0 * gravity * bounceBlockHeight);
                if (damagedEntity.isAlive()) {
                    stompingPlayer.setDeltaMovement(stompingPlayer.getDeltaMovement().x, bounceVelocity, stompingPlayer.getDeltaMovement().z);
                    stompingPlayer.hasImpulse = true;
                    if (stompingPlayer instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)stompingPlayer;
                        serverPlayer.connection.send((Packet)new ClientboundSetEntityMotionPacket((Entity)stompingPlayer));
                    }
                }
                float scaleFactor = damagedEntity.getBbHeight() * damagedEntity.getBbWidth();
                int numParticles = (int)(scaleFactor * 20.0f);
                double radius = damagedEntity.getBbWidth() / 2.0f;
                Level level = stompingPlayer.level();
                if (level instanceof ServerLevel) {
                    ServerLevel serverWorld = (ServerLevel)level;
                    ServerParticleUtils.spawnParticleRingAboveEntity((ParticleOptions)ParticleTypes.CRIT, serverWorld, (Entity)damagedEntity, radius, 0.0, numParticles);
                }
                boolean hasNoArmor = true;
                for (ItemStack armorSlot : damagedEntity.getArmorSlots()) {
                    if (armorSlot.isEmpty()) continue;
                    hasNoArmor = false;
                    break;
                }
                if (stompingPlayer.level().isClientSide() || damagedEntity.isDeadOrDying()) continue;
                if (damagedEntity.getType().is(TagRegistry.CAN_BE_INSTAKILL_STOMPED) && hasNoArmor) {
                    damagedEntity.hurt(DamageSourceRegistry.stomp((Entity)damagedEntity, (Entity)stompingPlayer), damagedEntity.getHealth());
                } else if (damagedEntity.getType().is(TagRegistry.CAN_BE_STOMPED) || ((Boolean)ConfigRegistry.STOMP_ALL_MOBS.get()).booleanValue() || damagedEntity.level().getGameRules().getBoolean(Marioverse.STOMP_ALL_MOBS)) {
                    if (damagedEntity instanceof KoopaTroopaEntity || damagedEntity instanceof KoopaShellEntity) {
                        damagedEntity.hurt(DamageSourceRegistry.stomp((Entity)damagedEntity, (Entity)stompingPlayer), 0.0f);
                    } else {
                        damagedEntity.hurt(DamageSourceRegistry.stomp((Entity)damagedEntity, (Entity)stompingPlayer), ((Double)ConfigRegistry.STOMP_DAMAGE.get()).floatValue());
                    }
                }
                if (((Boolean)ConfigRegistry.DISABLE_CONSECUTIVE_BOUNCING.get()).booleanValue()) break;
                this.consecutiveReward(stompingPlayer, damagedEntity);
                break;
            }
        }
    }

    @Unique
    public void consecutiveReward(Player attackingPlayer, LivingEntity damagedEntity) {
        if (attackingPlayer instanceof AbilitiesHandler) {
            AbilitiesHandler handler = (AbilitiesHandler)attackingPlayer;
            int oneUpsRewarded = handler.mv$getOneUpsRewarded();
            int consecutiveBounces = handler.mv$getConsecutiveBounces();
            handler.mv$setConsecutiveBounces(consecutiveBounces + 1);
            if (consecutiveBounces == 0) {
                if (!((Boolean)ConfigRegistry.DISABLE_REWARD_PARTICLES.get()).booleanValue()) {
                    Level level = damagedEntity.level();
                    if (level instanceof ServerLevel) {
                        ServerLevel serverWorld = (ServerLevel)level;
                        ServerParticleUtils.spawnRewardParticle((ParticleOptions)ParticleRegistry.GOOD.get(), serverWorld, (Entity)damagedEntity, 1.0);
                    }
                } else {
                    attackingPlayer.displayClientMessage((Component)Component.translatable((String)"display.marioverse.consecutive_bounce.good"), Boolean.TRUE.booleanValue());
                }
            } else if (consecutiveBounces == 1) {
                if (!((Boolean)ConfigRegistry.DISABLE_REWARD_PARTICLES.get()).booleanValue()) {
                    Level level = damagedEntity.level();
                    if (level instanceof ServerLevel) {
                        ServerLevel serverWorld = (ServerLevel)level;
                        ServerParticleUtils.spawnRewardParticle((ParticleOptions)ParticleRegistry.GREAT.get(), serverWorld, (Entity)damagedEntity, 1.0);
                    }
                } else {
                    attackingPlayer.displayClientMessage((Component)Component.translatable((String)"display.marioverse.consecutive_bounce.great"), Boolean.TRUE.booleanValue());
                }
            } else if (consecutiveBounces == 2) {
                if (!((Boolean)ConfigRegistry.DISABLE_REWARD_PARTICLES.get()).booleanValue()) {
                    Level level = damagedEntity.level();
                    if (level instanceof ServerLevel) {
                        ServerLevel serverWorld = (ServerLevel)level;
                        ServerParticleUtils.spawnRewardParticle((ParticleOptions)ParticleRegistry.SUPER.get(), serverWorld, (Entity)damagedEntity, 1.0);
                    }
                } else {
                    attackingPlayer.displayClientMessage((Component)Component.translatable((String)"display.marioverse.consecutive_bounce.super"), Boolean.TRUE.booleanValue());
                }
            } else if (consecutiveBounces == 3) {
                if (!((Boolean)ConfigRegistry.DISABLE_REWARD_PARTICLES.get()).booleanValue()) {
                    Level level = damagedEntity.level();
                    if (level instanceof ServerLevel) {
                        ServerLevel serverWorld = (ServerLevel)level;
                        ServerParticleUtils.spawnRewardParticle((ParticleOptions)ParticleRegistry.FANTASTIC.get(), serverWorld, (Entity)damagedEntity, 1.0);
                    }
                } else {
                    attackingPlayer.displayClientMessage((Component)Component.translatable((String)"display.marioverse.consecutive_bounce.fantastic"), Boolean.TRUE.booleanValue());
                }
            } else if (consecutiveBounces == 4) {
                if (!((Boolean)ConfigRegistry.DISABLE_REWARD_PARTICLES.get()).booleanValue()) {
                    Level level = damagedEntity.level();
                    if (level instanceof ServerLevel) {
                        ServerLevel serverWorld = (ServerLevel)level;
                        ServerParticleUtils.spawnRewardParticle((ParticleOptions)ParticleRegistry.EXCELLENT.get(), serverWorld, (Entity)damagedEntity, 1.0);
                    }
                } else {
                    attackingPlayer.displayClientMessage((Component)Component.translatable((String)"display.marioverse.consecutive_bounce.excellent"), Boolean.TRUE.booleanValue());
                }
            } else if (consecutiveBounces == 5) {
                if (!((Boolean)ConfigRegistry.DISABLE_REWARD_PARTICLES.get()).booleanValue()) {
                    Level level = damagedEntity.level();
                    if (level instanceof ServerLevel) {
                        ServerLevel serverWorld = (ServerLevel)level;
                        ServerParticleUtils.spawnRewardParticle((ParticleOptions)ParticleRegistry.INCREDIBLE.get(), serverWorld, (Entity)damagedEntity, 1.0);
                    }
                } else {
                    attackingPlayer.displayClientMessage((Component)Component.translatable((String)"display.marioverse.consecutive_bounce.incredible"), Boolean.TRUE.booleanValue());
                }
            } else if (consecutiveBounces == 6) {
                if (!((Boolean)ConfigRegistry.DISABLE_REWARD_PARTICLES.get()).booleanValue()) {
                    Level level = damagedEntity.level();
                    if (level instanceof ServerLevel) {
                        ServerLevel serverWorld = (ServerLevel)level;
                        ServerParticleUtils.spawnRewardParticle((ParticleOptions)ParticleRegistry.WONDERFUL.get(), serverWorld, (Entity)damagedEntity, 1.0);
                    }
                } else {
                    attackingPlayer.displayClientMessage((Component)Component.translatable((String)"display.marioverse.consecutive_bounce.wonderful"), Boolean.TRUE.booleanValue());
                }
            } else if (consecutiveBounces >= 7 && (Integer)ConfigRegistry.MAX_ONE_UP_BOUNCE_REWARD.get() > oneUpsRewarded) {
                handler.mv$setOneUpsRewarded(oneUpsRewarded + 1);
                this.bounceReward(attackingPlayer);
                if (!((Boolean)ConfigRegistry.DISABLE_REWARD_PARTICLES.get()).booleanValue()) {
                    Level level = damagedEntity.level();
                    if (level instanceof ServerLevel) {
                        ServerLevel serverWorld = (ServerLevel)level;
                        ServerParticleUtils.spawnRewardParticle((ParticleOptions)ParticleRegistry.ONE_UP.get(), serverWorld, (Entity)damagedEntity, 1.0);
                    }
                } else {
                    attackingPlayer.displayClientMessage((Component)Component.translatable((String)"display.marioverse.consecutive_bounce.one_up"), Boolean.TRUE.booleanValue());
                }
            }
        }
    }

    @Unique
    public void bounceReward(Player player) {
        DeferredItem<Item> item = ItemRegistry.ONE_UP_MUSHROOM;
        if (!player.isSpectator()) {
            AccessoriesCapability capability = AccessoriesCapability.get((LivingEntity)player);
            ItemStack offhandStack = player.getOffhandItem();
            if (capability != null && !capability.isEquipped((Item)ItemRegistry.ONE_UP_MUSHROOM.get())) {
                capability.attemptToEquipAccessory(new ItemStack((ItemLike)ItemRegistry.ONE_UP_MUSHROOM.get()));
            } else if (offhandStack.isEmpty()) {
                player.setItemSlot(EquipmentSlot.OFFHAND, new ItemStack(item));
            } else if (offhandStack.getCount() >= 1) {
                player.addItem(new ItemStack((ItemLike)ItemRegistry.ONE_UP_MUSHROOM.get()));
            }
            player.level().playSound(null, player.blockPosition(), (SoundEvent)SoundRegistry.ONE_UP_COLLECTED.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }
}

