/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.client.gui.overlay;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTextureView;
import net.jitl.client.essence.ClientEssence;
import net.jitl.common.entity.projectile.EssenceArrowEntity;
import net.jitl.common.items.base.JBowItem;
import net.jitl.core.config.JClientConfig;
import net.jitl.core.config.enums.EssencePosition;
import net.jitl.core.helper.IEssenceItem;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.neoforged.neoforge.client.gui.GuiLayer;
import org.jetbrains.annotations.NotNull;

public class EssenceBar
implements GuiLayer {
    private static float transparency;
    private static float burnoutTransparency;
    private static final ResourceLocation UNDER_CROSSHAIR_TEXTURE;
    private static final ResourceLocation OVER_EXP_TEXTURE;
    private static final ResourceLocation ABOVE_HUNGER_TEXTURE;

    public void render(@NotNull GuiGraphics gui, DeltaTracker tracker) {
        Minecraft minecraft = Minecraft.getInstance();
        LocalPlayer player = minecraft.player;
        RenderSystem.setShaderTexture((int)0, (GpuTextureView)minecraft.getTextureManager().getTexture(OVER_EXP_TEXTURE).getTextureView());
        if (player != null && !player.isCreative() && !player.isSpectator()) {
            boolean cooldownActive;
            boolean isEssenceUsed;
            float currentEssence = ClientEssence.getCurrentClientEssence();
            float maxEssence = ClientEssence.getMaxClientEssence();
            float cooldown = ClientEssence.getClientEssenceBurnout();
            boolean bl = isEssenceUsed = currentEssence < maxEssence;
            if ((EssenceBar.instanceOfEssenceItem(player.getMainHandItem().getItem()) || isEssenceUsed) && (double)transparency <= 1.0) {
                transparency += 0.02f;
            } else if (transparency > 0.0f) {
                transparency -= 0.02f;
            }
            boolean bl2 = cooldownActive = cooldown > 1.0f;
            if (cooldownActive && burnoutTransparency < 1.0f) {
                burnoutTransparency += 0.02f;
            } else if (burnoutTransparency > 0.0f) {
                burnoutTransparency -= 0.02f;
            }
            JClientConfig config = new JClientConfig();
            EssencePosition essencePosition = config.getEssencePosition();
            int yPos = config.getEssenceYPos();
            int xPos = config.getEssenceXPos();
            if (!minecraft.options.hideGui && transparency > 0.0f && !player.isSpectator()) {
                LivingEntity livingentity;
                int vehicalMaxhearts;
                boolean isUnderwater;
                boolean belowCrosshair = essencePosition == EssencePosition.BELOW_CROSSHAIR;
                int screenHeight = gui.guiHeight();
                int screenWidth = gui.guiWidth();
                int crosshairY = screenHeight / 2;
                int crosshairX = screenWidth / 2;
                int y = belowCrosshair ? crosshairY : screenHeight - yPos;
                int x = belowCrosshair ? crosshairX : screenWidth / 2 - xPos;
                boolean aboveHunger = essencePosition == EssencePosition.ABOVE_HUNGER_BAR;
                boolean bl3 = isUnderwater = player.isEyeInFluid(FluidTags.WATER) || Math.min(player.getAirSupply(), player.getMaxAirSupply()) < player.getMaxAirSupply();
                if (isUnderwater && aboveHunger) {
                    y -= 10;
                }
                if ((vehicalMaxhearts = EssenceBar.getVehicleMaxHearts(livingentity = EssenceBar.getPlayerVehicleWithHealth((Player)player))) > 0 && aboveHunger) {
                    int heartRows = (int)Math.ceil((double)vehicalMaxhearts / 10.0) - 1;
                    y -= heartRows * 10;
                }
                gui.pose().pushMatrix();
                if (belowCrosshair) {
                    float scale = 0.5f;
                    float widthTranslation = (float)screenWidth / 2.0f - 42.0f;
                    float heightTranslation = (float)screenHeight / 2.0f + 42.0f;
                    gui.pose().translate(widthTranslation, heightTranslation);
                    gui.pose().scale(scale, scale);
                    gui.pose().translate(-widthTranslation, -heightTranslation);
                }
                float addedAlpha = belowCrosshair ? 0.5f : 0.0f;
                RenderSystem.setShaderTexture((int)0, (GpuTextureView)minecraft.getTextureManager().getTexture(EssenceBar.getTextureBasedOnPosition(essencePosition)).getTextureView());
                boolean renderSmall = essencePosition == EssencePosition.OVER_EXPERIENCE_BAR || essencePosition == EssencePosition.BELOW_CROSSHAIR;
                int barHeight = renderSmall ? 5 : 9;
                int texHeight = renderSmall ? 15 : 27;
                int backgroundVOffset = renderSmall ? 5 : 9;
                int burnoutVOffset = renderSmall ? 10 : 18;
                gui.blit(RenderPipelines.GUI_TEXTURED, EssenceBar.getTextureBasedOnPosition(essencePosition), x, y, 0.0f, (float)backgroundVOffset, 81, barHeight, 81, texHeight);
                if (cooldownActive) {
                    float sin = (float)Math.sin((float)player.tickCount / 5.0f) / 2.0f + 0.5f;
                    float cooldownFade = Math.min(cooldown, 10.0f) / 10.0f;
                    gui.blit(RenderPipelines.GUI_TEXTURED, EssenceBar.getTextureBasedOnPosition(essencePosition), x, y, 0.0f, 0.0f, 81, barHeight, 81, texHeight);
                } else {
                    int i = (int)(currentEssence / maxEssence * 81.0f);
                    gui.blit(RenderPipelines.GUI_TEXTURED, EssenceBar.getTextureBasedOnPosition(essencePosition), x, y, 0.0f, 0.0f, i, barHeight, 81, texHeight);
                }
                if (burnoutTransparency > 0.0f) {
                    gui.blit(RenderPipelines.GUI_TEXTURED, EssenceBar.getTextureBasedOnPosition(essencePosition), x, y, 0.0f, (float)burnoutVOffset, 81, barHeight, 81, texHeight);
                }
                gui.pose().popMatrix();
            }
        }
    }

    private static boolean instanceOfEssenceItem(Item isEssence) {
        boolean essenceBow = false;
        if (isEssence instanceof JBowItem) {
            JBowItem bow = (JBowItem)isEssence;
            if (bow.effect.contains((Object)EssenceArrowEntity.BowEffects.CONSUMES_ESSENCE)) {
                essenceBow = true;
            }
        }
        return isEssence instanceof IEssenceItem || essenceBow;
    }

    private static ResourceLocation getTextureBasedOnPosition(EssencePosition essencePosition) {
        if (essencePosition == EssencePosition.OVER_EXPERIENCE_BAR) {
            return OVER_EXP_TEXTURE;
        }
        if (essencePosition == EssencePosition.BELOW_CROSSHAIR) {
            return UNDER_CROSSHAIR_TEXTURE;
        }
        return ABOVE_HUNGER_TEXTURE;
    }

    private static int getVehicleMaxHearts(LivingEntity mountEntity) {
        if (mountEntity != null && mountEntity.showVehicleHealth()) {
            float maxHealth = mountEntity.getMaxHealth();
            int i = (int)(maxHealth + 0.5f) / 2;
            if (i > 30) {
                i = 30;
            }
            return i;
        }
        return 0;
    }

    private static LivingEntity getPlayerVehicleWithHealth(Player player) {
        if (player != null) {
            Entity entity = player.getVehicle();
            if (entity == null) {
                return null;
            }
            if (entity instanceof LivingEntity) {
                return (LivingEntity)entity;
            }
        }
        return null;
    }

    static {
        UNDER_CROSSHAIR_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"jitl", (String)"textures/gui/essence_under_crosshair.png");
        OVER_EXP_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"jitl", (String)"textures/gui/essence_over_exp.png");
        ABOVE_HUNGER_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"jitl", (String)"textures/gui/essence_over_hunger.png");
    }
}

