/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.client.gui.overlay;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTextureView;
import java.util.List;
import net.jitl.client.gui.overlay.helper.JDisplayInfo;
import net.jitl.client.gui.overlay.helper.JFrameType;
import net.jitl.client.gui.overlay.helper.JToast;
import net.jitl.client.knowledge.EnumKnowledge;
import net.jitl.core.helper.internal.ArgbColor;
import net.jitl.core.init.JITL;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.components.toasts.ToastManager;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

public class KnowledgeToast
implements JToast {
    private final EnumKnowledge knowledge;
    private boolean playedSound;
    private final boolean isLevel;
    private final ResourceLocation KNOWLEDGE_SPRITE = JITL.rl("textures/gui/knowledge/knowledge_sprites.png");
    private Toast.Visibility wantedVisibility = Toast.Visibility.HIDE;

    public KnowledgeToast(EnumKnowledge knowledge, boolean isLevel) {
        this.knowledge = knowledge;
        this.isLevel = isLevel;
    }

    @NotNull
    public Toast.Visibility getWantedVisibility() {
        return this.wantedVisibility;
    }

    public void update(ToastManager toastManager, long l) {
    }

    @Override
    public void render(GuiGraphics poseStack, Font font, long timeSinceLastVisible) {
        RenderSystem.setShaderTexture((int)0, (GpuTextureView)Minecraft.getInstance().getTextureManager().getTexture(TEXTURE).getTextureView());
        JDisplayInfo displayinfo = this.isLevel ? this.knowledge.getLevelDisplay() : this.knowledge.getXPDisplay();
        poseStack.blitSprite(RenderPipelines.GUI_TEXTURED, TEXTURE, 0, 0, this.width(), this.height());
        if (displayinfo != null) {
            int i;
            List list = font.split((FormattedText)displayinfo.getDescription(), 125);
            int n = i = displayinfo.getFrame() == JFrameType.LEVEL ? ArgbColor.from(ChatFormatting.DARK_PURPLE) : ARGB.colorFromFloat((float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f);
            if (list.size() == 1) {
                poseStack.drawString(font, displayinfo.getFrame().getDisplayName(), 30, 18, i, false);
                poseStack.drawString(font, (FormattedCharSequence)list.get(0), 30, 7, ArgbColor.from(ChatFormatting.BLACK), false);
            } else if (timeSinceLastVisible < 1500L) {
                int k = Mth.floor((float)(Mth.clamp((float)((float)(1500L - timeSinceLastVisible) / 300.0f), (float)0.0f, (float)1.0f) * 255.0f)) << 24 | 0x4000000;
                poseStack.drawString(font, displayinfo.getFrame().getDisplayName(), 30, 11, i | k, false);
            } else {
                int i1 = Mth.floor((float)(Mth.clamp((float)((float)(timeSinceLastVisible - 1500L) / 300.0f), (float)0.0f, (float)1.0f) * 252.0f)) << 24 | 0x4000000;
                int l = this.height() / 2 - list.size() * 9 / 2;
                for (FormattedCharSequence formattedcharsequence : list) {
                    poseStack.drawString(font, formattedcharsequence, 30, l, 0xFFFFFF | i1, false);
                    l += 9;
                }
            }
            if (!this.playedSound && timeSinceLastVisible > 0L) {
                this.playedSound = true;
                if (displayinfo.getFrame() == JFrameType.LEVEL) {
                    // empty if block
                }
                if (displayinfo.getFrame() == JFrameType.XP) {
                    // empty if block
                }
            }
            float scale = 0.8f;
            float translate = 2.5f;
            poseStack.pose().pushMatrix();
            poseStack.pose().scale(scale, scale);
            poseStack.pose().translate(translate, translate);
            RenderSystem.setShaderTexture((int)0, (GpuTextureView)Minecraft.getInstance().getTextureManager().getTexture(this.KNOWLEDGE_SPRITE).getTextureView());
            poseStack.blitSprite(RenderPipelines.GUI_TEXTURED, this.KNOWLEDGE_SPRITE, this.knowledge.getSpriteX(), this.knowledge.getSpriteY(), 32, 32);
            poseStack.pose().popMatrix();
        }
    }
}

