/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.client.gui.overlay;

import net.jitl.common.capability.player.Portal;
import net.jitl.core.init.internal.JDataAttachments;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.EmptyBlockAndTintGetter;
import net.neoforged.neoforge.client.gui.GuiLayer;
import org.jetbrains.annotations.NotNull;

public class PortalOverlayRenderer
implements GuiLayer {
    public void render(@NotNull GuiGraphics pGuiGraphics, @NotNull DeltaTracker deltaTracker) {
        Portal playerPortalOverlay;
        float timeInPortal;
        Minecraft minecraft = Minecraft.getInstance();
        int screenWidth = minecraft.getWindow().getGuiScaledWidth();
        int screenHeight = minecraft.getWindow().getGuiScaledHeight();
        LocalPlayer player = minecraft.player;
        if (player != null && (timeInPortal = (playerPortalOverlay = (Portal)player.getData(JDataAttachments.PORTAL_OVERLAY)).getOldPortalOverlayTime() * 1.45f + (playerPortalOverlay.getPortalOverlayTime() - playerPortalOverlay.getOldPortalOverlayTime()) * deltaTracker.getGameTimeDeltaTicks()) > 0.0f) {
            if (timeInPortal < 1.0f) {
                timeInPortal *= timeInPortal;
                timeInPortal *= timeInPortal;
                timeInPortal = timeInPortal * 0.8f + 0.2f;
            }
            pGuiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, minecraft.getBlockRenderer().getBlockModelShaper().getParticleIcon(playerPortalOverlay.getPortalBlockToRender().defaultBlockState(), (BlockAndTintGetter)EmptyBlockAndTintGetter.INSTANCE, BlockPos.ZERO), 0, 0, pGuiGraphics.guiWidth(), pGuiGraphics.guiHeight());
            pGuiGraphics.drawCenteredString(minecraft.font, (Component)Component.translatable((String)"multiplayer.downloadingTerrain"), screenWidth / 2, screenHeight / 2 - 50, -1);
        }
    }
}

