/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.client.render.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import it.unimi.dsi.fastutil.floats.Float2FloatFunction;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import javax.annotation.Nullable;
import net.jitl.client.JModelLayers;
import net.jitl.client.render.block.state.JChestRenderState;
import net.jitl.common.block.JChestBlock;
import net.jitl.common.block.entity.JChestBlockEntity;
import net.jitl.core.init.JITL;
import net.jitl.core.init.internal.JBlocks;
import net.jitl.core.init.internal.JItems;
import net.minecraft.client.model.ChestModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.renderer.MaterialMapper;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.BrightnessCombiner;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.MaterialSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.DoubleBlockCombiner;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.LidBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionfc;

public class JChestRenderer<T extends BlockEntity>
implements BlockEntityRenderer<T, JChestRenderState> {
    private final ChestModel singleModel;
    private final ChestModel doubleLeftModel;
    private final ChestModel doubleRightModel;
    private final ItemModelResolver renderEntity;
    private final MaterialSet materials;
    public static final MaterialMapper CHEST_MAPPER = new MaterialMapper(Sheets.CHEST_SHEET, "entity/chest");
    public static final Material BOILING_CHEST_LOCATION = CHEST_MAPPER.apply(JITL.rl("boiling_chest"));
    public static final Material BOILING_CHEST_LOCATION_LEFT = CHEST_MAPPER.apply(JITL.rl("boiling_chest_left"));
    public static final Material BOILING_CHEST_LOCATION_RIGHT = CHEST_MAPPER.apply(JITL.rl("boiling_chest_right"));
    public static final Material CLOUDIA_CHEST_LOCATION = CHEST_MAPPER.apply(JITL.rl("cloudia_chest"));
    public static final Material CLOUDIA_CHEST_LOCATION_LEFT = CHEST_MAPPER.apply(JITL.rl("cloudia_chest_left"));
    public static final Material CLOUDIA_CHEST_LOCATION_RIGHT = CHEST_MAPPER.apply(JITL.rl("cloudia_chest_right"));
    public static final Material CORBA_CHEST_LOCATION = CHEST_MAPPER.apply(JITL.rl("corba_chest"));
    public static final Material CORBA_CHEST_LOCATION_LEFT = CHEST_MAPPER.apply(JITL.rl("corba_chest_left"));
    public static final Material CORBA_CHEST_LOCATION_RIGHT = CHEST_MAPPER.apply(JITL.rl("corba_chest_right"));
    public static final Material DEPTHS_CHEST_LOCATION = CHEST_MAPPER.apply(JITL.rl("depths_chest"));
    public static final Material DEPTHS_CHEST_LOCATION_LEFT = CHEST_MAPPER.apply(JITL.rl("depths_chest_left"));
    public static final Material DEPTHS_CHEST_LOCATION_RIGHT = CHEST_MAPPER.apply(JITL.rl("depths_chest_right"));
    public static final Material EUCA_CHEST_LOCATION = CHEST_MAPPER.apply(JITL.rl("euca_chest"));
    public static final Material EUCA_CHEST_LOCATION_LEFT = CHEST_MAPPER.apply(JITL.rl("euca_chest_left"));
    public static final Material EUCA_CHEST_LOCATION_RIGHT = CHEST_MAPPER.apply(JITL.rl("euca_chest_right"));
    public static final Material FROZEN_CHEST_LOCATION = CHEST_MAPPER.apply(JITL.rl("frozen_chest"));
    public static final Material FROZEN_CHEST_LOCATION_LEFT = CHEST_MAPPER.apply(JITL.rl("frozen_chest_left"));
    public static final Material FROZEN_CHEST_LOCATION_RIGHT = CHEST_MAPPER.apply(JITL.rl("frozen_chest_right"));
    public static final Material JOURNEY_CHEST_LOCATION = CHEST_MAPPER.apply(JITL.rl("journey_chest"));
    public static final Material JOURNEY_CHEST_LOCATION_LEFT = CHEST_MAPPER.apply(JITL.rl("journey_chest_left"));
    public static final Material JOURNEY_CHEST_LOCATION_RIGHT = CHEST_MAPPER.apply(JITL.rl("journey_chest_right"));
    public static final Material NETHER_CHEST_LOCATION = CHEST_MAPPER.apply(JITL.rl("nether_chest"));
    public static final Material NETHER_CHEST_LOCATION_LEFT = CHEST_MAPPER.apply(JITL.rl("nether_chest_left"));
    public static final Material NETHER_CHEST_LOCATION_RIGHT = CHEST_MAPPER.apply(JITL.rl("nether_chest_right"));
    public static final Material SENTERIAN_CHEST_LOCATION = CHEST_MAPPER.apply(JITL.rl("senterian_chest"));
    public static final Material SENTERIAN_CHEST_LOCATION_LEFT = CHEST_MAPPER.apply(JITL.rl("senterian_chest_left"));
    public static final Material SENTERIAN_CHEST_LOCATION_RIGHT = CHEST_MAPPER.apply(JITL.rl("senterian_chest_right"));
    public static final Material TERRANIAN_CHEST_LOCATION = CHEST_MAPPER.apply(JITL.rl("terranian_chest"));
    public static final Material TERRANIAN_CHEST_LOCATION_LEFT = CHEST_MAPPER.apply(JITL.rl("terranian_chest_left"));
    public static final Material TERRANIAN_CHEST_LOCATION_RIGHT = CHEST_MAPPER.apply(JITL.rl("terranian_chest_right"));

    public JChestRenderer(BlockEntityRendererProvider.Context context) {
        this.materials = context.materials();
        this.singleModel = new ChestModel(context.bakeLayer(JModelLayers.JCHEST));
        this.doubleLeftModel = new ChestModel(context.bakeLayer(JModelLayers.JDOUBLE_CHEST_LEFT));
        this.doubleRightModel = new ChestModel(context.bakeLayer(JModelLayers.JDOUBLE_CHEST_RIGHT));
        this.renderEntity = context.itemModelResolver();
    }

    public static Material chooseMaterial(JChestRenderState.JChestMaterialType materialType, ChestType chestType) {
        return switch (materialType) {
            default -> throw new MatchException(null, null);
            case JChestRenderState.JChestMaterialType.BOILING -> JChestRenderer.chooseMaterial(chestType, BOILING_CHEST_LOCATION, BOILING_CHEST_LOCATION_LEFT, BOILING_CHEST_LOCATION_RIGHT);
            case JChestRenderState.JChestMaterialType.CLOUDIA -> JChestRenderer.chooseMaterial(chestType, CLOUDIA_CHEST_LOCATION, CLOUDIA_CHEST_LOCATION_LEFT, CLOUDIA_CHEST_LOCATION_RIGHT);
            case JChestRenderState.JChestMaterialType.CORBA -> JChestRenderer.chooseMaterial(chestType, CORBA_CHEST_LOCATION, CORBA_CHEST_LOCATION_LEFT, CORBA_CHEST_LOCATION_RIGHT);
            case JChestRenderState.JChestMaterialType.DEPTHS -> JChestRenderer.chooseMaterial(chestType, DEPTHS_CHEST_LOCATION, DEPTHS_CHEST_LOCATION_LEFT, DEPTHS_CHEST_LOCATION_RIGHT);
            case JChestRenderState.JChestMaterialType.EUCA -> JChestRenderer.chooseMaterial(chestType, EUCA_CHEST_LOCATION, EUCA_CHEST_LOCATION_LEFT, EUCA_CHEST_LOCATION_RIGHT);
            case JChestRenderState.JChestMaterialType.NETHER -> JChestRenderer.chooseMaterial(chestType, NETHER_CHEST_LOCATION, NETHER_CHEST_LOCATION_LEFT, NETHER_CHEST_LOCATION_RIGHT);
            case JChestRenderState.JChestMaterialType.FROZEN -> JChestRenderer.chooseMaterial(chestType, FROZEN_CHEST_LOCATION, FROZEN_CHEST_LOCATION_LEFT, FROZEN_CHEST_LOCATION_RIGHT);
            case JChestRenderState.JChestMaterialType.SENTERIAN -> JChestRenderer.chooseMaterial(chestType, SENTERIAN_CHEST_LOCATION, SENTERIAN_CHEST_LOCATION_LEFT, SENTERIAN_CHEST_LOCATION_RIGHT);
            case JChestRenderState.JChestMaterialType.TERRANIAN -> JChestRenderer.chooseMaterial(chestType, TERRANIAN_CHEST_LOCATION, TERRANIAN_CHEST_LOCATION_LEFT, TERRANIAN_CHEST_LOCATION_RIGHT);
            case JChestRenderState.JChestMaterialType.JOURNEY -> JChestRenderer.chooseMaterial(chestType, JOURNEY_CHEST_LOCATION, JOURNEY_CHEST_LOCATION_LEFT, JOURNEY_CHEST_LOCATION_RIGHT);
        };
    }

    private JChestRenderState.JChestMaterialType getChestMaterial(BlockEntity e) {
        Block chest = e.getBlockState().getBlock();
        JChestRenderState.JChestMaterialType type = JChestRenderState.JChestMaterialType.JOURNEY;
        if (chest == JBlocks.JOURNEY_CHEST.get()) {
            type = JChestRenderState.JChestMaterialType.JOURNEY;
        }
        if (chest == JBlocks.EUCA_CHEST.get()) {
            type = JChestRenderState.JChestMaterialType.EUCA;
        }
        if (chest == JBlocks.FROZEN_CHEST.get()) {
            type = JChestRenderState.JChestMaterialType.FROZEN;
        }
        if (chest == JBlocks.BOIL_CHEST.get()) {
            type = JChestRenderState.JChestMaterialType.BOILING;
        }
        if (chest == JBlocks.NETHER_CHEST.get()) {
            type = JChestRenderState.JChestMaterialType.NETHER;
        }
        if (chest == JBlocks.DEPTHS_CHEST.get()) {
            type = JChestRenderState.JChestMaterialType.DEPTHS;
        }
        if (chest == JBlocks.CORBA_CHEST.get()) {
            type = JChestRenderState.JChestMaterialType.CORBA;
        }
        if (chest == JBlocks.TERRANIAN_CHEST.get()) {
            type = JChestRenderState.JChestMaterialType.TERRANIAN;
        }
        if (chest == JBlocks.CLOUDIA_CHEST.get()) {
            type = JChestRenderState.JChestMaterialType.CLOUDIA;
        }
        if (chest == JBlocks.SENTERIAN_CHEST.get()) {
            type = JChestRenderState.JChestMaterialType.CLOUDIA;
        }
        return type;
    }

    private static Material chooseMaterial(ChestType chestType, Material doubleMaterial, Material leftMaterial, Material rightMaterial) {
        return switch (chestType) {
            case ChestType.LEFT -> leftMaterial;
            case ChestType.RIGHT -> rightMaterial;
            default -> doubleMaterial;
        };
    }

    @NotNull
    public JChestRenderState createRenderState() {
        return new JChestRenderState();
    }

    public void extractRenderState(T tile, JChestRenderState render, float tick, Vec3 vec, @Nullable ModelFeatureRenderer.CrumblingOverlay overlay) {
        DoubleBlockCombiner.NeighborCombineResult<? extends JChestBlockEntity> neighborcombineresult;
        Block var10;
        super.extractRenderState(tile, (BlockEntityRenderState)render, tick, vec, overlay);
        boolean flag = tile.getLevel() != null;
        BlockState blockstate = tile.getBlockState();
        render.type = blockstate.hasProperty(JChestBlock.TYPE) ? (ChestType)blockstate.getValue(JChestBlock.TYPE) : ChestType.SINGLE;
        render.angle = ((Direction)blockstate.getValue(JChestBlock.FACING)).toYRot();
        render.material = this.getChestMaterial((BlockEntity)tile);
        render.facingYAngle = ((Direction)tile.getBlockState().getValue(JChestBlock.FACING)).toYRot();
        render.isLocked = (Boolean)tile.getBlockState().getValue((Property)JChestBlock.IS_LOCKED);
        ItemStackRenderState itemstackrenderstate = new ItemStackRenderState();
        this.renderEntity.updateForTopItem(itemstackrenderstate, new ItemStack((ItemLike)JItems.PADLOCK.get()), ItemDisplayContext.GROUND, tile.getLevel(), null, (int)tile.getBlockPos().asLong());
        render.item = itemstackrenderstate;
        if (flag && (var10 = blockstate.getBlock()) instanceof JChestBlock) {
            JChestBlock chestblock = (JChestBlock)var10;
            neighborcombineresult = chestblock.combine(blockstate, tile.getLevel(), tile.getBlockPos(), true);
        } else {
            neighborcombineresult = DoubleBlockCombiner.Combiner::acceptNone;
        }
        render.open = ((Float2FloatFunction)neighborcombineresult.apply(ChestBlock.opennessCombiner((LidBlockEntity)((LidBlockEntity)tile)))).get(tick);
        if (render.type != ChestType.SINGLE) {
            render.lightCoords = ((Int2IntFunction)neighborcombineresult.apply((DoubleBlockCombiner.Combiner)new BrightnessCombiner())).applyAsInt(render.lightCoords);
        }
    }

    public void submit(JChestRenderState render, PoseStack stack, SubmitNodeCollector node, CameraRenderState renderState) {
        stack.pushPose();
        stack.translate(0.5f, 0.5f, 0.5f);
        stack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(-render.angle));
        stack.translate(-0.5f, -0.5f, -0.5f);
        float f = render.open;
        f = 1.0f - f;
        f = 1.0f - f * f * f;
        Material material = JChestRenderer.chooseMaterial(render.material, render.type);
        RenderType rendertype = material.renderType(RenderType::entityCutout);
        TextureAtlasSprite textureatlassprite = this.materials.get(material);
        if (render.type != ChestType.SINGLE) {
            if (render.type == ChestType.LEFT) {
                node.submitModel((Model)this.doubleLeftModel, (Object)Float.valueOf(f), stack, rendertype, render.lightCoords, OverlayTexture.NO_OVERLAY, -1, textureatlassprite, 0, render.breakProgress);
            } else {
                node.submitModel((Model)this.doubleRightModel, (Object)Float.valueOf(f), stack, rendertype, render.lightCoords, OverlayTexture.NO_OVERLAY, -1, textureatlassprite, 0, render.breakProgress);
            }
        } else {
            node.submitModel((Model)this.singleModel, (Object)Float.valueOf(f), stack, rendertype, render.lightCoords, OverlayTexture.NO_OVERLAY, -1, textureatlassprite, 0, render.breakProgress);
        }
        stack.popPose();
        if (render.isLocked) {
            if (render.type != ChestType.SINGLE) {
                if (render.type == ChestType.LEFT) {
                    this.renderItem(render, new double[]{0.0, 0.2, 0.945}, stack, node);
                } else {
                    this.renderItem(render, new double[]{1.0, 0.2, 0.945}, stack, node);
                }
            } else {
                this.renderItem(render, new double[]{0.5, 0.2, 0.945}, stack, node);
            }
        }
    }

    public @NotNull AABB getRenderBoundingBox(T blockEntity) {
        BlockPos pos = blockEntity.getBlockPos();
        return AABB.encapsulatingFullBlocks((BlockPos)pos.offset(-1, 0, -1), (BlockPos)pos.offset(1, 1, 1));
    }

    private void renderItem(JChestRenderState state, double[] translation, PoseStack matrixStack, SubmitNodeCollector collector) {
        ItemStackRenderState item = state.item;
        if (!item.isEmpty()) {
            matrixStack.pushPose();
            float f = state.facingYAngle;
            matrixStack.translate(0.5, 0.5, 0.5);
            matrixStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(-f));
            matrixStack.translate(-0.5, -0.5, -0.5);
            matrixStack.translate(translation[0], translation[1], translation[2]);
            float scale = 1.0f;
            matrixStack.scale(scale, scale, scale + 0.15f);
            item.submit(matrixStack, collector, state.lightCoords, OverlayTexture.NO_OVERLAY, 0);
            matrixStack.popPose();
        }
    }
}

