/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.client.render.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.ArrayList;
import net.jitl.client.render.block.state.SummoningTableRenderState;
import net.jitl.common.block.entity.SummoningTableTile;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;

public class SummoningTableRenderer
implements BlockEntityRenderer<SummoningTableTile, SummoningTableRenderState> {
    private final ItemModelResolver itemModelResolver;

    public SummoningTableRenderer(BlockEntityRendererProvider.Context context) {
        this.itemModelResolver = context.itemModelResolver();
    }

    @NotNull
    public SummoningTableRenderState createRenderState() {
        return new SummoningTableRenderState();
    }

    public void extractRenderState(SummoningTableTile tile, SummoningTableRenderState state, float ticks, Vec3 v, @Nullable ModelFeatureRenderer.CrumblingOverlay o) {
        super.extractRenderState((BlockEntity)tile, (BlockEntityRenderState)state, ticks, v, o);
        int i = (int)tile.getBlockPos().asLong();
        state.items = new ArrayList<ItemStackRenderState>();
        for (int j = 0; j < tile.getItems().size(); ++j) {
            ItemStackRenderState itemstackrenderstate = new ItemStackRenderState();
            this.itemModelResolver.updateForTopItem(itemstackrenderstate, tile.getItemInSlot(j), ItemDisplayContext.FIXED, tile.getLevel(), null, i + j);
            state.items.add(itemstackrenderstate);
        }
    }

    public void submit(SummoningTableRenderState summoningTableRenderState, PoseStack poseStack, SubmitNodeCollector submitNodeCollector, CameraRenderState cameraRenderState) {
        double y = 1.0;
        this.renderItem(summoningTableRenderState, 0, new double[]{0.85, y, 0.85}, poseStack, submitNodeCollector, 0.7f);
        this.renderItem(summoningTableRenderState, 1, new double[]{0.85, y, 0.5}, poseStack, submitNodeCollector, 0.7f);
        this.renderItem(summoningTableRenderState, 2, new double[]{0.85, y, 0.15}, poseStack, submitNodeCollector, 0.7f);
        this.renderItem(summoningTableRenderState, 3, new double[]{0.5, y, 0.5}, poseStack, submitNodeCollector, 1.0f);
        this.renderItem(summoningTableRenderState, 4, new double[]{0.15, y, 0.85}, poseStack, submitNodeCollector, 0.7f);
        this.renderItem(summoningTableRenderState, 5, new double[]{0.15, y, 0.5}, poseStack, submitNodeCollector, 0.7f);
        this.renderItem(summoningTableRenderState, 6, new double[]{0.15, y, 0.15}, poseStack, submitNodeCollector, 0.7f);
    }

    private void renderItem(SummoningTableRenderState state, int itemIndex, double[] translation, PoseStack matrixStack, SubmitNodeCollector collector, float scale) {
        ItemStackRenderState item = state.items.get(itemIndex);
        if (!item.isEmpty()) {
            matrixStack.pushPose();
            float timeD = (float)(360.0 * (double)(System.currentTimeMillis() & 0x3FFFL) / 16383.0) / 16.0f;
            matrixStack.translate(translation[0], translation[1], translation[2]);
            matrixStack.mulPose((Quaternionfc)Axis.YP.rotation(timeD));
            matrixStack.scale(scale, scale, scale);
            item.submit(matrixStack, collector, state.lightCoords, OverlayTexture.NO_OVERLAY, 0);
            matrixStack.popPose();
        }
    }
}

