/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.client.render.projectile;

import com.mojang.blaze3d.vertex.PoseStack;
import net.jitl.client.JModelLayers;
import net.jitl.client.model.JItemModel;
import net.jitl.client.render.projectile.state.TwoDRenderState;
import net.minecraft.client.model.Model;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionfc;

public class RenderProjectile<T extends Entity>
extends EntityRenderer<T, TwoDRenderState> {
    private final ResourceLocation texture;
    private final JItemModel model;

    public RenderProjectile(EntityRendererProvider.Context context, ResourceLocation texture) {
        super(context);
        this.texture = texture;
        this.model = new JItemModel(context.bakeLayer(JModelLayers.ITEM_MODEL));
    }

    public void submit(TwoDRenderState renderState, PoseStack poseStack, SubmitNodeCollector nodeCollector, CameraRenderState cameraRenderState) {
        poseStack.pushPose();
        poseStack.mulPose((Quaternionfc)cameraRenderState.orientation);
        poseStack.translate(0.0f, -0.3f, 0.0f);
        float scale = 0.35f;
        poseStack.scale(scale, scale, scale);
        nodeCollector.submitModel((Model)this.model, (Object)renderState, poseStack, this.model.renderType(renderState.texture), renderState.lightCoords, OverlayTexture.NO_OVERLAY, renderState.outlineColor, null);
        poseStack.popPose();
    }

    public void extractRenderState(@NotNull T entity, @NotNull TwoDRenderState state, float partialTick) {
        super.extractRenderState(entity, (EntityRenderState)state, partialTick);
        state.texture = this.texture;
    }

    @NotNull
    public TwoDRenderState createRenderState() {
        return new TwoDRenderState();
    }

    protected int getBlockLightLevel(@NotNull T entity, @NotNull BlockPos pos) {
        return 15;
    }
}

