/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.client.render.world;

import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.ByteBufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import net.jitl.client.render.world.clouds.JCloudRenderer;
import net.minecraft.client.Camera;
import net.minecraft.client.CloudStatus;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.state.LevelRenderState;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import org.joml.Vector4fc;

public abstract class JDimensionSpecialEffects
extends DimensionSpecialEffects {
    private final GpuBuffer topSkyBuffer;
    private final GpuBuffer bottomSkyBuffer;
    private final RenderSystem.AutoStorageIndexBuffer quadIndices;

    public JDimensionSpecialEffects(DimensionSpecialEffects.SkyType type, boolean forceBrightLightmap, boolean constantAmbientLight) {
        super(type, forceBrightLightmap, constantAmbientLight);
        try (ByteBufferBuilder bytebufferbuilder = ByteBufferBuilder.exactlySized((int)(10 * DefaultVertexFormat.POSITION.getVertexSize()));){
            BufferBuilder bufferbuilder = new BufferBuilder(bytebufferbuilder, VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.POSITION);
            this.buildSkyDisc((VertexConsumer)bufferbuilder, 16.0f);
            try (MeshData meshdata = bufferbuilder.buildOrThrow();){
                this.topSkyBuffer = RenderSystem.getDevice().createBuffer(() -> "Top sky vertex buffer", 32, meshdata.vertexBuffer());
            }
            bufferbuilder = new BufferBuilder(bytebufferbuilder, VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.POSITION);
            this.buildSkyDisc((VertexConsumer)bufferbuilder, -16.0f);
            try (MeshData meshdata1 = bufferbuilder.buildOrThrow();){
                this.bottomSkyBuffer = RenderSystem.getDevice().createBuffer(() -> "Bottom sky vertex buffer", 32, meshdata1.vertexBuffer());
            }
        }
        this.quadIndices = RenderSystem.getSequentialBuffer((VertexFormat.Mode)VertexFormat.Mode.QUADS);
    }

    private void buildSkyDisc(VertexConsumer buffer, float y) {
        float f = Math.signum(y) * 512.0f;
        buffer.addVertex(0.0f, y, 0.0f);
        for (int i = -180; i <= 180; i += 45) {
            buffer.addVertex(f * Mth.cos((float)((float)i * ((float)Math.PI / 180))), y, 512.0f * Mth.sin((float)((float)i * ((float)Math.PI / 180))));
        }
    }

    private AbstractTexture getTexture(ResourceLocation location) {
        TextureManager texturemanager = Minecraft.getInstance().getTextureManager();
        AbstractTexture abstracttexture = texturemanager.getTexture(location);
        abstracttexture.setUseMipmaps(false);
        return abstracttexture;
    }

    public void renderSun(float size, float alpha, PoseStack poseStack, ResourceLocation tex) {
        AbstractTexture texture = this.getTexture(tex);
        Matrix4fStack matrix4fstack = RenderSystem.getModelViewStack();
        matrix4fstack.pushMatrix();
        matrix4fstack.mul((Matrix4fc)poseStack.last().pose());
        GpuBufferSlice gpubufferslice = RenderSystem.getDynamicUniforms().writeTransform((Matrix4fc)matrix4fstack, (Vector4fc)new Vector4f(alpha, alpha, alpha, alpha), (Vector3fc)new Vector3f(), (Matrix4fc)new Matrix4f(), 0.0f);
        GpuBuffer gpubuffer = this.quadIndices.getBuffer(6);
        try (RenderPass renderpass = RenderSystem.getDevice().createCommandEncoder().createRenderPass(() -> "Journey Sun", Minecraft.getInstance().getMainRenderTarget().getColorTextureView(), OptionalInt.empty(), Minecraft.getInstance().getMainRenderTarget().getDepthTextureView(), OptionalDouble.empty());){
            renderpass.setPipeline(RenderPipelines.CELESTIAL);
            RenderSystem.bindDefaultUniforms((RenderPass)renderpass);
            renderpass.setUniform("DynamicTransforms", gpubufferslice);
            renderpass.bindSampler("Sampler0", texture.getTextureView());
            Matrix4f matrix4f = poseStack.last().pose();
            renderpass.setVertexBuffer(0, this.buildSunQuad(matrix4f, size, alpha));
            renderpass.setIndexBuffer(gpubuffer, this.quadIndices.type());
            renderpass.drawIndexed(0, 0, 6, 1);
        }
        matrix4fstack.popMatrix();
    }

    private GpuBuffer buildSunQuad(Matrix4f matrix4f, float size, float alpha) {
        GpuBuffer gpubuffer;
        int i = ARGB.white((float)alpha);
        try (ByteBufferBuilder bytebufferbuilder = ByteBufferBuilder.exactlySized((int)(4 * DefaultVertexFormat.POSITION_TEX.getVertexSize()));){
            BufferBuilder bufferbuilder = new BufferBuilder(bytebufferbuilder, VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
            bufferbuilder.addVertex(matrix4f, -size, 100.0f, -size).setUv(0.0f, 0.0f).setColor(i);
            bufferbuilder.addVertex(matrix4f, size, 100.0f, -size).setUv(1.0f, 0.0f).setColor(i);
            bufferbuilder.addVertex(matrix4f, size, 100.0f, size).setUv(1.0f, 1.0f).setColor(i);
            bufferbuilder.addVertex(matrix4f, -size, 100.0f, size).setUv(0.0f, 1.0f).setColor(i);
            try (MeshData meshdata = bufferbuilder.buildOrThrow();){
                gpubuffer = RenderSystem.getDevice().createBuffer(() -> "Sun quad", 40, meshdata.vertexBuffer());
            }
        }
        return gpubuffer;
    }

    protected void renderSky(ResourceLocation texture) {
        this.renderSky(texture, 1.0f);
    }

    protected void renderSky(ResourceLocation texture, float brightness) {
        TextureManager texturemanager = Minecraft.getInstance().getTextureManager();
        AbstractTexture abstracttexture = texturemanager.getTexture(texture);
        abstracttexture.setUseMipmaps(false);
        RenderSystem.AutoStorageIndexBuffer rendersystem$autostorageindexbuffer = RenderSystem.getSequentialBuffer((VertexFormat.Mode)VertexFormat.Mode.QUADS);
        GpuBuffer gpubuffer = rendersystem$autostorageindexbuffer.getBuffer(36);
        GpuTextureView gputextureview = Minecraft.getInstance().getMainRenderTarget().getColorTextureView();
        GpuTextureView gputextureview1 = Minecraft.getInstance().getMainRenderTarget().getDepthTextureView();
        GpuBufferSlice gpubufferslice = RenderSystem.getDynamicUniforms().writeTransform((Matrix4fc)RenderSystem.getModelViewMatrix(), (Vector4fc)new Vector4f(brightness, brightness, brightness, brightness), (Vector3fc)new Vector3f(), (Matrix4fc)new Matrix4f(), 0.0f);
        try (RenderPass renderpass = RenderSystem.getDevice().createCommandEncoder().createRenderPass(() -> "Journey Sky", gputextureview, OptionalInt.empty(), gputextureview1, OptionalDouble.empty());){
            renderpass.setPipeline(RenderPipelines.END_SKY);
            RenderSystem.bindDefaultUniforms((RenderPass)renderpass);
            renderpass.setUniform("DynamicTransforms", gpubufferslice);
            renderpass.bindSampler("Sampler0", abstracttexture.getTextureView());
            renderpass.setVertexBuffer(0, JDimensionSpecialEffects.buildSky());
            renderpass.setIndexBuffer(gpubuffer, rendersystem$autostorageindexbuffer.type());
            renderpass.drawIndexed(0, 0, 36, 1);
        }
    }

    public void renderSkyDisc(float red, float green, float blue) {
        GpuBufferSlice gpubufferslice = RenderSystem.getDynamicUniforms().writeTransform((Matrix4fc)RenderSystem.getModelViewMatrix(), (Vector4fc)new Vector4f(red, green, blue, 1.0f), (Vector3fc)new Vector3f(), (Matrix4fc)new Matrix4f(), 0.0f);
        GpuTextureView gputextureview = Minecraft.getInstance().getMainRenderTarget().getColorTextureView();
        GpuTextureView gputextureview1 = Minecraft.getInstance().getMainRenderTarget().getDepthTextureView();
        try (RenderPass renderpass = RenderSystem.getDevice().createCommandEncoder().createRenderPass(() -> "Sky disc", gputextureview, OptionalInt.empty(), gputextureview1, OptionalDouble.empty());){
            renderpass.setPipeline(RenderPipelines.SKY);
            RenderSystem.bindDefaultUniforms((RenderPass)renderpass);
            renderpass.setUniform("DynamicTransforms", gpubufferslice);
            renderpass.setVertexBuffer(0, this.topSkyBuffer);
            renderpass.draw(0, 10);
        }
    }

    public void renderDarkDisc() {
        Matrix4fStack matrix4fstack = RenderSystem.getModelViewStack();
        matrix4fstack.pushMatrix();
        matrix4fstack.translate(0.0f, 12.0f, 0.0f);
        GpuBufferSlice gpubufferslice = RenderSystem.getDynamicUniforms().writeTransform((Matrix4fc)matrix4fstack, (Vector4fc)new Vector4f(0.0f, 0.0f, 0.0f, 1.0f), (Vector3fc)new Vector3f(), (Matrix4fc)new Matrix4f(), 0.0f);
        GpuTextureView gputextureview = Minecraft.getInstance().getMainRenderTarget().getColorTextureView();
        GpuTextureView gputextureview1 = Minecraft.getInstance().getMainRenderTarget().getDepthTextureView();
        try (RenderPass renderpass = RenderSystem.getDevice().createCommandEncoder().createRenderPass(() -> "Sky dark", gputextureview, OptionalInt.empty(), gputextureview1, OptionalDouble.empty());){
            renderpass.setPipeline(RenderPipelines.SKY);
            RenderSystem.bindDefaultUniforms((RenderPass)renderpass);
            renderpass.setUniform("DynamicTransforms", gpubufferslice);
            renderpass.setVertexBuffer(0, this.bottomSkyBuffer);
            renderpass.draw(0, 10);
        }
        matrix4fstack.popMatrix();
    }

    protected static GpuBuffer buildSky() {
        GpuBuffer gpubuffer;
        try (ByteBufferBuilder bytebufferbuilder = ByteBufferBuilder.exactlySized((int)(24 * DefaultVertexFormat.POSITION_TEX_COLOR.getVertexSize()));){
            BufferBuilder bufferbuilder = new BufferBuilder(bytebufferbuilder, VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
            for (int i = 0; i < 6; ++i) {
                Matrix4f matrix4f = new Matrix4f();
                switch (i) {
                    case 1: {
                        matrix4f.rotationX(1.5707964f);
                        break;
                    }
                    case 2: {
                        matrix4f.rotationX(-1.5707964f);
                        break;
                    }
                    case 3: {
                        matrix4f.rotationX((float)Math.PI);
                        break;
                    }
                    case 4: {
                        matrix4f.rotationZ(1.5707964f);
                        break;
                    }
                    case 5: {
                        matrix4f.rotationZ(-1.5707964f);
                    }
                }
                bufferbuilder.addVertex(matrix4f, -100.0f, -100.0f, -100.0f).setUv(0.0f, 0.0f).setColor(-14145496);
                bufferbuilder.addVertex(matrix4f, -100.0f, -100.0f, 100.0f).setUv(0.0f, 16.0f).setColor(-14145496);
                bufferbuilder.addVertex(matrix4f, 100.0f, -100.0f, 100.0f).setUv(16.0f, 16.0f).setColor(-14145496);
                bufferbuilder.addVertex(matrix4f, 100.0f, -100.0f, -100.0f).setUv(16.0f, 0.0f).setColor(-14145496);
            }
            try (MeshData meshdata = bufferbuilder.buildOrThrow();){
                gpubuffer = RenderSystem.getDevice().createBuffer(() -> "sky vertex buffer", 40, meshdata.vertexBuffer());
            }
        }
        return gpubuffer;
    }

    public boolean renderClouds(LevelRenderState levelRenderState, Vec3 camPos, CloudStatus cloudStatus, int cloudColor, float cloudHeight, Matrix4f modelViewMatrix) {
        this.getCloudRenderer().render(cloudColor, cloudStatus, cloudHeight, camPos, levelRenderState.skyRenderState.timeOfDay);
        return true;
    }

    public abstract JCloudRenderer getCloudRenderer();

    public boolean doesMobEffectBlockSky(Camera camera) {
        Entity entity = camera.getEntity();
        if (!(entity instanceof LivingEntity)) {
            return false;
        }
        LivingEntity livingentity = (LivingEntity)entity;
        return livingentity.hasEffect(MobEffects.BLINDNESS) || livingentity.hasEffect(MobEffects.DARKNESS);
    }
}

