/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.block;

import javax.annotation.Nullable;
import net.jitl.common.block.entity.IridiumCampfireBlockEntity;
import net.jitl.core.init.internal.JBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CampfireCookingRecipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipePropertySet;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;

public class IridiumCampfireBlock
extends CampfireBlock {
    public IridiumCampfireBlock(BlockBehaviour.Properties props) {
        super(true, 1, props);
    }

    protected InteractionResult useItemOn(ItemStack p_316347_, BlockState p_51274_, Level p_51275_, BlockPos p_51276_, Player p_51277_, InteractionHand p_51278_, BlockHitResult p_51279_) {
        BlockEntity blockEntity = p_51275_.getBlockEntity(p_51276_);
        if (blockEntity instanceof IridiumCampfireBlockEntity) {
            IridiumCampfireBlockEntity campfireblockentity = (IridiumCampfireBlockEntity)blockEntity;
            ItemStack itemstack = p_51277_.getItemInHand(p_51278_);
            if (p_51275_.recipeAccess().propertySet(RecipePropertySet.CAMPFIRE_INPUT).test(itemstack)) {
                ServerLevel serverlevel;
                if (p_51275_ instanceof ServerLevel && campfireblockentity.placeFood(serverlevel = (ServerLevel)p_51275_, (LivingEntity)p_51277_, itemstack)) {
                    p_51277_.awardStat(Stats.INTERACT_WITH_CAMPFIRE);
                    return InteractionResult.SUCCESS_SERVER;
                }
                return InteractionResult.CONSUME;
            }
        }
        return InteractionResult.TRY_WITH_EMPTY_HAND;
    }

    public static void dowse(@Nullable Entity entity, LevelAccessor level, BlockPos pos, BlockState state) {
        if (level.isClientSide()) {
            for (int i = 0; i < 20; ++i) {
                IridiumCampfireBlock.makeParticles((Level)((Level)level), (BlockPos)pos, (boolean)((Boolean)state.getValue((Property)SIGNAL_FIRE)), (boolean)true);
            }
        }
        level.gameEvent(entity, (Holder)GameEvent.BLOCK_CHANGE, pos);
    }

    public boolean placeLiquid(LevelAccessor pLevel, BlockPos pPos, BlockState pState, FluidState pFluidState) {
        if (!((Boolean)pState.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue() && pFluidState.getType() == Fluids.WATER) {
            boolean flag = (Boolean)pState.getValue((Property)LIT);
            if (flag) {
                if (!pLevel.isClientSide()) {
                    pLevel.playSound(null, pPos, SoundEvents.GENERIC_EXTINGUISH_FIRE, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
                IridiumCampfireBlock.dowse(null, pLevel, pPos, pState);
            }
            pLevel.setBlock(pPos, (BlockState)((BlockState)pState.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true))).setValue((Property)LIT, (Comparable)Boolean.valueOf(false)), 3);
            pLevel.scheduleTick(pPos, pFluidState.getType(), pFluidState.getType().getTickDelay((LevelReader)pLevel));
            return true;
        }
        return false;
    }

    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return new IridiumCampfireBlockEntity(pPos, pState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level p_152755_, BlockState p_152756_, BlockEntityType<T> p_152757_) {
        if (p_152755_ instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)p_152755_;
            if (((Boolean)p_152756_.getValue((Property)LIT)).booleanValue()) {
                RecipeManager.CachedCheck cachedcheck = RecipeManager.createCheck((RecipeType)RecipeType.CAMPFIRE_COOKING);
                return IridiumCampfireBlock.createTickerHelper(p_152757_, (BlockEntityType)((BlockEntityType)JBlockEntities.IRIDIUM_CAMPFIRE.get()), (p_379259_, p_379260_, p_379261_, p_379262_) -> IridiumCampfireBlockEntity.cookTick(serverlevel, p_379260_, p_379261_, p_379262_, (RecipeManager.CachedCheck<SingleRecipeInput, CampfireCookingRecipe>)cachedcheck));
            }
            return IridiumCampfireBlock.createTickerHelper(p_152757_, (BlockEntityType)((BlockEntityType)JBlockEntities.IRIDIUM_CAMPFIRE.get()), IridiumCampfireBlockEntity::cooldownTick);
        }
        return (Boolean)p_152756_.getValue((Property)LIT) != false ? IridiumCampfireBlock.createTickerHelper(p_152757_, (BlockEntityType)((BlockEntityType)JBlockEntities.IRIDIUM_CAMPFIRE.get()), IridiumCampfireBlockEntity::particleTick) : null;
    }
}

