/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.block;

import com.mojang.serialization.MapCodec;
import net.jitl.common.entity.boss.RockiteSmasher;
import net.jitl.common.items.base.MultitoolItem;
import net.jitl.core.init.internal.JBlockEntities;
import net.jitl.core.init.internal.JEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RockiteBlock
extends BaseEntityBlock {
    public static final MapCodec<RockiteBlock> CODEC = RockiteBlock.simpleCodec(RockiteBlock::new);
    private static final VoxelShape BASE = Block.box((double)-16.0, (double)0.0, (double)-16.0, (double)32.0, (double)40.0, (double)16.0);
    private static final VoxelShape SHAPE = Shapes.or((VoxelShape)BASE, (VoxelShape[])new VoxelShape[0]);

    public RockiteBlock(BlockBehaviour.Properties p) {
        super(p);
    }

    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return ((BlockEntityType)JBlockEntities.ROCKITE.get()).create(pos, state);
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE;
    }

    public void animateTick(BlockState pState, Level pLevel, BlockPos pPos, RandomSource pRandom) {
        for (int i = 0; i < 10; ++i) {
            if (pRandom.nextInt(8) != 0) continue;
            double d0 = (double)pPos.getX() + (double)pRandom.nextFloat();
            double d1 = (double)pPos.getY() + 1.0;
            double d2 = (double)pPos.getZ() + (double)pRandom.nextFloat();
            pLevel.addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.FALLING_DUST, pState), d0, d1, d2, 0.0, 0.0, 0.0);
        }
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, ItemStack toolStack, boolean willHarvest, FluidState fluid) {
        if (player.isCreative() || player.getMainHandItem().getItem().getName(player.getMainHandItem()).contains((Component)Component.literal((String)"pickaxe")) || player.getMainHandItem().getItem() instanceof MultitoolItem || player.getMainHandItem().getItem().getName(player.getMainHandItem()).contains((Component)Component.literal((String)"shickaxe"))) {
            level.explode(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), 1.0f, Level.ExplosionInteraction.BLOCK);
            RockiteSmasher entity = new RockiteSmasher((EntityType<? extends Monster>)((EntityType)JEntities.ROCKITE_SMASHER_TYPE.get()), level);
            entity.setPos((float)pos.getX() + 0.5f, (float)pos.getY() + 0.5f, (float)pos.getZ() + 0.5f);
            level.addFreshEntity((Entity)entity);
            level.setBlock(pos, Blocks.AIR.defaultBlockState(), 2);
            return true;
        }
        return false;
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return null;
    }

    @NotNull
    public RenderShape getRenderShape(BlockState pState) {
        return RenderShape.INVISIBLE;
    }
}

